/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.generic;

import java.util.List;
import org.iplass.gem.AutoGenerateSetting;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinition;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.AutoNumberPropertyEditor;
import org.iplass.mtp.view.generic.editor.BinaryPropertyEditor;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.DateTimePropertyEditor;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.ExpressionPropertyEditor;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.LongTextPropertyEditor;
import org.iplass.mtp.view.generic.editor.NumberPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.editor.StringPropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.generic.element.section.VersionSection;

public class FormViewUtil {
    public static SearchFormView getSearchFormView(EntityDefinition ed, EntityView ev, String viewName) {
        SearchFormView form = null;
        if (ev != null) {
            if (ev.isAutoGenerateSearchView(viewName)) {
                form = FormViewUtil.createDefaultSearchFormView(ed);
                form.setName(viewName);
            } else {
                form = ev.getSearchFormView(viewName);
            }
        }
        if (form == null && StringUtil.isEmpty((String)viewName)) {
            form = FormViewUtil.createDefaultSearchFormView(ed);
        }
        return form;
    }

    public static BulkFormView getBulkFormView(EntityDefinition ed, EntityView ev, String viewName) {
        BulkFormView form = null;
        if (ev != null) {
            if (ev.isAutoGenerateBulkView(viewName)) {
                form = FormViewUtil.createDefaultBulkFormView(ed);
                form.setName(viewName);
            } else {
                form = ev.getBulkFormView(viewName);
            }
        }
        if (form == null && StringUtil.isEmpty((String)viewName)) {
            form = FormViewUtil.createDefaultBulkFormView(ed);
        }
        return form;
    }

    public static SearchFormView createDefaultSearchFormView(EntityDefinition ed) {
        return FormViewUtil.createDefaultSearchFormView(ed, true);
    }

    public static SearchFormView createDefaultSearchFormView(EntityDefinition ed, boolean isLoadDisplayLabel) {
        SearchFormView view = new SearchFormView();
        SearchConditionSection condSection = new SearchConditionSection();
        condSection.setColNum(1);
        condSection.setConditionDispCount(5);
        GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        AutoGenerateSetting setting = service.getAutoGenerateSetting();
        if (setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.TOP) {
            FormViewUtil.createSystemSearchConditionItem(condSection, ed, isLoadDisplayLabel, setting);
        }
        condSection.addElement(FormViewUtil.createNameProperty(ed.getProperty("name"), isLoadDisplayLabel));
        if (ed.getVersionControlType() == VersionControlType.TIMEBASE || ed.getVersionControlType() == VersionControlType.SIMPLE_TIMEBASE) {
            condSection.addElement(FormViewUtil.createTimestampProperty(ed.getProperty("startDate"), isLoadDisplayLabel));
            condSection.addElement(FormViewUtil.createTimestampProperty(ed.getProperty("endDate"), isLoadDisplayLabel));
        }
        for (PropertyDefinition pd : ed.getDeclaredPropertyList()) {
            ReferenceProperty rp;
            if (pd instanceof BinaryProperty || pd instanceof ReferenceProperty && (rp = (ReferenceProperty)pd).getMultiplicity() != 1) continue;
            PropertyItem p = new PropertyItem();
            p.setDispFlag(true);
            p.setPropertyName(pd.getName());
            if (isLoadDisplayLabel) {
                p.setDisplayLabel(pd.getDisplayName());
                p.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
            }
            p.setEditor(FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel));
            condSection.addElement(p);
        }
        if (setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.BOTTOM) {
            FormViewUtil.createSystemSearchConditionItem(condSection, ed, isLoadDisplayLabel, setting);
        }
        view.addSection(condSection);
        SearchResultSection resultSection = new SearchResultSection();
        if (setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.TOP) {
            FormViewUtil.createSystemSearchResultColumn(resultSection, ed, isLoadDisplayLabel, setting);
        }
        resultSection.addElement(FormViewUtil.createNamePropertyColumn(ed.getProperty("name"), isLoadDisplayLabel));
        if (ed.getVersionControlType() == VersionControlType.TIMEBASE) {
            resultSection.addElement(FormViewUtil.createTimestampPropertyColumn(ed.getProperty("startDate"), isLoadDisplayLabel));
            resultSection.addElement(FormViewUtil.createTimestampPropertyColumn(ed.getProperty("endDate"), isLoadDisplayLabel));
        }
        for (PropertyDefinition pd : ed.getDeclaredPropertyList()) {
            ReferenceProperty rp;
            if (pd instanceof BinaryProperty || pd instanceof ReferenceProperty && (rp = (ReferenceProperty)pd).getMultiplicity() != 1) continue;
            PropertyColumn p = new PropertyColumn();
            p.setDispFlag(true);
            p.setPropertyName(pd.getName());
            if (isLoadDisplayLabel) {
                p.setDisplayLabel(pd.getDisplayName());
                p.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
            }
            p.setEditor(FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel));
            resultSection.addElement(p);
        }
        if (setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.BOTTOM) {
            FormViewUtil.createSystemSearchResultColumn(resultSection, ed, isLoadDisplayLabel, setting);
        }
        view.addSection(resultSection);
        return view;
    }

    public static DetailFormView getDetailFormView(EntityDefinition ed, EntityView ev, String viewName) {
        DetailFormView form = null;
        if (ev != null) {
            if (ev.isAutoGenerateDetailView(viewName)) {
                form = FormViewUtil.createDefaultDetailFormView(ed);
                form.setName(viewName);
            } else {
                form = ev.getDetailFormView(viewName);
            }
        }
        if (form == null && StringUtil.isEmpty((String)viewName)) {
            form = FormViewUtil.createDefaultDetailFormView(ed);
        }
        return form;
    }

    public static DetailFormView createDefaultDetailFormView(EntityDefinition ed) {
        return FormViewUtil.createDefaultDetailFormView(ed, true);
    }

    public static DetailFormView createDefaultDetailFormView(EntityDefinition ed, boolean isLoadDisplayLabel) {
        DetailFormView view = new DetailFormView();
        view.setLoadDefinedReferenceProperty(true);
        DefaultSection baseSection = FormViewUtil.createBasicSection(ed, isLoadDisplayLabel);
        if (ed.getVersionControlType() == VersionControlType.TIMEBASE || ed.getVersionControlType() == VersionControlType.SIMPLE_TIMEBASE) {
            baseSection.addElement(FormViewUtil.createTimestampProperty(ed.getProperty("startDate"), isLoadDisplayLabel));
            baseSection.addElement(FormViewUtil.createTimestampProperty(ed.getProperty("endDate"), isLoadDisplayLabel));
        }
        DefaultSection objectSection = FormViewUtil.createObjectSection(ed, isLoadDisplayLabel);
        GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        AutoGenerateSetting setting = service.getAutoGenerateSetting();
        DefaultSection systemSection = FormViewUtil.createSystemSection(ed, isLoadDisplayLabel, setting);
        if (systemSection != null && setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.TOP) {
            view.addSection(systemSection);
        }
        view.addSection(baseSection);
        view.addSection(objectSection);
        if (systemSection != null && setting.getSystemPropertyDisplayPosition() == AutoGenerateSetting.DisplayPosition.BOTTOM) {
            view.addSection(systemSection);
        }
        if (ed.getVersionControlType() != VersionControlType.NONE) {
            VersionSection vs = new VersionSection();
            vs.setDispFlag(true);
            view.addSection(vs);
        }
        return view;
    }

    public static BulkFormView createDefaultBulkFormView(EntityDefinition ed) {
        return FormViewUtil.createDefaultBulkFormView(ed, true);
    }

    public static BulkFormView createDefaultBulkFormView(EntityDefinition ed, boolean isLoadDisplayLabel) {
        BulkFormView view = new BulkFormView();
        DefaultSection baseSection = FormViewUtil.createBasicSection(ed, isLoadDisplayLabel);
        DefaultSection objectSection = FormViewUtil.createObjectSection(ed, isLoadDisplayLabel);
        view.addSection(baseSection);
        view.addSection(objectSection);
        return view;
    }

    private static DefaultSection createBasicSection(EntityDefinition ed, boolean isLoadDisplayLabel) {
        DefaultSection section = new DefaultSection();
        section.setDispFlag(true);
        section.setColNum(1);
        section.setExpandable(true);
        section.setStyle("auto-generate-basic-info");
        section.setTitle(FormViewUtil.resourceString("generic.element.section.DefaultSection.basicInfo", new Object[0]));
        section.setLocalizedTitleList(FormViewUtil.resourceList("generic.element.section.DefaultSection.basicInfo", new Object[0]));
        section.addElement(FormViewUtil.createNameProperty(ed.getProperty("name"), isLoadDisplayLabel));
        section.addElement(FormViewUtil.createDescriptionProperty(ed.getProperty("description"), isLoadDisplayLabel));
        return section;
    }

    private static DefaultSection createObjectSection(EntityDefinition ed, boolean isLoadDisplayLabel) {
        DefaultSection section = new DefaultSection();
        section.setDispFlag(true);
        section.setColNum(1);
        section.setExpandable(true);
        section.setStyle("auto-generate-object-info");
        section.setTitle(FormViewUtil.resourceString("generic.element.section.DefaultSection.objectInfo", new Object[0]));
        section.setLocalizedTitleList(FormViewUtil.resourceList("generic.element.section.DefaultSection.objectInfo", new Object[0]));
        for (PropertyDefinition pd : ed.getDeclaredPropertyList()) {
            PropertyItem p = new PropertyItem();
            p.setDispFlag(true);
            if (isLoadDisplayLabel) {
                p.setDisplayLabel(pd.getDisplayName());
            }
            p.setEditor(FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel));
            p.setPropertyName(pd.getName());
            if (isLoadDisplayLabel) {
                p.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
            }
            section.addElement(p);
        }
        return section;
    }

    private static DefaultSection createSystemSection(EntityDefinition ed, boolean isLoadDisplayLabel, AutoGenerateSetting setting) {
        if (!setting.isShowSystemProperty()) {
            return null;
        }
        DefaultSection section = new DefaultSection();
        section.setDispFlag(true);
        section.setColNum(1);
        section.setExpandable(true);
        section.setStyle("auto-generate-system-info");
        section.setTitle(FormViewUtil.resourceString("generic.element.section.DefaultSection.systemInfo", new Object[0]));
        section.setLocalizedTitleList(FormViewUtil.resourceList("generic.element.section.DefaultSection.systemInfo", new Object[0]));
        for (String propName : setting.getSystemProperties()) {
            PropertyItem item = FormViewUtil.createSystemPropertyItems(propName, ed, isLoadDisplayLabel, true, setting);
            if (item == null) continue;
            section.addElement(item);
        }
        return section;
    }

    private static void createSystemSearchConditionItem(SearchConditionSection section, EntityDefinition ed, boolean isLoadDisplayLabel, AutoGenerateSetting setting) {
        if (!setting.isShowSystemProperty()) {
            return;
        }
        for (String propName : setting.getSystemProperties()) {
            PropertyItem item = FormViewUtil.createSystemPropertyItems(propName, ed, isLoadDisplayLabel, false, setting);
            if (item == null) continue;
            section.addElement(item);
        }
    }

    private static PropertyItem createSystemPropertyItems(String propName, EntityDefinition ed, boolean isLoadDisplayLabel, boolean isReadOnly, AutoGenerateSetting setting) {
        if ("oid".equals(propName) && ed.getOidPropertyName() != null && setting.isExcludeOidWhenCustomOid()) {
            return null;
        }
        if ("version".equals(propName) && ed.getVersionControlType() != VersionControlType.VERSIONED) {
            return null;
        }
        PropertyDefinition pd = ed.getProperty(propName);
        PropertyItem item = new PropertyItem();
        item.setDispFlag(true);
        item.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            item.setDisplayLabel(pd.getDisplayName());
            item.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        if (("createBy".equals(propName) || "updateBy".equals(propName) || "lockedBy".equals(propName)) && setting.isUseUserPropertyEditor()) {
            item.setEditor(new UserPropertyEditor());
        } else {
            item.setEditor(FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel, isReadOnly));
        }
        return item;
    }

    private static void createSystemSearchResultColumn(SearchResultSection section, EntityDefinition ed, boolean isLoadDisplayLabel, AutoGenerateSetting setting) {
        if (!setting.isShowSystemProperty()) {
            return;
        }
        for (String propName : setting.getSystemProperties()) {
            if ("oid".equals(propName) && ed.getOidPropertyName() != null && setting.isExcludeOidWhenCustomOid() || "version".equals(propName) && ed.getVersionControlType() != VersionControlType.VERSIONED) continue;
            PropertyDefinition pd = ed.getProperty(propName);
            PropertyColumn column = new PropertyColumn();
            column.setDispFlag(true);
            column.setPropertyName(pd.getName());
            if (isLoadDisplayLabel) {
                column.setDisplayLabel(pd.getDisplayName());
                column.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
            }
            if (("createBy".equals(propName) || "updateBy".equals(propName) || "lockedBy".equals(propName)) && setting.isUseUserPropertyEditor()) {
                column.setEditor(new UserPropertyEditor());
            } else {
                column.setEditor(FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel, false));
            }
            section.addElement(column);
        }
    }

    private static PropertyColumn createNamePropertyColumn(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        PropertyColumn property = new PropertyColumn();
        property.setDispFlag(true);
        if (isLoadDisplayLabel) {
            property.setDisplayLabel(pd.getDisplayName());
        }
        StringPropertyEditor editor = new StringPropertyEditor();
        editor.setDisplayType(StringPropertyEditor.StringDisplayType.TEXT);
        property.setEditor(editor);
        property.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            property.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        return property;
    }

    private static PropertyItem createNameProperty(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        PropertyItem property = new PropertyItem();
        property.setDispFlag(true);
        if (isLoadDisplayLabel) {
            property.setDisplayLabel(pd.getDisplayName());
        }
        StringPropertyEditor editor = new StringPropertyEditor();
        editor.setDisplayType(StringPropertyEditor.StringDisplayType.TEXT);
        property.setEditor(editor);
        property.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            property.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        return property;
    }

    private static PropertyItem createDescriptionProperty(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        PropertyItem property = new PropertyItem();
        property.setDispFlag(true);
        if (isLoadDisplayLabel) {
            property.setDisplayLabel(pd.getDisplayName());
        }
        StringPropertyEditor editor = new StringPropertyEditor();
        editor.setDisplayType(StringPropertyEditor.StringDisplayType.TEXTAREA);
        property.setEditor(editor);
        property.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            property.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        return property;
    }

    private static PropertyColumn createTimestampPropertyColumn(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        PropertyColumn property = new PropertyColumn();
        property.setDispFlag(true);
        if (isLoadDisplayLabel) {
            property.setDisplayLabel(pd.getDisplayName());
        }
        TimestampPropertyEditor editor = new TimestampPropertyEditor();
        editor.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.DATETIME);
        editor.setUseDatetimePicker(true);
        property.setEditor(editor);
        property.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            property.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        return property;
    }

    private static PropertyItem createTimestampProperty(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        PropertyItem property = new PropertyItem();
        property.setDispFlag(true);
        if (isLoadDisplayLabel) {
            property.setDisplayLabel(pd.getDisplayName());
        }
        TimestampPropertyEditor editor = new TimestampPropertyEditor();
        editor.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.DATETIME);
        editor.setUseDatetimePicker(true);
        property.setEditor(editor);
        property.setPropertyName(pd.getName());
        if (isLoadDisplayLabel) {
            property.setLocalizedDisplayLabelList(pd.getLocalizedDisplayNameList());
        }
        return property;
    }

    public static PropertyEditor getDefaultEditor(PropertyDefinition pd) {
        return FormViewUtil.getDefaultEditor(pd, true);
    }

    public static PropertyEditor getDefaultEditor(PropertyDefinition pd, boolean isLoadDisplayLabel) {
        return FormViewUtil.getDefaultEditor(pd, isLoadDisplayLabel, false);
    }

    public static PropertyEditor getDefaultEditor(PropertyDefinition pd, boolean isLoadDisplayLabel, boolean isReadOnly) {
        PropertyEditor editor = FormViewUtil.getDefaultEditor(pd.getType(), isLoadDisplayLabel, isReadOnly);
        if (editor instanceof ExpressionPropertyEditor) {
            ExpressionPropertyEditor epe = (ExpressionPropertyEditor)editor;
            ExpressionProperty ep = (ExpressionProperty)pd;
            if (ep.getResultType() != null) {
                PropertyDefinitionType resultType = ep.getResultType();
                PropertyEditor resultEditor = null;
                switch (resultType) {
                    case REFERENCE: {
                        break;
                    }
                    case EXPRESSION: {
                        break;
                    }
                    case SELECT: {
                        SelectProperty resultTypeSpec;
                        resultEditor = FormViewUtil.getDefaultEditor(resultType, isLoadDisplayLabel, isReadOnly);
                        if (ep.getResultTypeSpec() == null || !(ep.getResultTypeSpec() instanceof SelectProperty) || StringUtil.isEmpty((String)(resultTypeSpec = (SelectProperty)ep.getResultTypeSpec()).getSelectValueDefinitionName()) || !isLoadDisplayLabel) break;
                        SelectPropertyEditor sepe = (SelectPropertyEditor)resultEditor;
                        SelectValueDefinitionManager svdm = (SelectValueDefinitionManager)ManagerLocator.getInstance().getManager(SelectValueDefinitionManager.class);
                        SelectValueDefinition svd = (SelectValueDefinition)svdm.get(resultTypeSpec.getSelectValueDefinitionName());
                        sepe.setValues(EntityViewUtil.createEditorValueList(svd, null));
                        break;
                    }
                    default: {
                        resultEditor = FormViewUtil.getDefaultEditor(resultType, isLoadDisplayLabel, isReadOnly);
                    }
                }
                epe.setEditor(resultEditor);
            }
        } else if (editor instanceof ReferencePropertyEditor) {
            ReferencePropertyEditor rpe = (ReferencePropertyEditor)editor;
            ReferenceProperty rp = (ReferenceProperty)pd;
            rpe.setObjectName(rp.getObjectDefinitionName());
        } else if (editor instanceof SelectPropertyEditor && isLoadDisplayLabel) {
            SelectPropertyEditor sepe = (SelectPropertyEditor)editor;
            SelectProperty sp = (SelectProperty)pd;
            sepe.setValues(EntityViewUtil.createEditorValueList(sp, null));
        }
        return editor;
    }

    private static PropertyEditor getDefaultEditor(PropertyDefinitionType type, boolean isLoadDisplayLabel, boolean isReadOnly) {
        PropertyEditor editor = null;
        switch (type) {
            case BINARY: {
                BinaryPropertyEditor bpe = new BinaryPropertyEditor();
                if (isReadOnly) {
                    bpe.setDisplayType(BinaryPropertyEditor.BinaryDisplayType.BINARY);
                } else {
                    bpe.setDisplayType(BinaryPropertyEditor.BinaryDisplayType.BINARY);
                }
                editor = bpe;
                break;
            }
            case BOOLEAN: {
                BooleanPropertyEditor bope = new BooleanPropertyEditor();
                if (isReadOnly) {
                    bope.setDisplayType(BooleanPropertyEditor.BooleanDisplayType.LABEL);
                } else {
                    bope.setDisplayType(BooleanPropertyEditor.BooleanDisplayType.RADIO);
                }
                if (isLoadDisplayLabel) {
                    bope.setTrueLabel(FormViewUtil.resourceString("generic.editor.boolean.BooleanPropertyEditor_Condition.enable", new Object[0]));
                    bope.setFalseLabel(FormViewUtil.resourceString("generic.editor.boolean.BooleanPropertyEditor_Condition.invalid", new Object[0]));
                    if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
                        bope.setLocalizedTrueLabelList(FormViewUtil.resourceList("generic.editor.boolean.BooleanPropertyEditor_Condition.enable", new Object[0]));
                        bope.setLocalizedFalseLabelList(FormViewUtil.resourceList("generic.editor.boolean.BooleanPropertyEditor_Condition.invalid", new Object[0]));
                    }
                }
                editor = bope;
                break;
            }
            case DATE: {
                DatePropertyEditor dpe = new DatePropertyEditor();
                if (isReadOnly) {
                    dpe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.LABEL);
                } else {
                    dpe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.DATETIME);
                }
                editor = dpe;
                break;
            }
            case DATETIME: {
                TimestampPropertyEditor tspe = new TimestampPropertyEditor();
                if (isReadOnly) {
                    tspe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.LABEL);
                } else {
                    tspe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.DATETIME);
                    tspe.setUseDatetimePicker(true);
                }
                editor = tspe;
                break;
            }
            case DECIMAL: {
                DecimalPropertyEditor dcpe = new DecimalPropertyEditor();
                if (isReadOnly) {
                    dcpe.setDisplayType(NumberPropertyEditor.NumberDisplayType.LABEL);
                } else {
                    dcpe.setDisplayType(NumberPropertyEditor.NumberDisplayType.TEXT);
                }
                editor = dcpe;
                break;
            }
            case EXPRESSION: {
                ExpressionPropertyEditor epe = new ExpressionPropertyEditor();
                if (isReadOnly) {
                    epe.setDisplayType(ExpressionPropertyEditor.ExpressionDisplayType.LABEL);
                } else {
                    epe.setDisplayType(ExpressionPropertyEditor.ExpressionDisplayType.TEXT);
                }
                editor = epe;
                break;
            }
            case FLOAT: {
                FloatPropertyEditor fpe = new FloatPropertyEditor();
                if (isReadOnly) {
                    fpe.setDisplayType(NumberPropertyEditor.NumberDisplayType.LABEL);
                } else {
                    fpe.setDisplayType(NumberPropertyEditor.NumberDisplayType.TEXT);
                }
                editor = fpe;
                break;
            }
            case INTEGER: {
                IntegerPropertyEditor ipe = new IntegerPropertyEditor();
                if (isReadOnly) {
                    ipe.setDisplayType(NumberPropertyEditor.NumberDisplayType.LABEL);
                } else {
                    ipe.setDisplayType(NumberPropertyEditor.NumberDisplayType.TEXT);
                }
                editor = ipe;
                break;
            }
            case LONGTEXT: {
                LongTextPropertyEditor ltpe = new LongTextPropertyEditor();
                if (isReadOnly) {
                    ltpe.setDisplayType(StringPropertyEditor.StringDisplayType.LABEL);
                } else {
                    ltpe.setDisplayType(StringPropertyEditor.StringDisplayType.TEXTAREA);
                }
                editor = ltpe;
                break;
            }
            case REFERENCE: {
                ReferencePropertyEditor rpe = new ReferencePropertyEditor();
                rpe.setDisplayType(ReferencePropertyEditor.ReferenceDisplayType.LINK);
                if (isReadOnly) {
                    rpe.setHideSelectButton(true);
                    rpe.setHideRegistButton(true);
                    rpe.setHideDeleteButton(true);
                    rpe.setEditableReference(false);
                }
                editor = rpe;
                break;
            }
            case SELECT: {
                SelectPropertyEditor sepe = new SelectPropertyEditor();
                if (isReadOnly) {
                    sepe.setDisplayType(SelectPropertyEditor.SelectDisplayType.LABEL);
                } else {
                    sepe.setDisplayType(SelectPropertyEditor.SelectDisplayType.RADIO);
                }
                editor = sepe;
                break;
            }
            case STRING: {
                StringPropertyEditor spe = new StringPropertyEditor();
                if (isReadOnly) {
                    spe.setDisplayType(StringPropertyEditor.StringDisplayType.LABEL);
                } else {
                    spe.setDisplayType(StringPropertyEditor.StringDisplayType.TEXT);
                }
                editor = spe;
                break;
            }
            case TIME: {
                TimePropertyEditor tpe = new TimePropertyEditor();
                if (isReadOnly) {
                    tpe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.LABEL);
                } else {
                    tpe.setDisplayType(DateTimePropertyEditor.DateTimeDisplayType.DATETIME);
                }
                tpe.setUseTimePicker(true);
                editor = tpe;
                break;
            }
            case AUTONUMBER: {
                AutoNumberPropertyEditor anpe = new AutoNumberPropertyEditor();
                if (isReadOnly) {
                    anpe.setDisplayType(AutoNumberPropertyEditor.AutoNumberDisplayType.LABEL);
                } else {
                    anpe.setDisplayType(AutoNumberPropertyEditor.AutoNumberDisplayType.TEXT);
                }
                editor = anpe;
            }
        }
        return editor;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    private static List<LocalizedStringDefinition> resourceList(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceList(key, arguments);
    }
}

