/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.menu;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.view.menu.ActionMenuItem;
import org.iplass.mtp.view.menu.EntityMenuItem;
import org.iplass.mtp.view.menu.MenuItemVisitor;
import org.iplass.mtp.view.menu.NodeMenuItem;
import org.iplass.mtp.view.menu.UrlMenuItem;

@XmlRootElement
@XmlSeeAlso(value={ActionMenuItem.class, EntityMenuItem.class, NodeMenuItem.class, UrlMenuItem.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class MenuItem
implements Definition {
    private static final long serialVersionUID = 6208979768417580786L;
    private String name;
    @MultiLang(itemNameGetter="getName", itemKey="displayName", itemGetter="getDisplayName", itemSetter="setDisplayName", multiLangGetter="getLocalizedDisplayNameList", multiLangSetter="setLocalizedDisplayNameList")
    private String displayName;
    private String description;
    private String imageUrl;
    private String iconTag;
    private List<MenuItem> childs;
    private List<LocalizedStringDefinition> localizedDisplayNameList;
    private String imageColor;
    private String customizeScript;

    public abstract <R> R accept(MenuItemVisitor<R> var1);

    public List<MenuItem> getChilds() {
        return this.childs;
    }

    public void setChilds(List<MenuItem> childs) {
        this.childs = childs;
    }

    public void addChild(MenuItem menuItem) {
        if (this.childs == null) {
            this.childs = new ArrayList<MenuItem>();
        }
        this.childs.add(menuItem);
    }

    public boolean hasChild() {
        return this.childs != null && this.childs.size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public void setIconTag(String iconTag) {
        this.iconTag = iconTag;
    }

    public List<LocalizedStringDefinition> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<LocalizedStringDefinition> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public void addLocalizedDisplayName(LocalizedStringDefinition localizedDisplayName) {
        if (this.localizedDisplayNameList == null) {
            this.localizedDisplayNameList = new ArrayList<LocalizedStringDefinition>();
        }
        this.localizedDisplayNameList.add(localizedDisplayName);
    }

    public String getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(String imageColor) {
        this.imageColor = imageColor;
    }

    public String getCustomizeScript() {
        return this.customizeScript;
    }

    public void setCustomizeScript(String customizeScript) {
        this.customizeScript = customizeScript;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.imageUrl == null ? 0 : this.imageUrl.hashCode());
        result = 31 * result + (this.childs == null ? 0 : this.childs.hashCode());
        result = 31 * result + (this.imageColor == null ? 0 : this.imageColor.hashCode());
        result = 31 * result + (this.customizeScript == null ? 0 : this.customizeScript.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MenuItem other = (MenuItem)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.imageUrl == null ? other.imageUrl != null : !this.imageUrl.equals(other.imageUrl)) {
            return false;
        }
        if (this.childs == null ? other.childs != null : !this.childs.equals(other.childs)) {
            return false;
        }
        if (this.imageColor == null ? other.imageColor != null : !this.imageColor.equals(other.imageColor)) {
            return false;
        }
        return !(this.customizeScript == null ? other.customizeScript != null : !this.customizeScript.equals(other.customizeScript));
    }
}

