/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.treeview;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.iplass.mtp.view.treeview.EntityTreeViewItem;
import org.iplass.mtp.view.treeview.ReferenceTreeViewItem;
import org.iplass.mtp.view.treeview.TreeViewGridColModelMapping;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={EntityTreeViewItem.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class TreeViewItem
implements Serializable {
    private static final long serialVersionUID = 4970065426513391661L;
    protected String defName;
    protected String action;
    protected String viewName;
    protected String sortItem;
    protected TreeSortType sortType;
    protected int limit;
    protected String displayPropertyName;
    protected boolean displayDefinitionNode;
    protected List<ReferenceTreeViewItem> referenceTreeViewItems;
    protected String entityNodeIcon;
    protected String indexNodeIcon;
    protected String entityDefinitionNodeIcon;
    protected String entityNodeCssStyle;
    protected String indexNodeCssStyle;
    protected String entityDefinitionNodeCssStyle;
    protected List<TreeViewGridColModelMapping> mapping;

    public String getDefName() {
        return this.defName;
    }

    public void setDefName(String defName) {
        this.defName = defName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public TreeSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(TreeSortType sortType) {
        this.sortType = sortType;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getDisplayPropertyName() {
        return this.displayPropertyName;
    }

    public void setDisplayPropertyName(String displayPropertyName) {
        this.displayPropertyName = displayPropertyName;
    }

    public boolean isDisplayDefinitionNode() {
        return this.displayDefinitionNode;
    }

    public void setDisplayDefinitionNode(boolean displayDefinitionNode) {
        this.displayDefinitionNode = displayDefinitionNode;
    }

    public void setReferenceTreeViewItems(List<ReferenceTreeViewItem> referenceTreeViewItems) {
        this.referenceTreeViewItems = referenceTreeViewItems;
        for (ReferenceTreeViewItem item : this.referenceTreeViewItems) {
            item.setParent(this);
        }
    }

    public List<ReferenceTreeViewItem> getReferenceTreeViewItems() {
        if (this.referenceTreeViewItems == null) {
            this.referenceTreeViewItems = new ArrayList<ReferenceTreeViewItem>();
        }
        return this.referenceTreeViewItems;
    }

    public void addReferenceTreeItem(ReferenceTreeViewItem referenceTreeViewItem) {
        referenceTreeViewItem.setParent(this);
        this.getReferenceTreeViewItems().add(referenceTreeViewItem);
    }

    public String getEntityNodeIcon() {
        return this.entityNodeIcon;
    }

    public void setEntityNodeIcon(String entityNodeIcon) {
        this.entityNodeIcon = entityNodeIcon;
    }

    public String getIndexNodeIcon() {
        return this.indexNodeIcon;
    }

    public void setIndexNodeIcon(String indexNodeIcon) {
        this.indexNodeIcon = indexNodeIcon;
    }

    public String getEntityDefinitionNodeIcon() {
        return this.entityDefinitionNodeIcon;
    }

    public void setEntityDefinitionNodeIcon(String entityDefinitionNodeIcon) {
        this.entityDefinitionNodeIcon = entityDefinitionNodeIcon;
    }

    public String getEntityNodeCssStyle() {
        return this.entityNodeCssStyle;
    }

    public void setEntityNodeCssStyle(String entityNodeCssStyle) {
        this.entityNodeCssStyle = entityNodeCssStyle;
    }

    public String getIndexNodeCssStyle() {
        return this.indexNodeCssStyle;
    }

    public void setIndexNodeCssStyle(String indexNodeCssStyle) {
        this.indexNodeCssStyle = indexNodeCssStyle;
    }

    public String getEntityDefinitionNodeCssStyle() {
        return this.entityDefinitionNodeCssStyle;
    }

    public void setEntityDefinitionNodeCssStyle(String entityDefinitionNodeCssStyle) {
        this.entityDefinitionNodeCssStyle = entityDefinitionNodeCssStyle;
    }

    public List<TreeViewGridColModelMapping> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<TreeViewGridColModelMapping>();
        }
        return this.mapping;
    }

    public void setMapping(List<TreeViewGridColModelMapping> mapping) {
        this.mapping = mapping;
    }

    public void addMapping(TreeViewGridColModelMapping mapping) {
        this.getMapping().add(mapping);
    }

    public TreeViewItem getItem(String path) {
        String[] key;
        ReferenceTreeViewItem item;
        if (path.length() > 0 && (item = this.search((key = path.split("/", 2))[0])) != null) {
            if (key.length > 1) {
                return item.getItem(key[1]);
            }
            return item;
        }
        return null;
    }

    private ReferenceTreeViewItem search(String propertyName) {
        for (ReferenceTreeViewItem item : this.getReferenceTreeViewItems()) {
            if (!item.getPropertyName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    @XmlType(namespace="http://mtp.iplass.org/xml/definition/view/treeview")
    public static enum TreeSortType {
        ASC,
        DESC;

    }
}

