/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.util.DateUtil;

public enum DateRange {
    LAST_MONTH,
    THIS_MONTH,
    NEXT_MONTH,
    LAST_WEEK,
    THIS_WEEK,
    NEXT_WEEK,
    YESTERDAY,
    TODAY,
    TOMORROW,
    LAST_7_DAYS,
    LAST_30_DAYS,
    LAST_90_DAYS,
    LAST_180_DAYS,
    NEXT_7_DAYS,
    NEXT_30_DAYS,
    NEXT_90_DAYS,
    NEXT_180_DAYS;


    public Timestamp fromTimestamp() {
        Calendar cal = DateUtil.getCalendar((boolean)true);
        cal.setTime(DateUtil.getCurrentDate());
        this.setFromCalendar(cal);
        return new Timestamp(cal.getTimeInMillis());
    }

    public Date fromDate() {
        Calendar cal = DateUtil.getCalendar((boolean)false);
        cal.setTime(DateUtil.getCurrentDate());
        this.setFromCalendar(cal);
        return new Date(cal.getTimeInMillis());
    }

    private void setFromCalendar(Calendar cal) {
        switch (this) {
            case LAST_MONTH: {
                cal.add(2, -1);
                cal.set(5, 1);
                break;
            }
            case THIS_MONTH: {
                cal.set(5, 1);
                break;
            }
            case NEXT_MONTH: {
                cal.add(2, 1);
                cal.set(5, 1);
                break;
            }
            case LAST_WEEK: {
                cal.add(4, -1);
                cal.add(7, 1 - cal.get(7));
                break;
            }
            case THIS_WEEK: {
                cal.add(7, 1 - cal.get(7));
                break;
            }
            case NEXT_WEEK: {
                cal.add(4, 1);
                cal.add(7, 1 - cal.get(7));
                break;
            }
            case YESTERDAY: {
                cal.add(5, -1);
                break;
            }
            case TODAY: {
                break;
            }
            case TOMORROW: {
                cal.add(5, 1);
                break;
            }
            case LAST_7_DAYS: {
                cal.add(5, -6);
                break;
            }
            case LAST_30_DAYS: {
                cal.add(5, -29);
                break;
            }
            case LAST_90_DAYS: {
                cal.add(5, -89);
                break;
            }
            case LAST_180_DAYS: {
                cal.add(5, -179);
                break;
            }
            case NEXT_7_DAYS: {
                break;
            }
            case NEXT_30_DAYS: {
                break;
            }
            case NEXT_90_DAYS: {
                break;
            }
            case NEXT_180_DAYS: {
                break;
            }
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public Timestamp toTimestamp() {
        Calendar cal = DateUtil.getCalendar((boolean)true);
        cal.setTime(DateUtil.getCurrentDate());
        this.setToCalendar(cal);
        return new Timestamp(cal.getTimeInMillis());
    }

    public Date toDate() {
        Calendar cal = DateUtil.getCalendar((boolean)false);
        cal.setTime(DateUtil.getCurrentDate());
        this.setToCalendar(cal);
        return new Date(cal.getTimeInMillis());
    }

    private void setToCalendar(Calendar cal) {
        switch (this) {
            case LAST_MONTH: {
                cal.set(5, 1);
                cal.add(5, -1);
                break;
            }
            case THIS_MONTH: {
                cal.add(2, 1);
                cal.set(5, 1);
                cal.add(5, -1);
                break;
            }
            case NEXT_MONTH: {
                cal.add(2, 2);
                cal.set(5, 1);
                cal.add(5, -1);
                break;
            }
            case LAST_WEEK: {
                cal.add(4, -1);
                cal.add(7, 7 - cal.get(7));
                break;
            }
            case THIS_WEEK: {
                cal.add(7, 7 - cal.get(7));
                break;
            }
            case NEXT_WEEK: {
                cal.add(4, 1);
                cal.add(7, 7 - cal.get(7));
                break;
            }
            case YESTERDAY: {
                cal.add(5, -1);
                break;
            }
            case TODAY: {
                break;
            }
            case TOMORROW: {
                cal.add(5, 1);
                break;
            }
            case LAST_7_DAYS: {
                break;
            }
            case LAST_30_DAYS: {
                break;
            }
            case LAST_90_DAYS: {
                break;
            }
            case LAST_180_DAYS: {
                break;
            }
            case NEXT_7_DAYS: {
                cal.add(5, 6);
                break;
            }
            case NEXT_30_DAYS: {
                cal.add(5, 29);
                break;
            }
            case NEXT_90_DAYS: {
                cal.add(5, 89);
                break;
            }
            case NEXT_180_DAYS: {
                cal.add(5, 179);
                break;
            }
        }
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
    }

    public String getDisplayLabel() {
        String ret = null;
        switch (this) {
            case LAST_MONTH: {
                ret = DateRange.resourceString("api.util.DateRange.lastMonth", new Object[0]);
                break;
            }
            case THIS_MONTH: {
                ret = DateRange.resourceString("api.util.DateRange.thisMonth", new Object[0]);
                break;
            }
            case NEXT_MONTH: {
                ret = DateRange.resourceString("api.util.DateRange.nextMonth", new Object[0]);
                break;
            }
            case LAST_WEEK: {
                ret = DateRange.resourceString("api.util.DateRange.lastWeek", new Object[0]);
                break;
            }
            case THIS_WEEK: {
                ret = DateRange.resourceString("api.util.DateRange.thisWeek", new Object[0]);
                break;
            }
            case NEXT_WEEK: {
                ret = DateRange.resourceString("api.util.DateRange.nextWeek", new Object[0]);
                break;
            }
            case YESTERDAY: {
                ret = DateRange.resourceString("api.util.DateRange.yesterday", new Object[0]);
                break;
            }
            case TODAY: {
                ret = DateRange.resourceString("api.util.DateRange.today", new Object[0]);
                break;
            }
            case TOMORROW: {
                ret = DateRange.resourceString("api.util.DateRange.tomorrow", new Object[0]);
                break;
            }
            case LAST_7_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.last7days", new Object[0]);
                break;
            }
            case LAST_30_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.last30days", new Object[0]);
                break;
            }
            case LAST_90_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.last90days", new Object[0]);
                break;
            }
            case LAST_180_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.last180days", new Object[0]);
                break;
            }
            case NEXT_7_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.next7days", new Object[0]);
                break;
            }
            case NEXT_30_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.next30days", new Object[0]);
                break;
            }
            case NEXT_90_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.next90days", new Object[0]);
                break;
            }
            case NEXT_180_DAYS: {
                ret = DateRange.resourceString("api.util.DateRange.next180days", new Object[0]);
                break;
            }
            default: {
                ret = "";
            }
        }
        return ret;
    }

    public static boolean check(String val) {
        if (val == null || val.isEmpty()) {
            return false;
        }
        try {
            DateRange.valueOf(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

