/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.test;

import groovy.lang.GroovyObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.test.AuthUser;
import org.iplass.mtp.test.Commit;
import org.iplass.mtp.test.ConfigFile;
import org.iplass.mtp.test.NoAuthUser;
import org.iplass.mtp.test.Rollback;
import org.iplass.mtp.test.TenantName;
import org.iplass.mtp.test.TestManagerLocator;
import org.iplass.mtp.test.TestTransactionService;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MTPJUnitTestRule
implements TestRule {
    public static final String TEST_CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME = "mtp.test.config";
    public static final String DEFAULT_TEST_CONFIG_FILE_NAME = "/mtptest.properties";
    public static final String PROP_CONFIG_FILE_NAME = "configFileName";
    public static final String PROP_ROLLBACK_TRANSACTION = "rollbackTransaction";
    public static final String PROP_USER_ID = "userId";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_TENANT_NAME = "tenantName";
    private volatile String configFileName;
    private volatile boolean rollbackTransaction = true;
    private volatile String tenantName;
    private volatile String userId;
    private volatile String password;

    public MTPJUnitTestRule() {
        String propPath = System.getProperty(TEST_CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME);
        if (propPath == null) {
            propPath = DEFAULT_TEST_CONFIG_FILE_NAME;
        }
        Properties prop = null;
        try (InputStream is = MTPJUnitTestRule.class.getResourceAsStream(propPath);
             InputStreamReader r = new InputStreamReader(is, "UTF-8");){
            if (is != null) {
                prop = new Properties();
                prop.load(r);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (prop != null) {
            String val = (String)prop.get(PROP_CONFIG_FILE_NAME);
            if (val != null && val.length() > 0) {
                this.configFileName = val;
            }
            if ((val = (String)prop.get(PROP_ROLLBACK_TRANSACTION)) != null && val.length() > 0) {
                this.rollbackTransaction = Boolean.valueOf(val);
            }
            if ((val = (String)prop.get(PROP_USER_ID)) != null && val.length() > 0) {
                this.userId = val;
            }
            if ((val = (String)prop.get(PROP_PASSWORD)) != null && val.length() > 0) {
                this.password = val;
            }
            if ((val = (String)prop.get(PROP_TENANT_NAME)) != null && val.length() > 0) {
                this.tenantName = val;
            }
        }
    }

    public MTPJUnitTestRule configFileName(String configFileName) {
        this.configFileName = configFileName;
        return this;
    }

    public MTPJUnitTestRule rollbackTransaction(boolean rollbackTransaction) {
        this.rollbackTransaction = rollbackTransaction;
        return this;
    }

    public MTPJUnitTestRule tenant(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    public MTPJUnitTestRule authUser(String userId, String password) {
        this.userId = userId;
        this.password = password;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return new ConfigStatement(base, description);
    }

    static {
        System.setProperty("mtp.managerlocator", TestManagerLocator.class.getName());
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = -9157815643184354559L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }

    private class MockManagerStatement
    extends Statement {
        Statement base;

        public MockManagerStatement(Statement base, Description description) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.base.evaluate();
            }
            finally {
                ((TestManagerLocator)ManagerLocator.getInstance()).reset();
            }
        }
    }

    private class AuthStatement
    extends Statement {
        MockManagerStatement base;
        String userId;
        String password;

        AuthStatement(Statement base, Description description) {
            NoAuthUser nau;
            this.base = new MockManagerStatement(base, description);
            this.userId = MTPJUnitTestRule.this.userId;
            this.password = MTPJUnitTestRule.this.password;
            AuthUser au = description.getTestClass().getAnnotation(AuthUser.class);
            if (au != null) {
                this.userId = au.userId();
                this.password = au.password();
            }
            if ((nau = description.getTestClass().getAnnotation(NoAuthUser.class)) != null) {
                this.userId = null;
                this.password = null;
            }
            if ((au = (AuthUser)description.getAnnotation(AuthUser.class)) != null) {
                this.userId = au.userId();
                this.password = au.password();
            }
            if ((nau = (NoAuthUser)description.getAnnotation(NoAuthUser.class)) != null) {
                this.userId = null;
                this.password = null;
            }
        }

        public void evaluate() throws Throwable {
            AuthService as = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
            if (this.userId != null) {
                as.login((Credential)new IdPasswordCredential(this.userId, this.password));
            } else if (as.isAuthenticate()) {
                as.logout();
            }
            try {
                as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> {
                    try {
                        this.base.evaluate();
                        return null;
                    }
                    catch (Throwable e) {
                        throw new WrapException(e);
                    }
                });
            }
            catch (WrapException e) {
                throw e.getCause();
            }
        }
    }

    private class TransactionStatement
    extends Statement {
        AuthStatement base;
        boolean isRollback;

        TransactionStatement(Statement base, Description description) {
            Rollback tr;
            this.base = new AuthStatement(base, description);
            this.isRollback = MTPJUnitTestRule.this.rollbackTransaction;
            Commit tc = description.getTestClass().getAnnotation(Commit.class);
            if (tc != null) {
                this.isRollback = false;
            }
            if ((tr = description.getTestClass().getAnnotation(Rollback.class)) != null) {
                this.isRollback = true;
            }
            if ((tc = (Commit)description.getAnnotation(Commit.class)) != null) {
                this.isRollback = false;
            }
            if ((tr = (Rollback)description.getAnnotation(Rollback.class)) != null) {
                this.isRollback = true;
            }
        }

        public void evaluate() throws Throwable {
            TransactionService ts = (TransactionService)ServiceRegistry.getRegistry().getService(TransactionService.class);
            if (!(ts instanceof TestTransactionService)) {
                ServiceRegistry.getRegistry().setService(TransactionService.class.getName(), (Service)new TestTransactionService());
            }
            TestTransactionService.rollback = this.isRollback;
            this.base.evaluate();
        }
    }

    private class InitStatement
    extends Statement {
        private TransactionStatement base;
        private boolean isGroovy;
        private String tname;

        private InitStatement(Statement base, Description description) {
            TenantName tn;
            this.isGroovy = GroovyObject.class.isAssignableFrom(description.getTestClass());
            this.base = new TransactionStatement(base, description);
            if (MTPJUnitTestRule.this.tenantName != null) {
                this.tname = MTPJUnitTestRule.this.tenantName;
            }
            if ((tn = description.getTestClass().getAnnotation(TenantName.class)) != null) {
                this.tname = tn.value();
            }
            if ((tn = (TenantName)description.getAnnotation(TenantName.class)) != null) {
                this.tname = tn.value();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            boolean isInit = false;
            try {
                TenantContext tc;
                isInit = ResourceHolder.init();
                TransactionService ts = (TransactionService)ServiceRegistry.getRegistry().getService(TransactionService.class);
                if (!(ts instanceof TestTransactionService)) {
                    ServiceRegistry.getRegistry().setService(TransactionService.class.getName(), (Service)new TestTransactionService());
                }
                if ((tc = ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).getTenantContext("/" + this.tname)) == null) {
                    throw new IllegalArgumentException("tenantName:" + this.tname + " not found");
                }
                try {
                    ExecuteContext.executeAs((TenantContext)tc, () -> {
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            boolean replaceCl = this.isGroovy;
                            try {
                                if (replaceCl) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)((GroovyScriptEngine)tc.getScriptEngine()).getSharedClassLoader());
                                }
                                this.base.evaluate();
                            }
                            finally {
                                if (replaceCl) {
                                    Thread.currentThread().setContextClassLoader(cl);
                                }
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            throw new WrapException(e);
                        }
                    });
                }
                catch (WrapException e) {
                    throw e.getCause();
                }
            }
            finally {
                if (isInit) {
                    ResourceHolder.fin();
                }
            }
        }
    }

    private class ConfigStatement
    extends Statement {
        private InitStatement base;
        private String configFile;

        private ConfigStatement(Statement base, Description description) {
            ConfigFile cf;
            this.base = new InitStatement(base, description);
            if (MTPJUnitTestRule.this.configFileName != null) {
                this.configFile = MTPJUnitTestRule.this.configFileName;
            }
            if ((cf = description.getTestClass().getAnnotation(ConfigFile.class)) != null) {
                this.configFile = cf.value();
            }
            if ((cf = (ConfigFile)description.getAnnotation(ConfigFile.class)) != null) {
                this.configFile = cf.value();
            }
        }

        public void evaluate() throws Throwable {
            if (this.configFile != null && BootstrapProps.getInstance().replaceProperty("mtp.config", this.configFile)) {
                ServiceRegistry.getRegistry().reInit();
            }
            this.base.evaluate();
        }
    }
}

