/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.test;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.test.TestManagerLocator;
import org.iplass.mtp.transaction.Transaction;

public class MTPTest {
    public static <T> void setManagerMock(Class<T> managerInterface, T mock) {
        ((TestManagerLocator)ManagerLocator.getInstance()).setManager(managerInterface, mock);
    }

    public static void resetManagerMock() {
        ((TestManagerLocator)ManagerLocator.getInstance()).reset();
    }

    public static String invokeCommand(String commandName, RequestContext request) {
        return ((CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class)).execute(commandName, request);
    }

    public static Command newCommand(String commandName) {
        return ((CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class)).getCommandInstance(commandName);
    }

    public static String invokeCommand(Command cmd, RequestContext request) {
        return ((CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class)).execute(cmd, request);
    }

    public static void transaction(Runnable runnable) {
        Transaction.required(t -> runnable.run());
    }

    public static Class<?> getUtilityClass(String name) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        GroovyScriptEngine gse = (GroovyScriptEngine)ec.getTenantContext().getScriptEngine();
        try {
            return Class.forName(name, true, (ClassLoader)gse.getSharedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("can't load Utility class:" + name, e);
        }
    }

    public static Object newUC(String name) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        GroovyScriptEngine gse = (GroovyScriptEngine)ec.getTenantContext().getScriptEngine();
        try {
            Class<?> clazz = Class.forName(name, true, (ClassLoader)gse.getSharedClassLoader());
            return clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("can't create Utility class instance:" + name, e);
        }
    }

    public static Object newUC(String name, Object ... args) {
        Class<?> clazz;
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        GroovyScriptEngine gse = (GroovyScriptEngine)ec.getTenantContext().getScriptEngine();
        try {
            clazz = Class.forName(name, true, (ClassLoader)gse.getSharedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("can't load Utility class:" + name, e);
        }
        if (args == null || args.length == 0) {
            args = new Object[1];
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        RuntimeException ee = null;
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterTypes().length != args.length) continue;
            try {
                MethodHandle constructor = lookup.unreflectConstructor(c);
                return constructor.invokeWithArguments(args);
            }
            catch (WrongMethodTypeException e) {
                ee = e;
            }
            catch (ClassCastException e) {
                ee = e;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("can't create Utility class instance:" + name, e);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("can't create Utility class instance:" + name, e);
            }
        }
        throw new IllegalArgumentException("can't create Utility class instance:" + name, ee);
    }

    static {
        System.setProperty("mtp.managerlocator", TestManagerLocator.class.getName());
    }
}

