/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.iplass.mtp.Manager;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.impl.core.ManagerLocatorImpl;

public class TestManagerLocator
extends ManagerLocator {
    private ConcurrentHashMap<Class<?>, Object> mocks = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, Object> proxyCache = new ConcurrentHashMap();
    private ManagerLocatorImpl impl = new ManagerLocatorImpl();

    public <T> void setManager(Class<T> managerInterface, T mock) {
        if (mock != null && !managerInterface.isAssignableFrom(mock.getClass())) {
            throw new IllegalArgumentException(mock.getClass().getName() + " can't assign to " + managerInterface.getName());
        }
        this.mocks.put(managerInterface, mock);
    }

    public void reset() {
        this.mocks.clear();
    }

    private <T> T getProxy(Class<T> managerInterface, Supplier<T> factoryMethod) {
        Object instance = this.proxyCache.get(managerInterface);
        if (instance == null) {
            instance = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{managerInterface}, (proxy, method, args) -> {
                try {
                    Object manager = this.mocks.get(managerInterface);
                    if (manager != null) {
                        return method.invoke(manager, args);
                    }
                    manager = factoryMethod.get();
                    return method.invoke(manager, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            });
            this.proxyCache.put(managerInterface, instance);
        }
        return (T)instance;
    }

    public <M extends Manager> M getManager(Class<M> type) {
        return (M)this.getProxy(type, () -> this.impl.getManager(type));
    }
}

