/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.test;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.command.IllegalParameterException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.web.ReadOnlyHttpServletRequest;
import org.iplass.mtp.impl.web.SimpleSessionContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.test.TestResourceBundleUtil;
import org.iplass.mtp.web.actionmapping.ResponseHeader;

public class TestRequestContext
implements RequestContext {
    private HashMap<String, Object> paramMap;
    protected Map<String, Object> attribteMap = new HashMap<String, Object>();
    protected SessionContext session;
    private Map<String, Object> httpHeader;
    private ReadOnlyHttpServletRequest servletRequest;
    private ResponseHeader responseHeader;

    public TestRequestContext() {
        this.paramMap = new HashMap();
        this.attribteMap.put("param", this.paramMap);
        this.attribteMap.put("header", this.httpHeader);
    }

    private Map<String, Object> getHttpHeader(HttpServletRequest httpReq) {
        Enumeration headerNames = httpReq.getHeaderNames();
        if (headerNames != null) {
            HashMap<String, Object> header = new HashMap<String, Object>();
            ArrayList<String> buf = new ArrayList<String>();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration headerValues = httpReq.getHeaders(name);
                while (headerValues.hasMoreElements()) {
                    buf.add((String)headerValues.nextElement());
                }
                if (buf.size() == 1) {
                    header.put(name, buf.get(0));
                } else if (buf.size() > 1) {
                    header.put(name, buf.toArray(new String[buf.size()]));
                }
                buf.clear();
            }
            return header;
        }
        return null;
    }

    public void setHttpServletRequest(HttpServletRequest httpRequest) {
        this.servletRequest = new ReadOnlyHttpServletRequest(httpRequest);
        this.httpHeader = this.getHttpHeader(httpRequest);
    }

    public void setHttpRequestHeader(String name, Object value) {
        if (this.httpHeader == null) {
            this.httpHeader = new HashMap<String, Object>();
        }
        this.httpHeader.put(name, value);
    }

    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public void setParam(String name, Object value) {
        this.paramMap.put(name, value);
    }

    public String getParam(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof String[]) {
            return ((String[])val)[0];
        }
        return (String)val;
    }

    public String[] getParams(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return new String[]{(String)val};
        }
        return (String[])val;
    }

    public <T> T getParam(String name, Class<T> type) {
        try {
            return (T)ConvertUtil.convert(type, (Object)this.getParam(name));
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public <T> T[] getParams(String name, Class<T> type) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == type) {
            return vals;
        }
        try {
            Object[] ret = (Object[])Array.newInstance(type, vals.length);
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = ConvertUtil.convert(type, (Object)vals[i]);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Date getParamAsDate(String name, String format) {
        try {
            return (Date)ConvertUtil.convertToDate(Date.class, (Object)this.getParam(name), (String)format, (boolean)false);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Date[] getParamsAsDate(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Date.class) {
            return (Date[])vals;
        }
        try {
            Date[] ret = new Date[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = (Date)ConvertUtil.convertToDate(Date.class, (Object)vals[i], (String)format, (boolean)false);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Timestamp getParamAsTimestamp(String name, String format) {
        try {
            return (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)this.getParam(name), (String)format, (boolean)true);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Timestamp[] getParamsAsTimestamp(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Timestamp.class) {
            return (Timestamp[])vals;
        }
        try {
            Timestamp[] ret = new Timestamp[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)vals[i], (String)format, (boolean)true);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Time getParamAsTime(String name, String format) {
        try {
            return (Time)ConvertUtil.convertToDate(Time.class, (Object)this.getParam(name), (String)format, (boolean)false);
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public Time[] getParamsAsTime(String name, String format) {
        String[] vals = this.getParams(name);
        if (vals == null) {
            return null;
        }
        if (vals.getClass().getComponentType() == Time.class) {
            return (Time[])vals;
        }
        try {
            Time[] ret = new Time[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                ret[i] = (Time)ConvertUtil.convertToDate(Time.class, (Object)vals[i], (String)format, (boolean)false);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new IllegalParameterException(TestRequestContext.resourceString("impl.web.WebRequestContext.canNotConv", name), (Throwable)e);
        }
    }

    public BigDecimal getParamAsBigDecimal(String name) {
        return this.getParam(name, BigDecimal.class);
    }

    public BigDecimal[] getParamsAsBigDecimal(String name) {
        return this.getParams(name, BigDecimal.class);
    }

    public Integer getParamAsInt(String name) {
        return this.getParam(name, Integer.class);
    }

    public Integer[] getParamsAsInt(String name) {
        return this.getParams(name, Integer.class);
    }

    public Boolean getParamAsBoolean(String name) {
        return this.getParam(name, Boolean.class);
    }

    public Boolean[] getParamsAsBoolean(String name) {
        return this.getParams(name, Boolean.class);
    }

    public Double getParamAsDouble(String name) {
        return this.getParam(name, Double.class);
    }

    public Double[] getParamsAsDouble(String name) {
        return this.getParams(name, Double.class);
    }

    public UploadFileHandle getParamAsFile(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof UploadFileHandle[]) {
            return ((UploadFileHandle[])val)[0];
        }
        return (UploadFileHandle)val;
    }

    public UploadFileHandle[] getParamsAsFile(String name) {
        Object val = this.paramMap.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof UploadFileHandle) {
            return new UploadFileHandle[]{(UploadFileHandle)val};
        }
        return (UploadFileHandle[])val;
    }

    public Long getParamAsLong(String name) {
        return this.getParam(name, Long.class);
    }

    public Long[] getParamsAsLong(String name) {
        return this.getParams(name, Long.class);
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public Iterator<String> getParamNames() {
        return this.paramMap.keySet().iterator();
    }

    public Object getAttribute(String name) {
        switch (name) {
            case "header": {
                if (this.httpHeader != null) {
                    return this.httpHeader;
                }
                return Collections.emptyMap();
            }
            case "responseHeader": {
                return this.responseHeader;
            }
            case "servletRequest": {
                return this.servletRequest;
            }
        }
        return this.attribteMap.get(name);
    }

    public void setAttribute(String name, Object value) {
        switch (name) {
            case "header": {
                throw new IllegalArgumentException("header is ReadOnly attribute.");
            }
            case "param": {
                throw new IllegalArgumentException("param is ReadOnly attribute.");
            }
            case "responseHeader": {
                throw new IllegalArgumentException("responseHeader is ReadOnly attribute.");
            }
            case "servletRequest": {
                throw new IllegalArgumentException("servletRequest is ReadOnly attribute.");
            }
        }
        if (value == null) {
            this.attribteMap.remove(name);
        } else {
            this.attribteMap.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public Iterator<String> getAttributeNames() {
        return this.attribteMap.keySet().iterator();
    }

    public SessionContext getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContext getSession(boolean create) {
        SessionService ss;
        Session s;
        if (this.session == null && (s = (ss = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class)).getSession(create)) != null) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            this.session = (SimpleSessionContext)s.getAttribute("jp.co.isid.mtp.sessionContext." + tenantId);
            if (this.session == null) {
                Object object = s.getSessionMutexObject();
                synchronized (object) {
                    this.session = (SimpleSessionContext)s.getAttribute("jp.co.isid.mtp.sessionContext." + tenantId);
                    if (this.session == null) {
                        this.session = new SimpleSessionContext();
                        s.setAttribute("jp.co.isid.mtp.sessionContext." + tenantId, (Object)this.session);
                    }
                }
            }
        }
        return this.session;
    }

    private static String resourceString(String key, Object ... arguments) {
        return TestResourceBundleUtil.resourceString(key, arguments);
    }
}

