/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.UploadFileSizeOverException;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.test.TestResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUploadFileHandle
implements UploadFileHandle {
    private static final Logger logger = LoggerFactory.getLogger(TestUploadFileHandle.class);
    private WebFrontendService webFront = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    private File tempFile;
    private String fileName;
    private String type;
    private long size;
    private boolean isSizeOver;

    public TestUploadFileHandle(File tempFile, String fileName, String type) {
        this.tempFile = tempFile;
        this.fileName = fileName;
        this.type = type;
        this.size = tempFile.length();
    }

    public TestUploadFileHandle(String fileName, String type, long size, boolean isSizeOver) {
        this.fileName = fileName;
        this.type = type;
        this.size = size;
        this.isSizeOver = isSizeOver;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryReference toBinaryReference() {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(TestUploadFileHandle.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (this.webFront.isExecMagicByteCheck()) {
            this.webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.tempFile);
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            BinaryReference binaryReference = em.createBinaryReference(this.fileName, this.type, (InputStream)is);
            return binaryReference;
        }
        catch (FileNotFoundException e) {
            logger.warn("upload file is externally deleted. maybe contains virus.", (Throwable)e);
            BinaryReference binaryReference = null;
            return binaryReference;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("can not close resource:" + this.tempFile.getName(), (Throwable)e);
                }
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getInputStream() {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(TestUploadFileHandle.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (this.webFront.isExecMagicByteCheck()) {
            this.webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            logger.warn("upload file is externally deleted. maybe contains virus.", (Throwable)e);
            return null;
        }
    }

    public boolean isSizeOver() {
        return this.isSizeOver;
    }

    public Path copyTo(Path target, CopyOption ... options) {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(TestUploadFileHandle.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (this.webFront.isExecMagicByteCheck()) {
            this.webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return Files.copy(this.tempFile.toPath(), target, options);
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException((Throwable)e);
        }
    }

    public Path moveTo(Path target, CopyOption ... options) {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(TestUploadFileHandle.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (this.webFront.isExecMagicByteCheck()) {
            this.webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return Files.move(this.tempFile.toPath(), target, options);
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException((Throwable)e);
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return TestResourceBundleUtil.resourceString(key, arguments);
    }
}

