/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch;

import java.util.Optional;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtpBatchResourceDisposer {
    private static final Logger LOG = LoggerFactory.getLogger(MtpBatchResourceDisposer.class);

    private MtpBatchResourceDisposer() {
    }

    public static void addShutdownHookForDisposeResource(Runnable disposeProcess) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Begin resource dispose by shutdown hook.");
            try {
                Optional.ofNullable(disposeProcess).ifPresent(r -> r.run());
            }
            finally {
                MtpBatchResourceDisposer.disposeResource();
            }
        }));
    }

    public static void disposeResource() {
        LOG.info("Destroy all services.");
        ((TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class)).destroy();
        ServiceRegistry.getRegistry().destroyAllService();
    }
}

