/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.DataSourceConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.DriverManagerConnectionFactory;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.ToolsBatchResourceBundleUtil;
import org.iplass.mtp.tools.batch.ConfigSetting;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;

public abstract class MtpCuiBase {
    public static final String SILENT_MODE = "silent";
    private final List<LogListener> logListeners = new ArrayList<LogListener>();
    private final List<String> logMessage = new ArrayList<String>();
    private boolean isSuccess = false;
    private ConfigSetting configSetting;
    private LogListener consoleLogListener;
    private LogListener loggingLogListener;
    private String language;
    private ResourceBundle resourceBundle;

    public MtpCuiBase() {
        this.setupLanguage();
    }

    public List<String> getLogMessage() {
        return this.logMessage;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void addLogListner(LogListener listner) {
        this.logListeners.add(listner);
    }

    public void removeLogListner(LogListener listner) {
        if (this.logListeners.contains(listner)) {
            this.logListeners.remove(listner);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    protected void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    protected void clearLog() {
        this.logMessage.clear();
    }

    protected void logDebug(String message) {
        this.fireDebubLogMessage(message);
    }

    protected void logInfo(String message) {
        this.fireInfoLogMessage(message);
        this.logMessage.add(message);
    }

    protected void logInfo(String message, Throwable e) {
        this.fireInfoLogMessage(message, e);
        this.logMessage.add(message);
    }

    protected void logWarn(String message) {
        this.fireWarnLogMessage(message);
        this.logMessage.add(message);
    }

    protected void logWarn(String message, Throwable e) {
        this.fireWarnLogMessage(message, e);
        this.logMessage.add(message);
    }

    protected void logError(String message) {
        this.fireErrorLogMessage(message);
        this.logMessage.add(message);
    }

    protected void logError(String message, Throwable e) {
        this.fireErrorLogMessage(message, e);
        this.logMessage.add(message);
    }

    protected ConfigSetting getConfigSetting() {
        if (this.configSetting != null) {
            return this.configSetting;
        }
        try {
            String configFileName = BootstrapProps.getInstance().getProperty("mtp.config", "/mtp-service-config.xml");
            RdbAdapterService adapterService = (RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
            RdbAdapter adapter = adapterService.getRdbAdapter();
            String conenctInfo = null;
            ConnectionFactory factory = (ConnectionFactory)ServiceRegistry.getRegistry().getService(ConnectionFactory.class);
            if (factory instanceof DriverManagerConnectionFactory) {
                DriverManagerConnectionFactory dmFactory = (DriverManagerConnectionFactory)factory;
                conenctInfo = this.getDriverUrl(dmFactory);
            } else if (factory instanceof DataSourceConnectionFactory) {
                DataSourceConnectionFactory dsFactory = (DataSourceConnectionFactory)factory;
                conenctInfo = this.getDataSourceClass(dsFactory);
            }
            this.configSetting = new ConfigSetting(configFileName, adapter, conenctInfo);
        }
        catch (Throwable e) {
            throw new SystemException("failed to get config setting", e);
        }
        return this.configSetting;
    }

    private String getDriverUrl(DriverManagerConnectionFactory dmFactory) throws Exception {
        Field urlField = dmFactory.getClass().getDeclaredField("url");
        urlField.setAccessible(true);
        return (String)urlField.get(dmFactory);
    }

    private String getDataSourceClass(DataSourceConnectionFactory dsFactory) throws Exception {
        Field dataSourceField = dsFactory.getClass().getDeclaredField("dataSource");
        dataSourceField.setAccessible(true);
        return ((DataSource)dataSourceField.get(dsFactory)).getClass().getName();
    }

    protected void logEnvironment() {
        ConfigSetting configSetting = this.getConfigSetting();
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Environment");
        this.logInfo("\tconfig file :" + configSetting.getConfigFileName());
        this.logInfo("\trdb adapter type :" + configSetting.getRdbAdapterName());
        this.logInfo("\tconnect info :" + configSetting.getConnectionInfo());
        this.logInfo("\tlanguage :" + this.getLanguage());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    protected static List<TenantInfo> getValidTenantInfoList() {
        TenantToolService tenantToolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);
        return tenantToolService.getValidTenantInfoList();
    }

    protected static List<TenantInfo> getAllTenantInfoList() {
        TenantToolService tenantToolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);
        return tenantToolService.getAllTenantInfoList();
    }

    protected void showAllTenantList() {
        try {
            List<TenantInfo> tenantList = MtpCuiBase.getAllTenantInfoList();
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Tenant List");
            for (TenantInfo tenant : tenantList) {
                this.logInfo("[" + tenant.getId() + "] " + tenant.getName());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void showValidTenantList() {
        try {
            List<TenantInfo> tenantList = MtpCuiBase.getValidTenantInfoList();
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Tenant List");
            for (TenantInfo tenant : tenantList) {
                this.logInfo("[" + tenant.getId() + "] " + tenant.getName());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void switchLog(boolean console, boolean logging) {
        LogListener consoleLogListener = this.getConsoleLogListener();
        this.removeLogListner(consoleLogListener);
        LogListener loggingListener = this.getLoggingLogListener();
        this.removeLogListner(loggingListener);
        if (console) {
            this.addLogListner(consoleLogListener);
        }
        if (logging) {
            this.addLogListner(loggingListener);
        }
    }

    private LogListener getConsoleLogListener() {
        if (this.consoleLogListener != null) {
            return this.consoleLogListener;
        }
        this.consoleLogListener = new ConsoleLogListener();
        return this.consoleLogListener;
    }

    private LogListener getLoggingLogListener() {
        if (this.loggingLogListener != null) {
            return this.loggingLogListener;
        }
        this.loggingLogListener = new LoggingLogListener();
        return this.loggingLogListener;
    }

    protected <T> boolean executeTask(T param, Predicate<T> task) {
        return this.executeTask(param, task, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> boolean executeTask(T param, Predicate<T> task, boolean console, boolean logging) {
        boolean ret;
        block8: {
            block6: {
                ret = false;
                Exception error = null;
                try {
                    ret = task.test(param);
                    this.switchLog(console, logging);
                    if (error == null) break block6;
                    this.logInfo("");
                }
                catch (Exception e) {
                    block7: {
                        try {
                            error = e;
                            this.switchLog(console, logging);
                            if (error == null) break block7;
                            this.logInfo("");
                        }
                        catch (Throwable throwable) {
                            this.switchLog(console, logging);
                            if (error != null) {
                                this.logInfo("");
                                this.logError(this.rs("Common.errorMsg", error.getMessage()), error);
                                this.logInfo("");
                                this.logError("\u25a0Execute Result : FAILED");
                            } else {
                                this.logInfo("");
                                this.logInfo("\u25a0Execute Result :" + (ret ? "SUCCESS" : "FAILED"));
                            }
                            throw throwable;
                        }
                        this.logError(this.rs("Common.errorMsg", error.getMessage()), error);
                        this.logInfo("");
                        this.logError("\u25a0Execute Result : FAILED");
                    }
                    this.logInfo("");
                    this.logInfo("\u25a0Execute Result :" + (ret ? "SUCCESS" : "FAILED"));
                }
                this.logError(this.rs("Common.errorMsg", error.getMessage()), error);
                this.logInfo("");
                this.logError("\u25a0Execute Result : FAILED");
                break block8;
            }
            this.logInfo("");
            this.logInfo("\u25a0Execute Result :" + (ret ? "SUCCESS" : "FAILED"));
        }
        return ret;
    }

    protected String readConsole(String message) {
        Console console = System.console();
        if (console != null) {
            return console.readLine("%s%n", message + " : ");
        }
        System.out.println(message + " : ");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(System.in);
            br = new BufferedReader(isr);
            return br.readLine();
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected boolean readConsoleBoolean(String message, boolean retDefault) {
        String answerStr = this.readConsole(message + " [yes/no](" + (retDefault ? "yes" : "no") + ")");
        if (StringUtil.isEmpty((String)answerStr)) {
            return retDefault;
        }
        boolean answer = false;
        try {
            answer = answerStr.equalsIgnoreCase("yes") || Boolean.parseBoolean(answerStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected int readConsoleInteger(String message, int retDefault) {
        String answerStr = this.readConsole(message + "(" + retDefault + ")");
        if (StringUtil.isEmpty((String)answerStr)) {
            return retDefault;
        }
        int answer = retDefault;
        try {
            answer = Integer.parseInt(answerStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }

    protected String readConsolePassword(String message) {
        Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword("%s%n", message + " : ");
            return new String(password);
        }
        return this.readConsole(message);
    }

    private void fireDebubLogMessage(String message) {
        for (LogListener listner : this.logListeners) {
            listner.debug(message);
        }
    }

    private void fireInfoLogMessage(String message) {
        for (LogListener listner : this.logListeners) {
            listner.info(message);
        }
    }

    private void fireInfoLogMessage(String message, Throwable e) {
        for (LogListener listner : this.logListeners) {
            listner.info(message, e);
        }
    }

    private void fireWarnLogMessage(String message) {
        for (LogListener listner : this.logListeners) {
            listner.warn(message);
        }
    }

    private void fireWarnLogMessage(String message, Throwable e) {
        for (LogListener listner : this.logListeners) {
            listner.warn(message, e);
        }
    }

    private void fireErrorLogMessage(String message) {
        for (LogListener listner : this.logListeners) {
            listner.error(message);
        }
    }

    private void fireErrorLogMessage(String message, Throwable e) {
        for (LogListener listner : this.logListeners) {
            listner.error(message, e);
        }
    }

    private void setupLanguage() {
        this.language = ToolsBatchResourceBundleUtil.getLanguage();
        this.resourceBundle = ToolsBatchResourceBundleUtil.getResourceBundle(this.language);
        ExecuteContext context = ExecuteContext.getCurrentContext();
        context.setLanguage(this.language);
    }

    protected String rs(String key, Object ... args) {
        return ToolsBatchResourceBundleUtil.resourceString(this.resourceBundle, key, args);
    }

    protected abstract Logger loggingLogger();

    private class ConsoleLogListener
    implements LogListener {
        private Console console = System.console();

        @Override
        public void warn(String message) {
            if (this.console != null) {
                this.console.printf("[WARN]%s%n", message);
            } else {
                System.out.println("[WARN]" + message);
            }
        }

        @Override
        public void warn(String message, Throwable e) {
            this.warn(message);
        }

        @Override
        public void info(String message) {
            if (this.console != null) {
                this.console.printf("%s%n", message);
            } else {
                System.out.println(message);
            }
        }

        @Override
        public void info(String message, Throwable e) {
            this.info(message);
        }

        @Override
        public void error(String message) {
            if (this.console != null) {
                this.console.printf("[ERROR]%s%n", message);
            } else {
                System.out.println("[ERROR]" + message);
            }
        }

        @Override
        public void error(String message, Throwable e) {
            this.error(message);
        }
    }

    private class LoggingLogListener
    implements LogListener {
        private LoggingLogListener() {
        }

        @Override
        public void debug(String message) {
            MtpCuiBase.this.loggingLogger().debug(message);
        }

        @Override
        public void warn(String message) {
            MtpCuiBase.this.loggingLogger().warn(message);
        }

        @Override
        public void warn(String message, Throwable e) {
            MtpCuiBase.this.loggingLogger().warn(message, e);
        }

        @Override
        public void info(String message) {
            MtpCuiBase.this.loggingLogger().info(message);
        }

        @Override
        public void info(String message, Throwable e) {
            MtpCuiBase.this.loggingLogger().info(message, e);
        }

        @Override
        public void error(String message) {
            MtpCuiBase.this.loggingLogger().error(message);
        }

        @Override
        public void error(String message, Throwable e) {
            MtpCuiBase.this.loggingLogger().error(message, e);
        }
    }

    public static interface LogListener {
        default public void debug(String message) {
        }

        public void info(String var1);

        public void info(String var1, Throwable var2);

        public void warn(String var1);

        public void warn(String var1, Throwable var2);

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }
}

