/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.util.function.Function;
import java.util.function.Supplier;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.entity.EntityDeleteAllParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDeleteAll
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityDeleteAll.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String entityName;
    private Tenant tenant;
    private String whereClause;
    private boolean notifyListeners = true;
    private Integer commitLimit = 100;
    private EntityDefinition ed;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private EntityToolService ets = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);

    public static void main(String[] args) {
        EntityDeleteAll instance = null;
        try {
            instance = new EntityDeleteAll(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public EntityDeleteAll(String ... args) {
        if (args != null) {
            if (args.length > 0 && StringUtil.isNotBlank((String)args[0])) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && StringUtil.isNotBlank((String)args[1])) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && StringUtil.isNotBlank((String)args[2])) {
                this.entityName = args[2];
            }
            if (args.length > 3 && StringUtil.isNotBlank((String)args[3])) {
                this.whereClause = args[3];
            }
            if (args.length > 4 && StringUtil.isNotBlank((String)args[4])) {
                this.notifyListeners = Boolean.parseBoolean(args[4]);
            }
            if (args.length > 5 && StringUtil.isNotBlank((String)args[5])) {
                this.commitLimit = Integer.parseInt(args[5]);
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        if (this.tenantId != null) {
            Tenant tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
            this.tenant = tenant;
        }
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start DeleteAll Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start DeleteAll Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    public EntityDeleteAll execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public EntityDeleteAll tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public EntityDeleteAll entity(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public boolean deleteAll(final EntityDeleteAllParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){

            @Override
            public Boolean apply(Transaction t) {
                return (Boolean)EntityDeleteAll.this.executeTask(param, new EntityDeleteAllTask(param));
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(EntityDeleteAllParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\tentity name :" + param.getEntityName());
        this.logInfo("\twhere clause :" + param.getWhereClause());
        this.logInfo("\tentity execute listner :" + param.isNotifyListeners());
        this.logInfo("\tentity commit limit :" + param.getCommitLimit());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private <T> T executeTask(EntityDeleteAllParameter param, Supplier<T> task) {
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (T)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            return task.get();
        });
    }

    private boolean wizard() {
        if (this.tenant == null) {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            String url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            this.tenant = this.ts.getTenant(url);
            if (this.tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        EntityDeleteAllParameter param = new EntityDeleteAllParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validEntity = false;
            do {
                String inputEntityName = this.entityName;
                this.entityName = null;
                if (StringUtil.isEmpty((String)inputEntityName)) {
                    inputEntityName = this.readConsole(this.rs("EntityDeleteAll.Wizard.inputEntityNameMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputEntityName)) {
                    param.setEntityName(inputEntityName);
                    this.ed = this.edm.get(inputEntityName);
                    if (this.ed == null) {
                        this.logWarn(this.rs("EntityDeleteAll.notExistsEntityMsg", inputEntityName));
                        continue;
                    }
                    validEntity = true;
                    continue;
                }
                this.logWarn(this.rs("EntityDeleteAll.Wizard.requiredEntityNameMsg", new Object[0]));
            } while (!validEntity);
            String whereClause = this.readConsole(this.rs("EntityDeleteAll.Wizard.inputWhereClauseMsg", new Object[0]));
            if (StringUtil.isNotBlank((String)whereClause)) {
                param.setWhereClause(whereClause);
            }
            boolean isNotifyListner = this.readConsoleBoolean(this.rs("EntityDeleteAll.Wizard.confirmNotifyListenerMsg", new Object[0]), this.notifyListeners);
            param.setNotifyListeners(isNotifyListner);
            int commitLimit = this.readConsoleInteger(this.rs("EntityDeleteAll.Wizard.inputCommitUnitMsg", new Object[0]), 100);
            param.setCommitLimit(commitLimit);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("EntityDeleteAll.Wizard.confirmDeleteMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("EntityDeleteAll.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, (T paramA) -> this.deleteAll((EntityDeleteAllParameter)paramA));
        });
    }

    private boolean silent() {
        if (this.tenant == null) {
            this.logError(this.rs("Common.requiredMsg", "tenantId"));
            return false;
        }
        this.logInfo("target tenant:[" + this.tenant.getId() + "]" + this.tenant.getName());
        EntityDeleteAllParameter param = new EntityDeleteAllParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            this.ed = this.edm.get(this.entityName);
            if (this.ed == null) {
                this.logError(this.rs("Common.requiredMsg", "Entity name"));
                return false;
            }
            param.setEntityName(this.ed.getName());
            param.setWhereClause(this.whereClause);
            param.setNotifyListeners(this.notifyListeners);
            param.setCommitLimit(this.commitLimit);
            this.logArguments(param);
            return this.executeTask(param, (T paramA) -> this.deleteAll((EntityDeleteAllParameter)paramA));
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private class EntityDeleteAllTask
    implements Supplier<Boolean> {
        private final EntityDeleteAllParameter param;

        public EntityDeleteAllTask(EntityDeleteAllParameter param) {
            this.param = param;
        }

        @Override
        public Boolean get() {
            return !EntityDeleteAll.this.ets.deleteAll(this.param.getTenantId(), this.param.getEntityName(), this.param.getWhereClause(), this.param.isNotifyListeners(), this.param.getCommitLimit().intValue()).isError();
        }
    }
}

