/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCredential;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.entityport.EntityPortingService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.entity.EntityImportParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityImport
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityImport.class);
    public static final String KEY_CONFIG_FILE = "entity.config";
    private ExecMode execMode = ExecMode.WIZARD;
    private Integer tenantId;
    private String tenantUrl;
    private String entityName;
    private String importFileName;
    private String userId;
    private String password;
    private Properties properties;
    private Tenant tenant;
    private EntityDefinition ed;
    private File importFile;
    private boolean isImportBinaryData;
    private TenantService ts = (TenantService)ServiceRegistry.getRegistry().getService(TenantService.class);
    private TenantContextService tcs = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private EntityPortingService eps = (EntityPortingService)ServiceRegistry.getRegistry().getService(EntityPortingService.class);
    private AuthService as = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);

    public static void main(String[] args) {
        EntityImport instance = null;
        try {
            instance = new EntityImport(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public EntityImport(String ... args) {
        if (args != null) {
            if (args.length > 0 && args[0] != null) {
                this.execMode = ExecMode.valueOf(args[0].toUpperCase());
            }
            if (args.length > 1 && args[1] != null) {
                this.tenantId = Integer.parseInt(args[1]);
                if (this.tenantId == -1) {
                    this.tenantId = null;
                }
            }
            if (args.length > 2 && args[2] != null && !"empty".equals(args[2].toLowerCase())) {
                this.entityName = args[2];
            }
            if (args.length > 3 && args[3] != null && !"empty".equals(args[3].toLowerCase())) {
                this.importFileName = args[3];
            }
            if (args.length > 4) {
                this.isImportBinaryData = Boolean.parseBoolean(args[4]);
            }
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        this.loadConfigBaseInfo();
        if (!this.validateArguments()) {
            this.logInfo("");
            this.logError("\u25a0Execute Result : FAILED");
            return false;
        }
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Import Wizard");
                this.logInfo("");
                return this.wizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Import Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.silent();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    public EntityImport execMode(ExecMode execMode) {
        this.execMode = execMode;
        return this;
    }

    public EntityImport tenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public EntityImport entity(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public EntityImport file(String importFile) {
        this.importFileName = importFile;
        return this;
    }

    public EntityImport importBinaryData(boolean isImportBinaryData) {
        this.isImportBinaryData = isImportBinaryData;
        return this;
    }

    public boolean importEntity(final EntityImportParameter param) {
        this.setSuccess(false);
        boolean isSuccess = (Boolean)Transaction.required((Function)new Function<Transaction, Boolean>(){

            @Override
            public Boolean apply(Transaction t) {
                ArrayList<String> messageSummary = new ArrayList<String>();
                boolean ret = (Boolean)EntityImport.this.executeTask(param, new EntityDataImportTask(param, messageSummary));
                EntityImport.this.logInfo("-----------------------------------------------------------");
                EntityImport.this.logInfo("\u25a0Execute Result Summary");
                for (String message : messageSummary) {
                    EntityImport.this.logInfo(message);
                }
                EntityImport.this.logInfo("-----------------------------------------------------------");
                EntityImport.this.logInfo("");
                EntityImport.this.logInfo(EntityImport.this.rs("EntityImport.completedImportEntityLog", new Object[]{param.getImportFilePath()}));
                return ret;
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    public void logArguments(EntityImportParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\ttenant name :" + param.getTenantName());
        this.logInfo("\tentity name :" + param.getEntityName());
        this.logInfo("\timport file :" + param.getImportFilePath());
        this.logInfo("\timport binary data :" + param.isImportBinaryData());
        this.logInfo("\timport file locale :" + param.getLocale());
        this.logInfo("\timport file timezone :" + param.getTimezone());
        EntityDataImportCondition condition = param.getEntityImportCondition();
        this.logInfo("\tentity data truncate :" + condition.isTruncate());
        this.logInfo("\tentity data force update :" + condition.isFourceUpdate());
        this.logInfo("\tentity data error skip :" + condition.isErrorSkip());
        this.logInfo("\tentity ignore not exists property :" + condition.isIgnoreNotExistsProperty());
        this.logInfo("\tentity execute listner :" + condition.isNotifyListeners());
        this.logInfo("\tentity update disupdatable property :" + condition.isUpdateDisupdatableProperty());
        this.logInfo("\tentity insert audit property specification :" + condition.isInsertEnableAuditPropertySpecification());
        this.logInfo("\tentity execute validation :" + condition.isWithValidation());
        this.logInfo("\tentity commit limit :" + condition.getCommitLimit());
        this.logInfo("\tentity oid prefix :" + condition.getPrefixOid());
        if (condition.isInsertEnableAuditPropertySpecification()) {
            this.logInfo("\tentity import execute user id :" + this.userId);
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private <T> T executeTask(EntityImportParameter param, Supplier<T> task) {
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (T)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            if (StringUtil.isEmpty((String)this.userId)) {
                return task.get();
            }
            try {
                this.as.login((Credential)(StringUtil.isNotEmpty((String)this.password) ? new IdPasswordCredential(this.userId, this.password) : new InternalCredential(this.userId)));
                Object object = this.as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> EntityImport.lambda$null$0((Supplier)task));
                return object;
            }
            finally {
                this.as.logout();
            }
        });
    }

    private boolean wizard() {
        if (this.tenant == null) {
            String tenantUrl = this.readConsole(this.rs("Common.inputTenantUrlMsg", new Object[0]));
            if (StringUtil.isEmpty((String)tenantUrl)) {
                this.logWarn(this.rs("Common.requiredTenantUrlMsg", new Object[0]));
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-show")) {
                this.showValidTenantList();
                return this.wizard();
            }
            if (tenantUrl.equalsIgnoreCase("-env")) {
                this.logEnvironment();
                return this.wizard();
            }
            String url = tenantUrl.startsWith("/") ? tenantUrl : "/" + tenantUrl;
            this.tenant = this.ts.getTenant(url);
            if (this.tenant == null) {
                this.logWarn(this.rs("Common.notExistsTenantMsg", tenantUrl));
                return this.wizard();
            }
        }
        EntityImportParameter param = new EntityImportParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            String timezone;
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            boolean validEntity = false;
            do {
                String inputEntityName = this.entityName;
                this.entityName = null;
                if (StringUtil.isEmpty((String)inputEntityName)) {
                    inputEntityName = this.readConsole(this.rs("EntityImport.Wizard.inputEntityNameMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputEntityName)) {
                    param.setEntityName(inputEntityName);
                    EntityDefinition ed = this.edm.get(inputEntityName);
                    if (ed == null) {
                        this.logWarn(this.rs("EntityImport.notExistsEntityMsg", inputEntityName));
                        continue;
                    }
                    validEntity = true;
                    continue;
                }
                this.logWarn(this.rs("EntityImport.Wizard.requiredEntityNameMsg", new Object[0]));
            } while (!validEntity);
            boolean validFile = false;
            do {
                String inputFileName = this.importFileName;
                this.importFileName = null;
                if (StringUtil.isEmpty((String)inputFileName)) {
                    inputFileName = this.readConsole(this.rs("EntityImport.Wizard.inputImportFileMsg", new Object[0]));
                }
                if (StringUtil.isNotBlank((String)inputFileName)) {
                    param.setImportFilePath(inputFileName);
                    File file = new File(inputFileName);
                    if (!file.exists()) {
                        this.logWarn(this.rs("EntityImport.notExistsImportFileMsg", inputFileName));
                        continue;
                    }
                    param.setImportFile(file);
                    validFile = true;
                    continue;
                }
                this.logWarn(this.rs("EntityImport.Wizard.requiredImportFilePathMsg", new Object[0]));
            } while (!validFile);
            boolean isImportBinaryData = this.readConsoleBoolean(this.rs("EntityImport.Wizard.confirmImportBinaryDataMsg", new Object[0]), param.isImportBinaryData());
            param.setImportBinaryData(isImportBinaryData);
            EntityDataImportCondition condition = this.loadConfigCondition();
            if (condition == null) {
                condition = new EntityDataImportCondition();
            }
            boolean isTruncate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmTrancateDataMsg", new Object[0]), condition.isTruncate());
            condition.setTruncate(isTruncate);
            boolean isBulkUpdate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmBulkUpdateMsg", new Object[0]), condition.isBulkUpdate());
            condition.setBulkUpdate(isBulkUpdate);
            if (isBulkUpdate) {
                condition.setFourceUpdate(false);
            } else {
                boolean isForceUpdate = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmForceUpdateMsg", new Object[0]), condition.isFourceUpdate());
                condition.setFourceUpdate(isForceUpdate);
            }
            if (isBulkUpdate) {
                condition.setErrorSkip(false);
            } else {
                boolean isErrorSkip = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmSkipErrorDataMsg", new Object[0]), condition.isErrorSkip());
                condition.setErrorSkip(isErrorSkip);
            }
            boolean isIgnoreNotExistsProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmIgnoreNotExistsPropertyMsg", new Object[0]), condition.isIgnoreNotExistsProperty());
            condition.setIgnoreNotExistsProperty(isIgnoreNotExistsProperty);
            if (isBulkUpdate) {
                condition.setNotifyListeners(false);
            } else {
                boolean isNotifyListner = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmNotifyListenerMsg", new Object[0]), condition.isNotifyListeners());
                condition.setNotifyListeners(isNotifyListner);
            }
            boolean isUpdateDisupdatableProperty = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmUpdateDisupdatablePropertyMsg", new Object[0]), condition.isUpdateDisupdatableProperty());
            condition.setUpdateDisupdatableProperty(isUpdateDisupdatableProperty);
            boolean isInsertEnableAuditPropertySpecification = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmInsertEnableAuditPropertySpecification", new Object[0]), condition.isInsertEnableAuditPropertySpecification());
            condition.setInsertEnableAuditPropertySpecification(isInsertEnableAuditPropertySpecification);
            if (condition.isInsertEnableAuditPropertySpecification()) {
                do {
                    String executeUserId;
                    if (!StringUtil.isNotEmpty((String)(executeUserId = this.readConsole(this.rs("PackageImport.Wizard.confirmExecuteUserId", new Object[0]))))) continue;
                    this.userId = executeUserId;
                    String executeUserPW = this.readConsole(this.rs("PackageImport.Wizard.confirmExecuteUserPW", new Object[0]));
                    if (!StringUtil.isNotEmpty((String)executeUserPW)) continue;
                    this.password = executeUserPW;
                } while (this.userId == null);
            }
            if (isBulkUpdate || isUpdateDisupdatableProperty) {
                condition.setWithValidation(false);
            } else {
                boolean isWithValidation = this.readConsoleBoolean(this.rs("PackageImport.Wizard.confirmWithValidationMsg", new Object[0]), condition.isWithValidation());
                condition.setWithValidation(isWithValidation);
            }
            int commitLimit = this.readConsoleInteger(this.rs("PackageImport.Wizard.inputCommitUnitMsg", new Object[0]), 100);
            condition.setCommitLimit(Integer.valueOf(commitLimit));
            boolean validOidPrefix = false;
            do {
                String oidPrefix;
                if (StringUtil.isEmpty((String)(oidPrefix = this.readConsole(this.rs("PackageImport.Wizard.inputOIDPrefixMsg", new Object[0]) + "(" + condition.getPrefixOid() + ")")))) {
                    validOidPrefix = true;
                    continue;
                }
                if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                    condition.setPrefixOid(oidPrefix);
                    validOidPrefix = true;
                    continue;
                }
                this.logWarn(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
            } while (!validOidPrefix);
            String locale = this.readConsole(this.rs("PackageImport.Wizard.inputLocaleMsg", new Object[0]) + "(" + (condition.getLocale() != null ? condition.getLocale() : "") + ")");
            if (StringUtil.isNotBlank((String)locale)) {
                condition.setLocale(locale);
            }
            if (StringUtil.isNotBlank((String)(timezone = this.readConsole(this.rs("PackageImport.Wizard.inputTimezoneMsg", new Object[0]) + "(" + (condition.getTimezone() != null ? condition.getTimezone() : "") + ")")))) {
                condition.setTimezone(timezone);
            }
            param.setEntityImportCondition(condition);
            boolean validExecute = false;
            do {
                this.logArguments(param);
                boolean isExecute = this.readConsoleBoolean(this.rs("EntityImport.Wizard.confirmImportEntityMsg", new Object[0]), false);
                if (isExecute) {
                    validExecute = true;
                    continue;
                }
                isExecute = this.readConsoleBoolean(this.rs("EntityImport.Wizard.confirmRetryMsg", new Object[0]), true);
                if (!isExecute) continue;
                return this.wizard();
            } while (!validExecute);
            this.switchLog(false, true);
            return this.executeTask(param, (T paramA) -> this.importEntity((EntityImportParameter)paramA));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadConfig() {
        Properties prop;
        block57: {
            if (this.properties != null) {
                return this.properties;
            }
            String configFileName = System.getProperty(KEY_CONFIG_FILE);
            if (StringUtil.isEmpty((String)configFileName)) {
                return null;
            }
            prop = new Properties();
            try {
                Path path = Paths.get(configFileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    this.logDebug("load config file from file path:" + configFileName);
                    try (FileInputStream is = new FileInputStream(path.toFile());
                         InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                        prop.load(reader);
                        break block57;
                    }
                }
                this.logDebug("load config file from classpath:" + configFileName);
                try (InputStream is = EntityImport.class.getResourceAsStream(configFileName);){
                    if (is == null) {
                        this.logWarn(this.rs("EntityImport.notExistsConfigFileMsg", configFileName));
                        Properties reader = null;
                        return reader;
                    }
                    try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
                        prop.load(reader);
                    }
                }
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        this.properties = prop;
        return this.properties;
    }

    private void loadConfigBaseInfo() {
        String propImportBinaryData;
        String propImportFileName;
        String propEntityName;
        Properties prop = this.loadConfig();
        if (prop == null) {
            return;
        }
        if (this.tenantId == null) {
            String propTenantUrl;
            String propTenantId = prop.getProperty("tenantId");
            if (StringUtil.isNotEmpty((String)propTenantId)) {
                this.tenantId = Integer.parseInt(propTenantId);
            }
            if (this.tenantId == null && StringUtil.isNotEmpty((String)(propTenantUrl = prop.getProperty("tenantUrl")))) {
                if (!propTenantUrl.startsWith("/")) {
                    propTenantUrl = "/" + propTenantUrl;
                }
                this.tenantUrl = propTenantUrl;
            }
        }
        if (this.entityName == null && StringUtil.isNotEmpty((String)(propEntityName = prop.getProperty("entityName")))) {
            this.entityName = propEntityName;
        }
        if (this.importFileName == null && StringUtil.isNotEmpty((String)(propImportFileName = prop.getProperty("importFile")))) {
            this.importFileName = propImportFileName;
        }
        if (StringUtil.isNotEmpty((String)(propImportBinaryData = prop.getProperty("importBinaryData")))) {
            this.isImportBinaryData = Boolean.valueOf(propImportBinaryData);
        }
    }

    private EntityDataImportCondition loadConfigCondition() {
        String oidPrefix;
        String insertEnableAuditPropertySpecification;
        String bulkUpdate;
        Properties prop = this.loadConfig();
        if (prop == null) {
            return null;
        }
        EntityDataImportCondition condition = new EntityDataImportCondition();
        String truncate = prop.getProperty("entity.truncate");
        if (StringUtil.isNotEmpty((String)truncate)) {
            condition.setTruncate(Boolean.valueOf(truncate).booleanValue());
        }
        if (StringUtil.isNotEmpty((String)(bulkUpdate = prop.getProperty("entity.bulkUpdate")))) {
            condition.setBulkUpdate(Boolean.valueOf(bulkUpdate).booleanValue());
        }
        if (condition.isBulkUpdate()) {
            condition.setFourceUpdate(false);
        } else {
            String forceUpdate = prop.getProperty("entity.forceUpdate");
            if (StringUtil.isNotEmpty((String)forceUpdate)) {
                condition.setFourceUpdate(Boolean.valueOf(forceUpdate).booleanValue());
            }
        }
        if (condition.isBulkUpdate()) {
            condition.setErrorSkip(false);
        } else {
            String errorSkip = prop.getProperty("entity.errorSkip");
            if (StringUtil.isNotEmpty((String)errorSkip)) {
                condition.setErrorSkip(Boolean.valueOf(errorSkip).booleanValue());
            }
        }
        String ignoreInvalidProperty = prop.getProperty("entity.ignoreInvalidProperty");
        if (StringUtil.isNotEmpty((String)ignoreInvalidProperty)) {
            condition.setIgnoreNotExistsProperty(Boolean.valueOf(ignoreInvalidProperty).booleanValue());
        }
        if (condition.isBulkUpdate()) {
            condition.setNotifyListeners(false);
        } else {
            String notifyListener = prop.getProperty("entity.notifyListener");
            if (StringUtil.isNotEmpty((String)notifyListener)) {
                condition.setNotifyListeners(Boolean.valueOf(notifyListener).booleanValue());
            }
        }
        String updateDisupdatableProperty = prop.getProperty("entity.updateDisupdatableProperty");
        if (StringUtil.isNotEmpty((String)updateDisupdatableProperty)) {
            condition.setUpdateDisupdatableProperty(Boolean.valueOf(updateDisupdatableProperty).booleanValue());
        }
        if (StringUtil.isNotEmpty((String)(insertEnableAuditPropertySpecification = prop.getProperty("entity.insertEnableAuditPropertySpecification")))) {
            condition.setInsertEnableAuditPropertySpecification(Boolean.valueOf(insertEnableAuditPropertySpecification).booleanValue());
        }
        if (condition.isInsertEnableAuditPropertySpecification()) {
            String execUserPW;
            String execUserId = prop.getProperty("entity.insertEnableAuditPropertySpecificationUserId");
            if (StringUtil.isNotEmpty((String)execUserId)) {
                this.userId = execUserId;
            }
            if (StringUtil.isNotEmpty((String)(execUserPW = prop.getProperty("entity.insertEnableAuditPropertySpecificationUserPW")))) {
                this.password = execUserPW;
            }
        }
        if (condition.isBulkUpdate() || condition.isUpdateDisupdatableProperty()) {
            condition.setWithValidation(false);
        } else {
            String withValidation = prop.getProperty("entity.withValidation");
            if (StringUtil.isNotEmpty((String)withValidation)) {
                condition.setWithValidation(Boolean.valueOf(withValidation).booleanValue());
            }
        }
        String commitLimit = prop.getProperty("entity.commitLimit");
        if (StringUtil.isNotEmpty((String)commitLimit)) {
            condition.setCommitLimit(Integer.valueOf(commitLimit));
        }
        if (StringUtil.isNotEmpty((String)(oidPrefix = prop.getProperty("entity.prefixOid")))) {
            if (oidPrefix.matches("[0-9a-zA-Z]+")) {
                condition.setPrefixOid(oidPrefix);
            } else {
                this.logError(this.rs("PackageImport.warnOIDPrefixMsg", new Object[0]));
                return null;
            }
        }
        return condition;
    }

    private boolean validateArguments() {
        TenantContext tc;
        boolean entityValid;
        Tenant tenant;
        if (this.tenantId != null) {
            tenant = this.ts.getTenant(this.tenantId.intValue());
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantIdMsg", this.tenantId));
                return false;
            }
            this.tenant = tenant;
        } else if (this.tenantUrl != null) {
            tenant = this.ts.getTenant(this.tenantUrl);
            if (tenant == null) {
                this.logError(this.rs("Common.notExistsTenantUrlMsg", this.tenantUrl));
                return false;
            }
            this.tenant = tenant;
        }
        if (StringUtil.isNotEmpty((String)this.entityName) && this.tenant != null && !(entityValid = ((Boolean)ExecuteContext.executeAs((TenantContext)(tc = this.tcs.getTenantContext(this.tenant.getId())), () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            EntityDefinition ed = this.edm.get(this.entityName);
            if (ed == null) {
                this.logError(this.rs("EntityImport.notExistsEntityMsg", this.entityName));
                return false;
            }
            this.ed = ed;
            return true;
        })).booleanValue())) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.importFileName)) {
            File importFile = new File(this.importFileName);
            if (!importFile.exists()) {
                this.logError(this.rs("EntityImport.notExistsImportFileMsg", this.importFileName));
                return false;
            }
            this.importFile = importFile;
        }
        return true;
    }

    private boolean silent() {
        if (this.tenant == null) {
            this.logError(this.rs("Common.requiredMsg", "tenantId or tenantUrl"));
            return false;
        }
        this.logInfo("target tenant:[" + this.tenant.getId() + "]" + this.tenant.getName());
        EntityImportParameter param = new EntityImportParameter(this.tenant.getId(), this.tenant.getName());
        TenantContext tc = this.tcs.getTenantContext(param.getTenantId());
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            ExecuteContext.getCurrentContext().setLanguage(this.getLanguage());
            if (this.ed == null) {
                this.logError(this.rs("Common.requiredMsg", "Entity name"));
                return false;
            }
            param.setEntityName(this.ed.getName());
            if (this.importFile == null) {
                this.logError(this.rs("Common.requiredMsg", "Import file"));
                return false;
            }
            param.setImportFilePath(this.importFile.getPath());
            param.setImportFile(this.importFile);
            param.setImportBinaryData(this.isImportBinaryData);
            EntityDataImportCondition condition = this.loadConfigCondition();
            if (condition == null) {
                condition = new EntityDataImportCondition();
            }
            param.setEntityImportCondition(condition);
            this.logArguments(param);
            return this.executeTask(param, (T paramA) -> this.importEntity((EntityImportParameter)paramA));
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    private static /* synthetic */ Object lambda$null$0(Supplier task) {
        return task.get();
    }

    private class EntityDataImportTask
    implements Supplier<Boolean> {
        private final EntityImportParameter param;
        private final List<String> messageSummary;

        public EntityDataImportTask(EntityImportParameter param, List<String> messageSummary) {
            this.param = param;
            this.messageSummary = messageSummary;
        }

        @Override
        public Boolean get() {
            String logMessage = null;
            EntityImport.this.logInfo(EntityImport.this.rs("EntityImport.startImportEntityLog", new Object[0]));
            String entityPath = "/entity/" + this.param.getEntityName().replace(".", "/");
            MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(entityPath);
            if (entry == null) {
                throw new SystemException(EntityImport.this.rs("EntityImport.notExistsEntityMsg", new Object[]{this.param.getEntityName()}));
            }
            EntityImport.this.logInfo(EntityImport.this.rs("EntityImport.startImportEntityDataLog", new Object[]{entityPath}));
            EntityDataImportResult entityResult = null;
            String importBinaryDataDir = this.param.isImportBinaryData() ? this.param.getImportFile().getParent() : null;
            try (FileInputStream fis = new FileInputStream(this.param.getImportFile());){
                entityResult = EntityImport.this.eps.importEntityData(this.param.getImportFilePath(), (InputStream)fis, entry, this.param.getEntityImportCondition(), null, importBinaryDataDir);
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            if (entityResult.isError()) {
                if (entityResult.getMessages() != null) {
                    for (String message : entityResult.getMessages()) {
                        EntityImport.this.logError(message);
                    }
                    EntityImport.this.logInfo("");
                }
                logMessage = EntityImport.this.rs("EntityImport.errorImportEntityDataLog", new Object[]{entityPath});
                EntityImport.this.logError(logMessage);
                this.messageSummary.add("[ERROR]" + logMessage);
                if (!this.param.getEntityImportCondition().isErrorSkip()) {
                    EntityImport.this.logError(EntityImport.this.rs("Common.errorMsg", new Object[]{""}));
                    return false;
                }
                EntityImport.this.logInfo(EntityImport.this.rs("EntityImport.continueLog", new Object[0]));
            } else {
                if (entityResult.getMessages() != null) {
                    for (String message : entityResult.getMessages()) {
                        EntityImport.this.logInfo(message);
                    }
                    EntityImport.this.logInfo("");
                }
                logMessage = EntityImport.this.rs("EntityImport.completedImportEntityDataLog", new Object[]{entityPath, entityResult.getInsertCount(), entityResult.getUpdateCount(), entityResult.getErrorCount()});
                EntityImport.this.logInfo(logMessage);
                EntityImport.this.logInfo("");
                this.messageSummary.add(logMessage);
            }
            logMessage = EntityImport.this.rs("EntityImport.completedImportEntityLog", new Object[0]);
            EntityImport.this.logInfo(logMessage);
            EntityImport.this.logInfo("");
            this.messageSummary.add(logMessage);
            return true;
        }
    }
}

