/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.io.File;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityJavaMappingClassCreator
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityJavaMappingClassCreator.class);
    private static final String ROOT_ENTITY = "/entity/Entity";
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityToolService entityToolService = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private boolean isRecursive = true;
    private boolean isForce = false;
    private String outDir = ".";
    private String entityPath;
    private String basePackage;

    public EntityJavaMappingClassCreator(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.execMode = ExecMode.valueOf(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(Integer.parseInt(args[1]));
            }
            if (args.length > 2) {
                this.setRecursive(args[2]);
            }
            if (args.length > 3) {
                this.setForce(args[3]);
            }
            if (args.length > 4) {
                this.setOutDir(args[4]);
            }
            if (args.length > 5) {
                this.setEntityPath(args[5]);
            }
            if (args.length > 6) {
                this.setBasePackage(args[6]);
            }
        }
    }

    public static void main(String ... args) {
        try {
            new EntityJavaMappingClassCreator(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public void setRecursive(String recursive) {
        this.setRecursive("recursive".equals(StringUtil.lowerCase((String)recursive)));
    }

    public void setRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public void setForce(String force) {
        this.isForce = "force".equals(StringUtil.lowerCase((String)force));
    }

    public void setForce(boolean isForce) {
        this.isForce = isForce;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.executeTask(null, param -> this.proceed());
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        String outDir;
        String basePackage;
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.setTenantId(Integer.parseInt(tenantId));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("EntityJavaMappingClassCreator.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        String entityPath = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.entityPathMsg", new Object[0]));
        if (StringUtil.isNotBlank((String)entityPath)) {
            this.setEntityPath(entityPath);
        }
        if (StringUtil.isNotBlank((String)(basePackage = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.basePackageMsg", new Object[0]))))) {
            this.setBasePackage(basePackage);
        }
        if (StringUtil.isNotBlank((String)(outDir = this.readConsole(this.rs("EntityJavaMappingClassCreator.Wizard.outDirMsg", new Object[0]))))) {
            this.setOutDir(outDir);
        }
        this.setRecursive(this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.Wizard.recursiveMsg", new Object[0]), this.isRecursive));
        this.setForce(this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.Wizard.forceMsg", new Object[0]), this.isForce));
        this.switchLog(false, true);
        return this.executeTask(null, param -> this.proceed());
    }

    private boolean proceed() {
        this.setSuccess(false);
        TenantContext tc = tenantContextService.getTenantContext(this.tenantId);
        if (tc == null) {
            this.logError(this.rs("EntityJavaMappingClassCreator.notFoundTenant", this.tenantId));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            EntityDefinition ed = this.edm.get(this.entityPath);
            if (ed != null) {
                String entityName = ed.getName();
                if (StringUtil.isBlank((String)this.basePackage) && ed.getMapping() != null && StringUtil.isNotBlank((String)ed.getMapping().getMappingModelClass())) {
                    entityName = ed.getMapping().getMappingModelClass();
                }
                File file = new File(this.generateJavaClassFileName(entityName));
                if (!this.isForce && file.exists() && !this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.confirmOverwrite", file.getPath()), false)) {
                    this.setSuccess(true);
                    return this.isSuccess();
                }
                entityToolService.createJavaMappingClass(file, ed, this.basePackage);
            } else {
                List list = this.edm.definitionSummaryList(this.entityPath, this.isRecursive);
                list.forEach(ds -> {
                    if (ROOT_ENTITY.equals(ds.getPath())) {
                        return;
                    }
                    String entityName = ds.getName();
                    EntityDefinition edx = this.edm.get(ds.getName());
                    if (StringUtil.isBlank((String)this.basePackage) && edx.getMapping() != null && StringUtil.isNotBlank((String)edx.getMapping().getMappingModelClass())) {
                        entityName = edx.getMapping().getMappingModelClass();
                    }
                    File file = new File(this.generateJavaClassFileName(entityName));
                    if (!this.isForce && file.exists() && !this.readConsoleBoolean(this.rs("EntityJavaMappingClassCreator.confirmOverwrite", file.getPath()), false)) {
                        return;
                    }
                    entityToolService.createJavaMappingClass(file, edx, this.basePackage);
                });
            }
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    private String generateJavaClassFileName(String entityName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.outDir).append('/');
        if (StringUtil.isNotBlank((String)this.basePackage)) {
            sb.append(this.basePackage.replace('.', '/')).append('/');
        }
        sb.append(entityName.replace('.', '/')).append(".java");
        return sb.toString();
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

