/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.entity;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.entity.EntityToolService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityViewDDLCreator
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(EntityViewDDLCreator.class);
    private static final String ROOT_ENTITY = "/entity/Entity";
    private static TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private static EntityToolService entityToolService = (EntityToolService)ServiceRegistry.getRegistry().getService(EntityToolService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private boolean isOverwrite = false;
    private boolean isRecursive = true;
    private String outFile = "./view.ddl";
    private String entityPath = "/";

    public EntityViewDDLCreator(String ... args) {
        if (args != null) {
            if (args.length > 0) {
                this.setExecMode(args[0]);
            }
            if (args.length > 1) {
                this.setTenantId(args[1]);
                if (this.tenantId < 0) {
                    this.setExecMode(ExecMode.WIZARD);
                }
            }
            if (args.length > 2) {
                this.setOverwrite(args[2]);
            }
            if (args.length > 3) {
                this.setRecursive(args[3]);
            }
            if (args.length > 4) {
                this.setOutFile(args[4]);
            }
            if (args.length > 5) {
                this.setEntityPath(args[5]);
            }
        }
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public void setExecMode(String execMode) {
        this.setExecMode(ExecMode.valueOf(execMode.toUpperCase()));
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantId(String tenantId) {
        try {
            this.setTenantId(Integer.parseInt(tenantId));
        }
        catch (NumberFormatException e) {
            this.setTenantId(-1);
        }
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public void setOverwrite(boolean isOverwrite) {
        this.isOverwrite = isOverwrite;
    }

    public void setOverwrite(String overwrite) {
        this.setOverwrite("overwrite".equals(StringUtil.lowerCase((String)overwrite)));
    }

    public void setRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public void setRecursive(String recursive) {
        this.setRecursive("recursive".equals(StringUtil.lowerCase((String)recursive)));
    }

    public static void main(String ... args) {
        try {
            new EntityViewDDLCreator(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    public boolean execute() throws Exception {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                this.logInfo("\u25a0Start Wizard");
                this.logInfo("");
                return this.startWizard();
            }
            case SILENT: {
                this.logInfo("\u25a0Start Silent");
                this.logInfo("");
                this.switchLog(false, true);
                return this.executeTask(null, param -> this.proceed());
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private boolean startWizard() {
        boolean validTenantId = false;
        do {
            String tenantId;
            if (!StringUtil.isNotBlank((String)(tenantId = this.readConsole(this.rs("EntityViewDDLCreator.Wizard.tenantIdMsg", new Object[0]))))) continue;
            try {
                this.tenantId = Integer.parseInt(tenantId);
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("EntityViewDDLCreator.Wizard.invalidTenantIdMsg", tenantId));
            }
        } while (!validTenantId);
        boolean validEntityPath = false;
        do {
            String entityPath;
            if (!StringUtil.isNotBlank((String)(entityPath = this.readConsole(this.rs("EntityViewDDLCreator.Wizard.entityPathMsg", new Object[0]))))) continue;
            this.setEntityPath(entityPath);
            validEntityPath = true;
        } while (!validEntityPath);
        String outFile = this.readConsole(this.rs("EntityViewDDLCreator.Wizard.outFilePathMsg", this.outFile));
        if (StringUtil.isNotBlank((String)outFile)) {
            this.setOutFile(outFile);
        }
        this.setOverwrite(this.readConsoleBoolean(this.rs("EntityViewDDLCreator.Wizard.overwriteMsg", new Object[0]), this.isOverwrite));
        this.setRecursive(this.readConsoleBoolean(this.rs("EntityViewDDLCreator.Wizard.recursiveMsg", new Object[0]), this.isRecursive));
        this.switchLog(false, true);
        return this.executeTask(null, param -> this.proceed());
    }

    private boolean proceed() {
        this.setSuccess(false);
        TenantContext tc = tenantContextService.getTenantContext(this.tenantId);
        if (tc == null) {
            this.logError(this.rs("EntityViewDDLCreator.notFoundTenant", this.tenantId));
            return this.isSuccess();
        }
        Path outFilePath = Paths.get(this.outFile, new String[0]);
        if (!this.isOverwrite && Files.exists(outFilePath, new LinkOption[0])) {
            this.logError(this.rs("EntityViewDDLCreator.alreadyExistOutFilePath", this.outFile));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> {
            EntityDefinition ed = this.edm.get(this.entityPath);
            if (ed != null) {
                entityToolService.createViewDDL(outFilePath, new EntityDefinition[]{ed});
            } else {
                List defSumList = this.edm.definitionSummaryList(this.entityPath, this.isRecursive);
                if (defSumList.isEmpty()) {
                    this.logError(this.rs("EntityViewDDLCreator.notFoundEntityPath", this.entityPath));
                    return this.isSuccess();
                }
                EntityDefinition[] eds = (EntityDefinition[])defSumList.stream().filter(ds -> !ROOT_ENTITY.equals(ds.getPath())).map(ds -> this.edm.get(ds.getName())).toArray(EntityDefinition[]::new);
                entityToolService.createViewDDL(outFilePath, eds);
            }
            this.setSuccess(true);
            return this.isSuccess();
        });
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

