/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.metadata;

import org.apache.commons.lang3.StringUtils;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.PatchEntityDataParameter;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.ExecMode;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataPatch
extends MtpCuiBase {
    private static Logger logger = LoggerFactory.getLogger(MetaDataPatch.class);
    private static final String EMPTY = "_empty_";
    private ExecMode execMode = ExecMode.WIZARD;
    private int tenantId = -1;
    private String oldMetaDataFilePath;
    private String newMetaDataFilePath;
    private String userId;
    private String password;
    private TenantContextService tenantContextService = (TenantContextService)ServiceRegistry.getRegistry().getService(TenantContextService.class);
    private MetaDataPortingService service = (MetaDataPortingService)ServiceRegistry.getRegistry().getService(MetaDataPortingService.class);

    public MetaDataPatch(String ... args) {
        if (args.length > 0) {
            this.execMode = ExecMode.valueOf(args[0].toUpperCase());
        }
        if (args.length > 1) {
            if (!this.isEmpty(args[1])) {
                this.tenantId = Integer.parseInt(args[1]);
            }
            if (this.tenantId < 0) {
                this.execMode = ExecMode.WIZARD;
            }
        }
        if (args.length > 2) {
            this.oldMetaDataFilePath = args[2];
            if (this.isEmpty(this.oldMetaDataFilePath)) {
                this.execMode = ExecMode.WIZARD;
            }
        }
        if (args.length > 3) {
            this.newMetaDataFilePath = args[3];
            if (this.isEmpty(this.newMetaDataFilePath)) {
                this.execMode = ExecMode.WIZARD;
            }
        }
        if (args.length > 4 && !this.isEmpty(args[4])) {
            this.userId = args[4];
        }
        if (args.length > 5 && !this.isEmpty(args[5])) {
            this.password = args[5];
        }
    }

    public static void main(String ... args) {
        try {
            new MetaDataPatch(args).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MtpBatchResourceDisposer.disposeResource();
        }
    }

    private boolean isEmpty(String str) {
        return StringUtil.isBlank((String)str) || EMPTY.equals(str.toLowerCase());
    }

    private boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.execMode) {
            case WIZARD: {
                return this.proceed(this.wizard());
            }
            case SILENT: {
                this.switchLog(false, true);
                return this.proceed(this.silent());
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.execMode));
        return false;
    }

    private PatchEntityDataParameter silent() {
        PatchEntityDataParameter param = new PatchEntityDataParameter();
        param.setTenantId(this.tenantId);
        if (StringUtil.isEmpty((String)this.oldMetaDataFilePath)) {
            this.logWarn(this.rs("Silent.noOldMetaDataFilePathMsg", new Object[0]));
            return null;
        }
        param.setOldMetaDataFilePath(this.oldMetaDataFilePath);
        if (StringUtil.isEmpty((String)this.newMetaDataFilePath)) {
            this.logWarn(this.rs("Silent.noNewMetaDataFilePathMsg", new Object[0]));
            return null;
        }
        param.setNewMetaDataFilePath(this.newMetaDataFilePath);
        return param;
    }

    private PatchEntityDataParameter wizard() {
        PatchEntityDataParameter param = new PatchEntityDataParameter();
        boolean validTenantId = false;
        do {
            String input;
            if (StringUtil.isEmpty((String)(input = this.readConsole(this.rs("Wizard.inputTenantIdMsg", new Object[0]))))) {
                this.logWarn(this.rs("Wizard.requiredTenantIdMsg", new Object[0]));
                continue;
            }
            try {
                param.setTenantId(Integer.parseInt(input));
                validTenantId = true;
            }
            catch (NumberFormatException e) {
                this.logWarn(this.rs("Wizard.warnTenantIdMsg", new Object[0]));
            }
        } while (!validTenantId);
        boolean validOldMetaDataFilePath = false;
        do {
            String input;
            if (StringUtil.isEmpty((String)(input = this.readConsole(this.rs("Wizard.inputOldMetaDataFilePathMsg", new Object[0]))))) {
                this.logWarn(this.rs("Wizard.requiredOldMetaDataFilePathMsg", new Object[0]));
                continue;
            }
            param.setOldMetaDataFilePath(input);
            validOldMetaDataFilePath = true;
        } while (!validOldMetaDataFilePath);
        boolean validNewMetaDataFilePath = false;
        do {
            String input;
            if (StringUtil.isEmpty((String)(input = this.readConsole(this.rs("Wizard.inputNewMetaDataFilePathMsg", new Object[0]))))) {
                this.logWarn(this.rs("Wizard.requiredNewMetaDataFilePathMsg", new Object[0]));
                continue;
            }
            param.setNewMetaDataFilePath(input);
            validNewMetaDataFilePath = true;
        } while (!validNewMetaDataFilePath);
        this.userId = this.readConsole(this.rs("Wizard.inputUserIdMsg", new Object[0]));
        if (StringUtil.isNotBlank((String)this.userId)) {
            this.password = this.readConsole(this.rs("Wizard.inputPasswordMsg", new Object[0]));
        }
        return param;
    }

    private void logArguments(PatchEntityDataParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\t" + this.rs("Proceed.tenantId", new Object[0]) + " :" + param.getTenantId());
        this.logInfo("\t" + this.rs("Proceed.oldMetaDataFilePath", new Object[0]) + " :" + param.getOldMetaDataFilePath());
        this.logInfo("\t" + this.rs("Proceed.newMetaDataFilePath", new Object[0]) + " :" + param.getNewMetaDataFilePath());
        if (StringUtil.isNotBlank((String)this.userId)) {
            this.logInfo("\t" + this.rs("Proceed.userId", new Object[0]) + " :" + this.userId);
        }
        if (StringUtil.isNotBlank((String)this.password)) {
            this.logInfo("\t" + this.rs("Proceed.password", new Object[0]) + " :" + StringUtils.repeat((char)'*', (int)this.password.length()));
        }
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    private boolean proceed(PatchEntityDataParameter param) {
        if (param == null) {
            return false;
        }
        if (ExecMode.WIZARD == this.execMode) {
            boolean validExecute = false;
            do {
                boolean retry;
                this.logArguments(param);
                validExecute = this.readConsoleBoolean(this.rs("Wizard.confirmExecutePatchMsg", new Object[0]), false);
                if (validExecute || !(retry = this.readConsoleBoolean(this.rs("Wizard.confirmRetryMsg", new Object[0]), true))) continue;
                this.wizard();
            } while (!validExecute);
        }
        this.switchLog(false, true);
        this.logArguments(param);
        this.setSuccess(false);
        TenantContext tc = this.tenantContextService.getTenantContext(param.getTenantId());
        if (tc == null) {
            this.logError(this.rs("Proceed.notFoundTenantMsg", param.getTenantId()));
            return this.isSuccess();
        }
        return (Boolean)ExecuteContext.executeAs((TenantContext)tc, () -> this.executeTask(param, paramA -> {
            this.setSuccess(this.proceedPatch((PatchEntityDataParameter)paramA));
            return this.isSuccess();
        }));
    }

    private boolean proceedPatch(PatchEntityDataParameter param) {
        if (StringUtil.isNotBlank((String)this.userId)) {
            this.service.patchEntityDataWithUserAuth(param, this.userId, this.password);
        } else {
            this.service.patchEntityDataWithPrivilegedAuth(param);
        }
        return true;
    }

    @Override
    protected String rs(String key, Object ... args) {
        return super.rs("MetaDataPatch." + key, args);
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }
}

