/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.batch.partition;

import java.util.List;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tools.batch.MtpBatchResourceDisposer;
import org.iplass.mtp.tools.batch.MtpCuiBase;
import org.iplass.mtp.tools.batch.partition.PartitionBatch;
import org.iplass.mtp.tools.gui.partition.MySQLPartitionManagerApp;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLPartitionBatch
extends MtpCuiBase
implements PartitionBatch {
    private static Logger logger = LoggerFactory.getLogger(PostgreSQLPartitionBatch.class);
    private PostgreSQLPartitionBatchExecMode execMode = PostgreSQLPartitionBatchExecMode.GUI;
    private TenantToolService toolService = (TenantToolService)ServiceRegistry.getRegistry().getService(TenantToolService.class);

    public static void main(String[] args) {
        PostgreSQLPartitionBatch instance = null;
        try {
            instance = new PostgreSQLPartitionBatch(args);
            instance.execute();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (instance.getExecMode() == PostgreSQLPartitionBatchExecMode.GUI) {
                MtpBatchResourceDisposer.addShutdownHookForDisposeResource(() -> {});
            } else {
                MtpBatchResourceDisposer.disposeResource();
            }
        }
    }

    public PostgreSQLPartitionBatch(String ... args) {
        if (args != null && args.length > 0) {
            this.setExecMode(PostgreSQLPartitionBatchExecMode.valueOf(args[0]));
        }
    }

    public boolean execute() {
        this.clearLog();
        this.switchLog(true, false);
        this.logEnvironment();
        switch (this.getExecMode()) {
            case GUI: {
                this.logInfo("\u25a0Start App");
                this.logInfo("");
                this.switchLog(false, true);
                MySQLPartitionManagerApp.main(new String[]{this.getLanguage()});
                return true;
            }
            case CREATE: {
                this.logInfo("\u25a0Start Create Wizard");
                this.logInfo("");
                return this.startCreateWizard();
            }
        }
        this.logError("unsupport execute mode : " + (Object)((Object)this.getExecMode()));
        return false;
    }

    public PostgreSQLPartitionBatchExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(PostgreSQLPartitionBatchExecMode execMode) {
        this.execMode = execMode;
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return this.toolService.getPartitionInfo();
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param) {
        param.setLoggerLanguage(this.getLanguage());
        this.setSuccess(false);
        boolean isSuccess = this.toolService.createPartition(param, new LogHandler(){

            public void info(String message) {
                PostgreSQLPartitionBatch.this.logInfo(message);
            }

            public void info(String message, Throwable e) {
                PostgreSQLPartitionBatch.this.logInfo(message, e);
            }

            public void warn(String message) {
                PostgreSQLPartitionBatch.this.logWarn(message);
            }

            public void warn(String message, Throwable e) {
                PostgreSQLPartitionBatch.this.logWarn(message, e);
            }

            public void error(String message) {
                PostgreSQLPartitionBatch.this.logError(message);
            }

            public void error(String message, Throwable e) {
                PostgreSQLPartitionBatch.this.logError(message, e);
            }
        });
        this.setSuccess(isSuccess);
        return this.isSuccess();
    }

    private boolean startCreateWizard() {
        String strMaxTenantId = this.readConsole(this.rs("Create.inputMaxTenantIdMsg", new Object[0]));
        if (StringUtil.isEmpty((String)strMaxTenantId)) {
            this.logWarn(this.rs("Create.requiredMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-show")) {
            this.showAllPartitionList();
            return this.startCreateWizard();
        }
        if (strMaxTenantId.equalsIgnoreCase("-env")) {
            this.logEnvironment();
            return this.startCreateWizard();
        }
        PartitionCreateParameter param = new PartitionCreateParameter();
        param.setOnlyPartitionCreate(true);
        try {
            int maxTenantId = Integer.parseInt(strMaxTenantId);
            param.setTenantId(maxTenantId);
        }
        catch (Exception e) {
            this.logWarn(this.rs("Create.warnMaxTenantIdMsg", new Object[0]));
            return this.startCreateWizard();
        }
        boolean invalidateSubPartitionSize = true;
        do {
            int subPartitionSize;
            if ((subPartitionSize = this.readConsoleInteger(this.rs("Create.inputSubPartitionSizeMsg", new Object[0]), 8)) < 0) {
                this.logWarn(this.rs("Create.warnSubPartitionSizeMsg", 0));
                continue;
            }
            param.setSubPartitionSize(subPartitionSize);
            invalidateSubPartitionSize = false;
        } while (invalidateSubPartitionSize);
        this.logArguments(param);
        boolean isExecute = this.readConsoleBoolean(this.rs("Create.confirmCreatePartitionMsg", new Object[0]), false);
        if (!isExecute) {
            return this.startCreateWizard();
        }
        this.switchLog(false, true);
        return this.executeTask(param, paramA -> this.createPartition((PartitionCreateParameter)paramA));
    }

    private void showAllPartitionList() {
        try {
            List<PartitionInfo> partitionList = this.getPartitionInfo();
            this.logInfo("-----------------------------------------------------------");
            this.logInfo("\u25a0Partition List(Max Tenant ID)");
            for (PartitionInfo partition : partitionList) {
                this.logInfo("[" + partition.getTableName() + "] " + partition.getMaxTenantId());
            }
            this.logInfo("-----------------------------------------------------------");
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private void logArguments(PartitionCreateParameter param) {
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("\u25a0Execute Argument");
        this.logInfo("\tmax tenant id :" + param.getTenantId());
        this.logInfo("\tsub partition size :" + param.getSubPartitionSize());
        this.logInfo("-----------------------------------------------------------");
        this.logInfo("");
    }

    @Override
    protected String rs(String key, Object ... args) {
        return super.rs("PostgreSQLPartitionBatch." + key, args);
    }

    @Override
    protected Logger loggingLogger() {
        return logger;
    }

    public static enum PostgreSQLPartitionBatchExecMode {
        GUI,
        CREATE;

    }
}

