/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tools.gui.partition;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;

public class PartitionTable
extends JTable {
    private static final long serialVersionUID = 6158350463892104161L;
    private PartitionTableModel model;

    public PartitionTable() {
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
        List<PartitionTableColumnInfo> cols = this.initColumnInfo();
        this.model = new PartitionTableModel(cols);
        this.setModel(this.model);
        for (int i = 0; i < cols.size(); ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(cols.get(i).getColSize());
        }
    }

    @Override
    public PartitionTableModel getModel() {
        return this.model;
    }

    private List<PartitionTableColumnInfo> initColumnInfo() {
        ArrayList<PartitionTableColumnInfo> cols = new ArrayList<PartitionTableColumnInfo>();
        cols.add(new PartitionTableColumnInfo("TableName", 300));
        cols.add(new PartitionTableColumnInfo("MaxTenantId", 150));
        return cols;
    }

    public static class PartitionTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -7508376391663965403L;
        private List<PartitionInfo> data;

        public PartitionTableModel(List<PartitionTableColumnInfo> cols) {
            for (PartitionTableColumnInfo col : cols) {
                this.addColumn(col.getName());
            }
        }

        public void setPartitionData(List<PartitionInfo> data) {
            this.data = data;
        }

        public PartitionInfo getPartitionInfo(int row) {
            if (row >= this.getRowCount()) {
                return null;
            }
            return this.data.get(row);
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            PartitionInfo info = this.getPartitionInfo(row);
            if (info == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    return info.getTableName();
                }
                case 1: {
                    return info.getMaxTenantId();
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (this.getRowCount() == 0) {
                return String.class;
            }
            Object value = this.getValueAt(0, column);
            if (value == null) {
                return String.class;
            }
            return value.getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private static class PartitionTableColumnInfo {
        private String name;
        private int colSize;

        public PartitionTableColumnInfo(String name, int colSize) {
            this.name = name;
            this.colSize = colSize;
        }

        public String getName() {
            return this.name;
        }

        public int getColSize() {
            return this.colSize;
        }
    }
}

