/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.auth.builtin;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinition;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.AccountControlSQL;
import org.iplass.mtp.impl.auth.authenticate.builtin.sql.AccountSelectSQL;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.auth.builtin.cond.UserSpecificCondition;
import org.iplass.mtp.impl.tools.auth.builtin.sql.AccountMaintenanceSelectSQL;
import org.iplass.mtp.tenant.Tenant;

public class AccountToolDao {
    private RdbAdapter rdb;
    private AccountMaintenanceSelectSQL accountMaintenance;
    private AccountSelectSQL accountSelect;
    private AccountControlSQL accountControl;

    public AccountToolDao(RdbAdapter rdb) {
        this.rdb = rdb;
        this.accountMaintenance = (AccountMaintenanceSelectSQL)rdb.getQuerySqlCreator(AccountMaintenanceSelectSQL.class);
        this.accountSelect = (AccountSelectSQL)rdb.getQuerySqlCreator(AccountSelectSQL.class);
        this.accountControl = (AccountControlSQL)rdb.getUpdateSqlCreator(AccountControlSQL.class);
    }

    public int countAccount(final UserSpecificCondition cond, final AuthenticationPolicyDefinition authPolicy) {
        final Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        SqlExecuter<Integer> executer = new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                String sql = AccountToolDao.this.accountMaintenance.createAccountCountSQL(AccountToolDao.this.rdb, tenant, cond, authPolicy);
                PreparedStatement ps = this.getPreparedStatement(sql);
                AccountToolDao.this.accountMaintenance.setAccountCountParameter(AccountToolDao.this.rdb, ps, tenant, cond, authPolicy);
                int ret = 0;
                try (ResultSet rs = ps.executeQuery();){
                    ret = AccountToolDao.this.accountMaintenance.getAccountCountResultData(rs);
                }
                return ret;
            }
        };
        return (Integer)executer.execute(this.rdb, true);
    }

    public void searchAccount(final UserSpecificCondition cond, final AuthenticationPolicyDefinition authPolicy, final int limit, final int offset, final Predicate<BuiltinAccount> callback) {
        final Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            public Void logic() throws SQLException {
                String sql = AccountToolDao.this.accountMaintenance.createAccountSearchSQL(AccountToolDao.this.rdb, tenant, cond, authPolicy);
                if (limit > 0) {
                    int limitOffset = 0;
                    if (offset > 0) {
                        limitOffset = offset;
                    }
                    sql = AccountToolDao.this.rdb.toLimitSql(sql, limit, limitOffset);
                }
                PreparedStatement ps = this.getPreparedStatement(sql);
                AccountToolDao.this.accountMaintenance.setAccountSearchParameter(AccountToolDao.this.rdb, ps, tenant, cond, authPolicy);
                try (ResultSet rs = ps.executeQuery();){
                    AccountToolDao.this.accountMaintenance.getAccountSearchResultData(AccountToolDao.this.rdb, rs, callback);
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }

    public BuiltinAccount getAccount(final String accountId) {
        SqlExecuter<BuiltinAccount> executer = new SqlExecuter<BuiltinAccount>(){

            public BuiltinAccount logic() throws SQLException {
                Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                PreparedStatement ps = this.getPreparedStatement(AccountToolDao.this.accountSelect.createAccountSQL());
                AccountToolDao.this.accountSelect.setAccountParameter(AccountToolDao.this.rdb, ps, tenant.getId(), accountId);
                try (ResultSet rs = ps.executeQuery();){
                    BuiltinAccount builtinAccount = AccountToolDao.this.accountSelect.getAccount(rs, AccountToolDao.this.rdb);
                    return builtinAccount;
                }
            }
        };
        return (BuiltinAccount)executer.execute(this.rdb, true);
    }

    public void resetLoginErrorCnt(final BuiltinAccount account) {
        SqlExecuter<BuiltinAccount> executer = new SqlExecuter<BuiltinAccount>(){

            public BuiltinAccount logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(AccountToolDao.this.accountControl.createResetLoginErrorCntSQL(AccountToolDao.this.rdb));
                AccountToolDao.this.accountControl.setResetLoginErrorCntParameter(AccountToolDao.this.rdb, ps, account);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("Update Fail. Maybe concurrent modification occured:accountId=" + account.getAccountId());
                }
                return null;
            }
        };
        executer.execute(this.rdb, true);
    }
}

