/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.auth.builtin;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.time.DateUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinition;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinitionManager;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tools.auth.builtin.AccountToolDao;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUser;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUserCsvWriter;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUserResetErrorCountResult;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUserSearchParameter;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUserSearchResult;
import org.iplass.mtp.impl.tools.auth.builtin.cond.SearchOperator;
import org.iplass.mtp.impl.tools.auth.builtin.cond.UserAttributeCondition;
import org.iplass.mtp.impl.tools.auth.builtin.cond.UserSpecificCondition;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinAuthToolService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(BuiltinAuthToolService.class);
    private RdbAdapter rdb;
    private AccountToolDao accountToolDao;
    private EntityManager em;
    private AuthenticationPolicyDefinitionManager apdm;

    public void init(Config config) {
        this.rdb = ((RdbAdapterService)config.getDependentService(RdbAdapterService.class)).getRdbAdapter();
        this.accountToolDao = new AccountToolDao(this.rdb);
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.apdm = (AuthenticationPolicyDefinitionManager)ManagerLocator.getInstance().getManager(AuthenticationPolicyDefinitionManager.class);
    }

    public void destroy() {
    }

    public BuiltinAuthUserSearchResult search(BuiltinAuthUserSearchParameter param) {
        BuiltinAuthUserSearchResult result = new BuiltinAuthUserSearchResult();
        if (param.getCondition() instanceof UserSpecificCondition) {
            UserSpecificCondition cond = (UserSpecificCondition)param.getCondition();
            AuthenticationPolicyDefinition authPolicy = null;
            if (cond.getType() == UserSpecificCondition.SpecificType.LOCKED) {
                authPolicy = this.apdm.getOrDefault(cond.getLockedUserPolicyName());
                if (authPolicy.getAccountLockoutPolicy().getLockoutFailureCount() == 0) {
                    result.setTotalCount(0);
                    result.setExecuteOffset(0);
                    result.setUsers(Collections.emptyList());
                    return result;
                }
            } else if (cond.getType() == UserSpecificCondition.SpecificType.EXPIRED_PASSWORD && (authPolicy = this.apdm.getOrDefault(cond.getPasswordRemainDaysPolicyName())).getPasswordPolicy().getMaximumPasswordAge() == 0) {
                result.setTotalCount(0);
                result.setExecuteOffset(0);
                result.setUsers(Collections.emptyList());
                return result;
            }
            int totalCount = this.countAccount(cond, authPolicy);
            result.setTotalCount(totalCount);
            if (param.getOffset() > 0 && totalCount <= param.getOffset()) {
                result.addMessages("\u8a72\u5f53\u4ef6\u6570(" + totalCount + ")\u3088\u308aoffset(" + param.getOffset() + ")\u304c\u5927\u304d\u3044\u305f\u3081\u3001offset\u30920\u306b\u3057\u3066\u691c\u7d22\u3057\u307e\u3059\u3002");
                param.setOffset(0);
            }
            result.setExecuteOffset(param.getOffset());
            final ArrayList<BuiltinAuthUser> userList = new ArrayList<BuiltinAuthUser>();
            this.searchAccount(cond, authPolicy, param.getLimit(), param.getOffset(), new Predicate<BuiltinAuthUser>(){

                @Override
                public boolean test(BuiltinAuthUser user) {
                    userList.add(user);
                    return true;
                }
            });
            result.setUsers(userList);
        } else if (param.getCondition() instanceof UserAttributeCondition) {
            UserAttributeCondition cond = (UserAttributeCondition)param.getCondition();
            try {
                Where where = this.getUserWhere(cond);
                int totalCount = this.countUser(where);
                result.setTotalCount(totalCount);
                if (param.getOffset() > 0 && totalCount <= param.getOffset()) {
                    result.addMessages("\u8a72\u5f53\u4ef6\u6570(" + totalCount + ")\u3088\u308aoffset(" + param.getOffset() + ")\u304c\u5927\u304d\u3044\u305f\u3081\u3001offset\u30920\u306b\u3057\u3066\u691c\u7d22\u3057\u307e\u3059\u3002");
                    param.setOffset(0);
                }
                result.setExecuteOffset(param.getOffset());
                final ArrayList<BuiltinAuthUser> userList = new ArrayList<BuiltinAuthUser>();
                this.searchUser(where, param.getLimit(), param.getOffset(), new Predicate<BuiltinAuthUser>(){

                    @Override
                    public boolean test(BuiltinAuthUser user) {
                        userList.add(user);
                        return true;
                    }
                });
                result.setUsers(userList);
            }
            catch (QueryException e) {
                result.setError(true);
                result.addMessages(e.getMessage());
                result.addMessages("Where:" + cond.getDirectWhere());
            }
        } else {
            result.setError(true);
            result.addMessages("unsupport condition type. condition is " + (param.getCondition() != null ? param.getCondition().getClass().getName() : "null"));
            return result;
        }
        return result;
    }

    public void exportCsv(OutputStream os, BuiltinAuthUserSearchParameter param) throws IOException {
        try (final BuiltinAuthUserCsvWriter writer = new BuiltinAuthUserCsvWriter(os);){
            writer.writeHeader();
            this.search(param, new Predicate<BuiltinAuthUser>(){

                @Override
                public boolean test(BuiltinAuthUser user) {
                    try {
                        writer.writeUser(user);
                    }
                    catch (IOException e) {
                        logger.error("An error occurred in the CSV output of Auth User.", (Throwable)e);
                        throw new SystemException((Throwable)e);
                    }
                    return true;
                }
            });
        }
    }

    private int countAccount(UserSpecificCondition cond, AuthenticationPolicyDefinition authPolicy) {
        return this.accountToolDao.countAccount(cond, authPolicy);
    }

    private void searchAccount(UserSpecificCondition cond, final AuthenticationPolicyDefinition authPolicy, int limit, int offset, final Predicate<BuiltinAuthUser> callback) {
        this.accountToolDao.searchAccount(cond, authPolicy, limit, offset, new Predicate<BuiltinAccount>(){

            @Override
            public boolean test(BuiltinAccount account) {
                return callback.test(BuiltinAuthToolService.this.toAuthUserByAccount(account, authPolicy));
            }
        });
    }

    private BuiltinAuthUser toAuthUserByAccount(BuiltinAccount account, AuthenticationPolicyDefinition authPolicy) {
        BuiltinAuthUser authUser = new BuiltinAuthUser();
        authUser.setAccountExist(true);
        authUser.setAccountId(account.getAccountId());
        authUser.setOid(account.getOid());
        authUser.setPolicyName(account.getPolicyName());
        authUser.setLoginErrorCnt(account.getLoginErrorCnt());
        authUser.setLoginErrorDate(account.getLoginErrorDate());
        authUser.setLastLoginOn(account.getLastLoginOn());
        authUser.setLastPasswordChange(account.getLastPasswordChange());
        if (authPolicy == null) {
            authPolicy = this.apdm.getOrDefault(account.getPolicyName());
        }
        authUser.setPasswordRemainDays(this.getPasswordRemainDays(account.getLastPasswordChange(), authPolicy));
        this.applyUser(authUser);
        return authUser;
    }

    private void applyUser(BuiltinAuthUser authUser) {
        User user = (User)this.em.load(authUser.getOid(), "mtp.auth.User", new LoadOption(false, false));
        if (user != null) {
            authUser.setUserExist(true);
            authUser.setName(user.getName());
            authUser.setMail(user.getMail());
            authUser.setStartDate(user.getStartDate());
            authUser.setEndDate(user.getEndDate());
            authUser.setAdmin(user.isAdmin());
        }
    }

    private Where getUserWhere(UserAttributeCondition cond) {
        Where where = new Where();
        ArrayList<Object> conditions = new ArrayList<Object>();
        if (StringUtil.isNotBlank((String)cond.getAccountId())) {
            conditions.add(new Like("accountId", cond.getAccountId(), Like.MatchPattern.PARTIAL));
        }
        if (StringUtil.isNotBlank((String)cond.getName())) {
            String name = cond.getName();
            String[] names = null;
            names = name.contains(" ") ? name.split(" ", 2) : (name.contains("\u3000") ? name.split("\u3000", 2) : new String[]{name});
            if (names.length == 2) {
                conditions.add(new Or(new Condition[]{new And(new Condition[]{new Like("firstName", names[0], Like.MatchPattern.PARTIAL), new Like("lastName", names[1], Like.MatchPattern.PARTIAL)}), new And(new Condition[]{new Like("lastName", names[0], Like.MatchPattern.PARTIAL), new Like("firstName", names[1], Like.MatchPattern.PARTIAL)}), new And(new Condition[]{new Like("firstNameKana", names[0], Like.MatchPattern.PARTIAL), new Like("lastNameKana", names[1], Like.MatchPattern.PARTIAL)}), new And(new Condition[]{new Like("lastNameKana", names[0], Like.MatchPattern.PARTIAL), new Like("firstNameKana", names[1], Like.MatchPattern.PARTIAL)})}));
            } else if (names.length == 1) {
                conditions.add(new Or(new Condition[]{new Like("firstName", names[0], Like.MatchPattern.PARTIAL), new Like("lastName", names[0], Like.MatchPattern.PARTIAL), new Like("firstNameKana", names[0], Like.MatchPattern.PARTIAL), new Like("lastNameKana", names[0], Like.MatchPattern.PARTIAL)}));
            }
        }
        if (StringUtil.isNotBlank((String)cond.getMail())) {
            conditions.add(new Like("mail", cond.getMail(), Like.MatchPattern.PARTIAL));
        }
        if (cond.getValidTermRemainDaysOparator() != null) {
            conditions.add(new IsNotNull("endDate"));
            Date sysDate = new Date(System.currentTimeMillis());
            if (cond.getValidTermRemainDays() <= 0) {
                conditions.add(new Lesser("endDate", (Object)this.adjustTimes(sysDate, 0, 0, 0, 0)));
            } else {
                java.util.Date calcDate = DateUtils.addDays((java.util.Date)sysDate, (int)cond.getValidTermRemainDays());
                if (SearchOperator.EQUAL == cond.getValidTermRemainDaysOparator()) {
                    conditions.add(new And(new Condition[]{new GreaterEqual("endDate", (Object)this.adjustTimes(calcDate, 0, 0, 0, 0)), new LesserEqual("endDate", (Object)this.adjustTimes(calcDate, 23, 59, 59, 999))}));
                } else if (SearchOperator.LESSEQUAL == cond.getValidTermRemainDaysOparator()) {
                    conditions.add(new LesserEqual("endDate", (Object)this.adjustTimes(calcDate, 23, 59, 59, 999)));
                }
            }
        }
        if (cond.getDirectWhere() != null && !cond.getDirectWhere().isEmpty()) {
            conditions.add(new PreparedQuery(cond.getDirectWhere()).condition(null));
        }
        if (!conditions.isEmpty()) {
            where.setCondition((Condition)new And(conditions));
        }
        return where;
    }

    private int countUser(Where where) {
        Query countQuery = new Query();
        countQuery.select(new Object[]{"accountId"}).from("mtp.auth.User").where(where.getCondition()).setVersiond(false);
        return this.em.count(countQuery);
    }

    private void searchUser(Where where, int limit, int offset, final Predicate<BuiltinAuthUser> callback) {
        Query query = new Query();
        query.selectAll("mtp.auth.User", true, false, false).where(where.getCondition()).order(new SortSpec[]{new SortSpec("accountId", SortSpec.SortType.ASC)}).limit(limit, offset).setVersiond(false);
        this.em.searchEntity(query, (Predicate)new Predicate<User>(){

            @Override
            public boolean test(User user) {
                return callback.test(BuiltinAuthToolService.this.toAuthUserByUser(user));
            }
        });
    }

    private Date adjustTimes(java.util.Date date, int hour, int minute, int second, int millisecond) {
        Calendar cal = DateUtil.getCalendar((boolean)true);
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millisecond);
        return new Date(cal.getTimeInMillis());
    }

    private BuiltinAuthUser toAuthUserByUser(User user) {
        BuiltinAuthUser authUser = new BuiltinAuthUser();
        authUser.setUserExist(true);
        authUser.setAccountId(user.getAccountId());
        authUser.setOid(user.getOid());
        authUser.setPolicyName(user.getAccountPolicy());
        authUser.setName(user.getName());
        authUser.setMail(user.getMail());
        authUser.setStartDate(user.getStartDate());
        authUser.setEndDate(user.getEndDate());
        authUser.setAdmin(user.isAdmin());
        this.applyAccount(authUser);
        return authUser;
    }

    private void applyAccount(BuiltinAuthUser authUser) {
        BuiltinAccount account = this.accountToolDao.getAccount(authUser.getAccountId());
        if (account != null) {
            authUser.setAccountExist(true);
            AuthenticationPolicyDefinition authPolicy = this.apdm.getOrDefault(authUser.getPolicyName());
            authUser.setLoginErrorCnt(account.getLoginErrorCnt());
            authUser.setLoginErrorDate(account.getLoginErrorDate());
            authUser.setLastLoginOn(account.getLastLoginOn());
            authUser.setLastPasswordChange(account.getLastPasswordChange());
            authUser.setPasswordRemainDays(this.getPasswordRemainDays(account.getLastPasswordChange(), authPolicy));
        }
    }

    private void search(BuiltinAuthUserSearchParameter param, final Predicate<BuiltinAuthUser> callback) {
        if (param.getCondition() instanceof UserSpecificCondition) {
            UserSpecificCondition cond = (UserSpecificCondition)param.getCondition();
            AuthenticationPolicyDefinition authPolicy = null;
            if (cond.getType() == UserSpecificCondition.SpecificType.LOCKED ? (authPolicy = this.apdm.getOrDefault(cond.getLockedUserPolicyName())).getAccountLockoutPolicy().getLockoutFailureCount() == 0 : cond.getType() == UserSpecificCondition.SpecificType.EXPIRED_PASSWORD && (authPolicy = this.apdm.getOrDefault(cond.getPasswordRemainDaysPolicyName())).getPasswordPolicy().getMaximumPasswordAge() == 0) {
                return;
            }
            this.searchAccount(cond, authPolicy, param.getLimit(), param.getOffset(), new Predicate<BuiltinAuthUser>(){

                @Override
                public boolean test(BuiltinAuthUser user) {
                    return callback.test(user);
                }
            });
        } else if (param.getCondition() instanceof UserAttributeCondition) {
            UserAttributeCondition cond = (UserAttributeCondition)param.getCondition();
            Where where = this.getUserWhere(cond);
            this.searchUser(where, param.getLimit(), param.getOffset(), new Predicate<BuiltinAuthUser>(){

                @Override
                public boolean test(BuiltinAuthUser user) {
                    return callback.test(user);
                }
            });
        }
    }

    public BuiltinAuthUserResetErrorCountResult resetErrorCount(List<String> accountIds) {
        BuiltinAuthUserResetErrorCountResult result = new BuiltinAuthUserResetErrorCountResult();
        try {
            int allCount = 0;
            for (String accountId : accountIds) {
                BuiltinAccount account = this.accountToolDao.getAccount(accountId);
                if (account == null) {
                    result.addMessages("not found " + accountId + ".");
                    continue;
                }
                this.accountToolDao.resetLoginErrorCnt(account);
                ++allCount;
                result.addMessages("reset login error count for " + account.getAccountId() + ".");
            }
            result.addMessages("Result : SUCCESS");
            result.addMessages("Reset Count : " + allCount);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            result.setError(true);
            result.addMessages("Result : FAILURE");
            result.addMessages("Cause : " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName()));
        }
        return result;
    }

    private Integer getPasswordRemainDays(Date lastPasswordChange, AuthenticationPolicyDefinition authPolicy) {
        if (lastPasswordChange == null) {
            return null;
        }
        int maxAge = authPolicy.getPasswordPolicy().getMaximumPasswordAge();
        if (maxAge > 0) {
            Date lastPasswordChangeDate = InternalDateUtil.truncateTime((Date)lastPasswordChange);
            Date limitDate = InternalDateUtil.addDays((Date)lastPasswordChangeDate, (int)maxAge);
            Date now = ExecuteContext.getCurrentContext().getCurrentLocalDate();
            return InternalDateUtil.diffDays((Date)limitDate, (Date)now);
        }
        return null;
    }
}

