/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.auth.builtin;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.iplass.mtp.impl.tools.auth.builtin.BuiltinAuthUser;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.web.template.TemplateUtil;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

public class BuiltinAuthUserCsvWriter
implements Closeable {
    private CsvMapWriter csvWriter;
    private CellProcessor[] processors;
    private String[] header = new String[]{"OID", "Account ID", "Name", "Mail", "Policy Name", "Admin", "Error Count", "Login Error Date", "Last PW Change", "PW Remain Days", "Last Login", "Start Date", "End Date"};

    public BuiltinAuthUserCsvWriter(OutputStream out) throws IOException {
        out.write(239);
        out.write(187);
        out.write(191);
        this.init(new OutputStreamWriter(out, "UTF-8"));
    }

    private void init(Writer writer) {
        this.csvWriter = new CsvMapWriter(writer, new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).surroundingSpacesNeedQuotes(true).build());
        this.createCellProcessor();
    }

    public void writeHeader() throws SuperCsvException, IOException {
        this.csvWriter.writeHeader(this.header);
    }

    public void writeUser(BuiltinAuthUser user) throws IOException {
        HashMap<String, Object> recordMap = new HashMap<String, Object>(this.header.length);
        int no = 0;
        recordMap.put(this.header[no++], user.getOid());
        recordMap.put(this.header[no++], user.getAccountId());
        recordMap.put(this.header[no++], user.getName());
        recordMap.put(this.header[no++], user.getMail());
        recordMap.put(this.header[no++], user.getPolicyName());
        recordMap.put(this.header[no++], user.isAdmin());
        recordMap.put(this.header[no++], user.getLoginErrorCnt());
        recordMap.put(this.header[no++], user.getLoginErrorDate());
        recordMap.put(this.header[no++], user.getLastPasswordChange());
        recordMap.put(this.header[no++], user.getPasswordRemainDays());
        recordMap.put(this.header[no++], user.getLastLoginOn());
        recordMap.put(this.header[no++], user.getStartDate());
        recordMap.put(this.header[no++], user.getEndDate());
        this.csvWriter.write(recordMap, this.header, this.processors);
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    private void createCellProcessor() {
        ArrayList<ConvertNullTo> processors = new ArrayList<ConvertNullTo>();
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)"", (CellProcessor)new FmtDateTimeEx()));
        processors.add(new ConvertNullTo((Object)"", (CellProcessor)new FmtDateEx()));
        processors.add(new ConvertNullTo((Object)""));
        processors.add(new ConvertNullTo((Object)"", (CellProcessor)new FmtDateTimeEx()));
        processors.add(new ConvertNullTo((Object)"", (CellProcessor)new FmtDateEx()));
        processors.add(new ConvertNullTo((Object)"", (CellProcessor)new FmtDateEx()));
        this.processors = processors.toArray(new CellProcessor[0]);
    }

    private class FmtDateTimeEx
    extends CellProcessorAdaptor
    implements DateCellProcessor {
        public <T> T execute(Object value, CsvContext context) throws SuperCsvException {
            if (value == null) {
                throw new SuperCsvCellProcessorException("Input cannot be null on line " + context.getLineNumber() + " column " + context.getColumnNumber(), context, (CellProcessor)this);
            }
            if (!(value instanceof Timestamp)) {
                throw new SuperCsvCellProcessorException("the value '" + value + "' is not of type Timestamp", context, (CellProcessor)this);
            }
            String result = DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputDatetimeSecFormat(), (boolean)true).format((Timestamp)value);
            return (T)this.next.execute((Object)result, context);
        }
    }

    private class FmtDateEx
    extends CellProcessorAdaptor
    implements DateCellProcessor {
        public <T> T execute(Object value, CsvContext context) throws SuperCsvException {
            if (value == null) {
                throw new SuperCsvCellProcessorException("Input cannot be null on line " + context.getLineNumber() + " column " + context.getColumnNumber(), context, (CellProcessor)this);
            }
            if (!(value instanceof Date)) {
                throw new SuperCsvCellProcessorException("the value '" + value + "' is not of type Date", context, (CellProcessor)this);
            }
            String result = DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputDateFormat(), (boolean)false).format((Date)value);
            return (T)this.next.execute((Object)result, context);
        }
    }
}

