/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.clean;

import java.sql.Timestamp;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.tools.entityport.EntityDataPortingRuntimeException;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecycleBinCleanService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(RecycleBinCleanService.class);
    private EntityManager em = null;
    private EntityDefinitionManager edm = null;

    public void init(Config config) {
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    }

    public void destroy() {
    }

    public void clean(final Timestamp purgeTargetDate, final String[] entityDefinitionNames) {
        Transaction.required((Consumer)new Consumer<Transaction>(){

            @Override
            public void accept(Transaction t) {
                if (purgeTargetDate == null) {
                    logger.error("Purge target date is null.");
                    throw new EntityDataPortingRuntimeException("Purge target date can not be null.");
                }
                String[] definitionNames = entityDefinitionNames;
                if (definitionNames == null) {
                    definitionNames = RecycleBinCleanService.this.edm.definitionList().toArray(new String[0]);
                }
                for (final String definitionName : definitionNames) {
                    RecycleBinCleanService.this.em.getRecycleBin(definitionName, (Predicate)new Predicate<Entity>(){

                        @Override
                        public boolean test(Entity dataModel) {
                            if (dataModel.getUpdateDate().before(purgeTargetDate)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("purge " + definitionName + " data. purgeTargetDate=" + purgeTargetDate);
                                }
                                RecycleBinCleanService.this.em.purge(dataModel.getRecycleBinId().longValue(), definitionName);
                            }
                            return true;
                        }
                    });
                }
            }
        });
    }
}

