/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.entity;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.util.StringUtil;

public class EntityJavaMappingClassWriter
implements Closeable {
    private EntityDefinition definition;
    private PrintWriter writer;
    private String directClassName;
    private ClassInfo classInfo;
    private Set<String> imports;
    private List<PropertyInfo> properties;

    public EntityJavaMappingClassWriter(OutputStream out, EntityDefinition definition, String directClassName) throws IOException {
        this.writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        this.definition = definition;
        this.directClassName = directClassName;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void writeJavaClass() throws IOException {
        if (this.definition == null) {
            return;
        }
        this.analyze();
        this.writePackage();
        this.writeImports();
        this.writeClassComment();
        this.writeClassDef();
        this.writeStaticField();
        this.writeConstractor();
        this.writeFieldAccessor();
        this.writeClassEndTag();
    }

    private void analyze() {
        this.analyzeClassName();
        this.analyzeProperty();
    }

    private void analyzeClassName() {
        this.classInfo = new ClassInfo();
        String classFullName = null;
        classFullName = StringUtil.isNotBlank((String)this.directClassName) ? this.directClassName : (this.definition.getMapping() != null && StringUtil.isNotBlank((String)this.definition.getMapping().getMappingModelClass()) ? this.definition.getMapping().getMappingModelClass() : this.definition.getName());
        String packageName = null;
        packageName = classFullName.lastIndexOf(".") >= 0 ? classFullName.substring(0, classFullName.lastIndexOf(".")) : "";
        this.classInfo.packageName = packageName;
        this.classInfo.className = this.getSimpleClassName(classFullName);
    }

    private void analyzeProperty() {
        this.properties = new ArrayList<PropertyInfo>();
        this.imports = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        this.imports.add("org.iplass.mtp.entity.GenericEntity");
        for (PropertyDefinition propDef : this.definition.getPropertyList()) {
            if (propDef.isInherited()) continue;
            PropertyInfo property = new PropertyInfo();
            property.propertyName = propDef.getName();
            property.propertyDisplayName = propDef.getDisplayName();
            property.constName = StringUtil.decamelize((String)propDef.getName());
            property.methodName = StringUtil.capitalize((String)StringUtil.camelize((String)property.constName));
            if (propDef instanceof ReferenceProperty) {
                property.typeFullClassName = this.getReferenceClassName((ReferenceProperty)propDef);
                property.typeClassName = this.getSimpleClassName(property.typeFullClassName);
                property.isReference = true;
            } else {
                property.typeFullClassName = propDef.getJavaType().getName();
                property.typeClassName = propDef.getJavaType().getSimpleName();
                property.isReference = false;
            }
            if (!property.typeFullClassName.startsWith("java.lang")) {
                this.imports.add(property.typeFullClassName);
            }
            property.isArray = propDef.getMultiplicity() > 1 || propDef.getMultiplicity() == -1;
            property.isBoolean = propDef.getJavaType() == Boolean.class;
            property.isReadOnly = propDef.isReadOnly();
            this.properties.add(property);
        }
    }

    private String getSimpleClassName(String classFullName) {
        if (classFullName.lastIndexOf(".") >= 0) {
            return StringUtil.capitalize((String)classFullName.substring(classFullName.lastIndexOf(".") + 1));
        }
        return StringUtil.capitalize((String)classFullName);
    }

    private String getReferenceClassName(ReferenceProperty property) {
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        EntityDefinition definition = edm.get(property.getObjectDefinitionName());
        if (definition != null && definition.getMapping() != null) {
            return definition.getMapping().getMappingModelClass();
        }
        return property.getJavaType().getName();
    }

    private void writePackage() {
        if (StringUtil.isNotBlank((String)this.classInfo.packageName)) {
            this.writer.println("package " + this.classInfo.packageName + ";");
            this.writer.println("");
        }
    }

    private void writeImports() {
        Iterator<String> ite = this.imports.iterator();
        while (ite.hasNext()) {
            this.writer.println("import " + ite.next() + ";");
        }
        this.writer.println("");
    }

    private void writeClassComment() {
        this.writer.println("/**");
        String displayName = null;
        displayName = StringUtil.isBlank((String)this.definition.getDisplayName()) ? this.definition.getName() : this.definition.getDisplayName();
        this.writer.println(" * " + displayName + " Entity\u3002");
        if (StringUtil.isNotBlank((String)this.definition.getDescription())) {
            String description = this.definition.getDescription();
            description = "<p>" + description + "</p>";
            description.replaceAll("\r\n", "\n");
            description.replaceAll("\r", "\n");
            String[] descArray = description.split("\n");
            this.writer.println(" * ");
            for (String desc : descArray) {
                this.writer.println(" * " + desc);
            }
        }
        this.writer.println(" */");
    }

    private void writeClassDef() {
        this.writer.println("public class " + this.classInfo.className + " extends GenericEntity {");
        this.writer.println("");
    }

    private void writeStaticField() {
        this.writer.println("\tprivate static final long serialVersionUID = 1L;");
        this.writer.println("");
        this.writer.println("\t/** Entity Definition Name */");
        this.writer.println("\tpublic static final String DEFINITION_NAME = \"" + this.definition.getName() + "\";");
        this.writer.println("");
        for (PropertyInfo property : this.properties) {
            this.writer.println("\t/** " + property.propertyDisplayName + " */");
            this.writer.println("\tpublic static final String " + property.constName + " = \"" + property.propertyName + "\";");
        }
        this.writer.println("");
    }

    private void writeConstractor() {
        this.writer.println("\tpublic " + this.classInfo.className + "() {");
        this.writer.println("\t\tsetDefinitionName(DEFINITION_NAME);");
        this.writer.println("\t}");
        this.writer.println("");
    }

    private void writeFieldAccessor() {
        for (PropertyInfo property : this.properties) {
            String typeMultiSuffix = "";
            if (property.isArray) {
                typeMultiSuffix = "[]";
            }
            this.writer.println("\t/**");
            this.writer.println("\t * " + property.propertyDisplayName + "\u3092\u8fd4\u3057\u307e\u3059\u3002");
            this.writer.println("\t * ");
            this.writer.println("\t * @return " + property.propertyDisplayName);
            this.writer.println("\t */");
            this.writer.println("\tpublic " + property.typeClassName + typeMultiSuffix + " get" + property.methodName + "() {");
            if (property.isReference && property.isArray) {
                this.writer.println("\t\tObject value = getValue(" + property.constName + ");");
                this.writer.println("\t\tif (value instanceof " + property.typeClassName + ") {");
                this.writer.println("\t\t\treturn new " + property.typeClassName + "[]{(" + property.typeClassName + ")value};\t//for search");
                this.writer.println("\t\t} else {");
                this.writer.println("\t\t\treturn (" + property.typeClassName + "[])value;\t//for load");
                this.writer.println("\t\t}");
            } else {
                this.writer.println("\t\treturn getValue(" + property.constName + ");");
            }
            this.writer.println("\t}");
            this.writer.println("");
            if (property.isBoolean && !property.isArray) {
                this.writer.println("\t/**");
                this.writer.println("\t * " + property.propertyDisplayName + "\u3092\u8fd4\u3057\u307e\u3059\u3002");
                this.writer.println("\t * \u5024\u304cnull\u306e\u5834\u5408\u306ffalse\u3092\u8fd4\u3057\u307e\u3059\u3002");
                this.writer.println("\t * ");
                this.writer.println("\t * @return " + property.propertyDisplayName);
                this.writer.println("\t */");
                this.writer.println("\tpublic boolean is" + property.methodName + "() {");
                this.writer.println("\t\tBoolean value = getValue(" + property.constName + ");");
                this.writer.println("\t\tif (value == null) {");
                this.writer.println("\t\t\treturn false;");
                this.writer.println("\t\t}");
                this.writer.println("\t\treturn value.booleanValue();");
                this.writer.println("\t}");
                this.writer.println("");
            }
            if (property.isReadOnly) continue;
            this.writer.println("\t/**");
            this.writer.println("\t * " + property.propertyDisplayName + "\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
            this.writer.println("\t * ");
            this.writer.println("\t * @param " + property.propertyName + " " + property.propertyDisplayName);
            this.writer.println("\t */");
            this.writer.println("\tpublic void set" + property.methodName + "(" + property.typeClassName + typeMultiSuffix + " " + property.propertyName + ") {");
            this.writer.println("\t\tsetValue(" + property.constName + ", " + property.propertyName + ");");
            this.writer.println("\t}");
            this.writer.println("");
        }
    }

    private void writeClassEndTag() {
        this.writer.println("}");
    }

    private class PropertyInfo {
        public String propertyName;
        public String propertyDisplayName;
        public String constName;
        public String methodName;
        public String typeFullClassName;
        public String typeClassName;
        public boolean isArray;
        public boolean isReadOnly;
        public boolean isBoolean;
        public boolean isReference;

        private PropertyInfo() {
        }
    }

    private class ClassInfo {
        public String packageName;
        public String className;

        private ClassInfo() {
        }
    }
}

