/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.entity;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCredential;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.csv.QueryCsvWriter;
import org.iplass.mtp.impl.entity.csv.QueryWriteOption;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.entity.EntityDataDeleteResultInfo;
import org.iplass.mtp.impl.tools.entity.EntityJavaMappingClassWriter;
import org.iplass.mtp.impl.tools.entity.EntityToolRuntimeException;
import org.iplass.mtp.impl.tools.entity.EntityUpdateAllCondition;
import org.iplass.mtp.impl.tools.entity.EntityUpdateAllResultInfo;
import org.iplass.mtp.impl.tools.entity.EntityViewDDLWriter;
import org.iplass.mtp.impl.tools.entity.UpdateAllValue;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityToolService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(EntityToolService.class);
    private static final String USER_ENTITY = "mtp.auth.User";
    private AuthService as = null;
    private EntityManager em;
    private EntityDefinitionManager edm;

    public void init(Config config) {
        this.as = (AuthService)ServiceRegistry.getRegistry().getService(AuthService.class);
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    }

    public void destroy() {
    }

    public void createJavaMappingClass(File file, EntityDefinition definition, String basePackage) {
        Path path = Paths.get(file.getPath().substring(0, file.getPath().length() - file.getName().length()), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new EntityToolRuntimeException(this.getRS("createDirectoriesError", new Object[0]), e);
            }
        }
        String directClassName = StringUtil.isNotBlank((String)basePackage) ? basePackage + '.' + definition.getName() : null;
        try (EntityJavaMappingClassWriter writer = new EntityJavaMappingClassWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), definition, directClassName);){
            writer.writeJavaClass();
        }
        catch (IOException e) {
            throw new EntityToolRuntimeException(this.getRS("unexpectedError", new Object[0]), e);
        }
    }

    public void createViewDDL(Path path, EntityDefinition ... definitions) {
        try (EntityViewDDLWriter writer = new EntityViewDDLWriter(path);){
            writer.write(definitions);
        }
        catch (IOException e) {
            throw new EntityToolRuntimeException(this.getRS("unexpectedError", new Object[0]), e);
        }
    }

    public int executeEQL(String eql, boolean isSearchAllVersion, boolean isCount) {
        Query query = new PreparedQuery(eql).query(null);
        if (!query.isVersiond() && isSearchAllVersion) {
            query.setVersiond(true);
        }
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        int count = 0;
        try (SearchResult result = em.search(query, new SearchOption(SearchResult.ResultMode.STREAM).unnotifyListeners());){
            if (!isCount) {
                result.getFirst();
                int n = -1;
                return n;
            }
            for (Object[] row : result) {
                if (row == null) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeEQL(OutputStream out, String charset, String eql, boolean isSearchAllVersion) {
        Query query = null;
        try {
            query = new PreparedQuery(eql).query(null);
        }
        catch (QueryException e) {
            throw new EntityToolRuntimeException(this.getRS("invalidEQLStatement", eql), e);
        }
        if (!query.isVersiond() && isSearchAllVersion) {
            query.setVersiond(true);
        }
        try (QueryCsvWriter writer = new QueryCsvWriter(out, query, new QueryWriteOption().charset(charset));){
            int n = writer.write();
            return n;
        }
        catch (IOException e) {
            throw new EntityToolRuntimeException(this.getRS("errorOutputSearchResult", new Object[0]), e);
        }
    }

    public int executeEQLWithAuth(String eql, boolean isSearchAllVersion, boolean isCount) {
        return (Integer)this.as.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), () -> this.executeEQL(eql, isSearchAllVersion, isCount));
    }

    public int executeEQLWithAuth(OutputStream out, String charset, String eql, boolean isSearchAllVersion) {
        return (Integer)this.as.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), () -> this.executeEQL(out, charset, eql, isSearchAllVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeEQLWithAuth(String eql, boolean isSearchAllVersion, boolean isCount, String userId, String password) {
        try {
            this.as.login((Credential)(StringUtil.isNotEmpty((String)password) ? new IdPasswordCredential(userId, password) : new InternalCredential(userId)));
            int n = (Integer)this.as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> this.executeEQL(eql, isSearchAllVersion, isCount));
            return n;
        }
        finally {
            this.as.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeEQLWithAuth(OutputStream out, String charset, String eql, boolean isSearchAllVersion, String userId, String password) {
        try {
            this.as.login((Credential)(StringUtil.isNotEmpty((String)password) ? new IdPasswordCredential(userId, password) : new InternalCredential(userId)));
            int n = (Integer)this.as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> this.executeEQL(out, charset, eql, isSearchAllVersion));
            return n;
        }
        finally {
            this.as.logout();
        }
    }

    public EntityUpdateAllResultInfo updateAll(EntityUpdateAllCondition cond) {
        EntityUpdateAllResultInfo result = new EntityUpdateAllResultInfo();
        int updateCount = 0;
        try {
            UpdateCondition updateCond = new UpdateCondition(cond.getDefinitionName());
            EntityDefinition definition = this.getEntityDefinition(cond.getDefinitionName());
            ArrayList<String> validateErrors = new ArrayList<String>();
            for (UpdateAllValue entry : cond.getValues()) {
                PropertyDefinition pd = definition.getProperty(entry.getPropertyName());
                if (pd == null) {
                    validateErrors.add(entry.getPropertyName() + " property not found.");
                }
                String stringValue = entry.getValue();
                Object storevalue = null;
                if (stringValue != null) {
                    if (pd instanceof SelectProperty) {
                        storevalue = stringValue;
                    } else if (entry.getValueType() == UpdateAllValue.UpdateAllValueType.LITERAL) {
                        try {
                            storevalue = ConvertUtil.convertFromString((Class)pd.getJavaType(), (String)stringValue);
                        }
                        catch (NumberFormatException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            validateErrors.add(entry.getPropertyName() + " property value is unsupport format. cannot be parsed number. value = " + stringValue);
                        }
                        catch (IllegalArgumentException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            validateErrors.add(entry.getPropertyName() + " property value is unsupport format. " + e.getMessage() + " value = " + stringValue);
                        }
                    } else {
                        try {
                            storevalue = ValueExpression.newValue((String)stringValue);
                        }
                        catch (QueryException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            validateErrors.add(entry.getPropertyName() + " property value is unsupport format. " + e.getMessage() + " value = " + stringValue);
                        }
                    }
                }
                updateCond.value(entry.getPropertyName(), storevalue);
            }
            if (!validateErrors.isEmpty()) {
                result.setError(true);
                result.addLogMessage("Result : FAILURE");
                result.addLogMessage("Cause : validate error");
                result.addLogMessage(validateErrors);
                return result;
            }
            if (cond.getWhere() != null && !cond.getWhere().isEmpty()) {
                updateCond.where(cond.getWhere());
            }
            updateCond.setCheckUpdatable(cond.isCheckUpdatable());
            result.addLogMessage("Update Condition : " + updateCond.toString());
            updateCount = this.em.updateAll(updateCond);
            result.addLogMessage("Result : SUCCESS");
            result.addLogMessage("Update Count : " + updateCount);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            result.setError(true);
            result.addLogMessage("Result : FAILURE");
            result.addLogMessage("Cause : " + e.getMessage());
            return result;
        }
        result.setUpdateCount(updateCount);
        return result;
    }

    private EntityDefinition getEntityDefinition(String defName) {
        return this.edm.get(defName);
    }

    public EntityDataDeleteResultInfo deleteAll(int tenantId, final String defName, final String whereClause, final boolean isNotifyListeners, final int commitLimit) {
        return new Callable<EntityDataDeleteResultInfo>(){
            int allCount = 0;
            EntityHandler eh = null;
            String execCond;

            @Override
            public EntityDataDeleteResultInfo call() {
                final EntityDataDeleteResultInfo result = new EntityDataDeleteResultInfo();
                try {
                    this.execCond = whereClause;
                    ExecuteContext ec = ExecuteContext.getCurrentContext();
                    if (EntityToolService.USER_ENTITY.equals(defName)) {
                        String execUserOid = ec.getClientId();
                        this.execCond = StringUtil.isNotEmpty((String)whereClause) ? this.execCond + " and oid != '" + execUserOid + "'" : "oid != '" + execUserOid + "'";
                    }
                    boolean canDeleteAll = false;
                    if (!isNotifyListeners) {
                        EntityContext entityContext = EntityContext.getCurrentContext();
                        this.eh = entityContext.getHandlerByName(defName);
                        if (this.eh == null) {
                            throw new RuntimeException("not found entity definition. name = " + defName);
                        }
                        canDeleteAll = this.eh.canDeleteAll();
                    }
                    if (canDeleteAll) {
                        Transaction.with((Propagation)Propagation.REQUIRED, t -> {
                            try {
                                DeleteCondition cond = new DeleteCondition(defName);
                                if (StringUtil.isNotEmpty((String)this.execCond)) {
                                    cond.where(this.execCond);
                                    result.addMessages("Delete Condition : " + this.execCond);
                                } else {
                                    result.addMessages("Delete Condition : none");
                                }
                                this.allCount = EntityToolService.this.em.deleteAll(cond);
                                return null;
                            }
                            catch (RuntimeException e) {
                                logger.error("delete entity data failed.", (Throwable)e);
                                throw e;
                            }
                        });
                    } else {
                        Query query = new Query().select(new Object[]{"oid"}).from(defName);
                        if (StringUtil.isNotEmpty((String)this.execCond)) {
                            query.where(this.execCond);
                            result.addMessages("Delete Condition : " + this.execCond);
                        } else {
                            result.addMessages("Delete Condition : none");
                        }
                        final ArrayList entities = new ArrayList();
                        EntityToolService.this.em.searchEntity(query, (Predicate)new Predicate<Entity>(){

                            @Override
                            public boolean test(Entity entity) {
                                entities.add(entity);
                                if (commitLimit != -1 && entities.size() == commitLimit) {
                                    int count = EntityToolService.this.deleteData(defName, entities, isNotifyListeners);
                                    allCount += count;
                                    result.addMessages(count + " data is deleted and comitted.");
                                    entities.clear();
                                }
                                return true;
                            }
                        });
                        if (entities.size() > 0) {
                            int count = EntityToolService.this.deleteData(defName, entities, isNotifyListeners);
                            this.allCount += count;
                            result.addMessages(count + " data is deleted and comitted.");
                        }
                    }
                    result.setError(false);
                    result.addMessages("Result : SUCCESS");
                    result.addMessages("Delete Count : " + this.allCount);
                    return result;
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                    result.setError(true);
                    result.addMessages("Result : FAILURE");
                    result.addMessages("Cause : " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName()));
                    return result;
                }
            }
        }.call();
    }

    public EntityDataDeleteResultInfo deleteAllByOid(int tenantId, final String defName, final List<String> oids, final boolean isNotifyListeners, final int commitLimit) {
        return new Callable<EntityDataDeleteResultInfo>(){
            int allCount = 0;

            @Override
            public EntityDataDeleteResultInfo call() {
                EntityDataDeleteResultInfo result = new EntityDataDeleteResultInfo();
                try {
                    LoadOption loadOption = new LoadOption(false, false);
                    ArrayList<Entity> entities = new ArrayList<Entity>();
                    boolean isUserEntity = false;
                    String execUserOid = null;
                    if (EntityToolService.USER_ENTITY.equals(defName)) {
                        isUserEntity = true;
                        ExecuteContext executeContext = ExecuteContext.getCurrentContext();
                        execUserOid = executeContext.getClientId();
                    }
                    for (String oid : oids) {
                        Entity entity = EntityToolService.this.em.load(oid, defName, loadOption);
                        if (isUserEntity && oid.equals(execUserOid) || entity == null) continue;
                        entities.add(entity);
                        if (commitLimit == -1 || entities.size() != commitLimit) continue;
                        int count = EntityToolService.this.deleteData(defName, entities, isNotifyListeners);
                        this.allCount += count;
                        result.addMessages(count + " data is deleted and comitted.");
                        entities.clear();
                    }
                    if (entities.size() > 0) {
                        int count = EntityToolService.this.deleteData(defName, entities, isNotifyListeners);
                        this.allCount += count;
                        result.addMessages(count + " data is deleted and comitted.");
                    }
                    result.setError(false);
                    result.addMessages("Result : SUCCESS");
                    result.addMessages("Delete Count : " + this.allCount);
                    return result;
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                    result.setError(true);
                    result.addMessages("Result : FAILURE");
                    result.addMessages("Cause : " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName()));
                    return result;
                }
            }
        }.call();
    }

    private int deleteData(String defName, final List<Entity> entities, final boolean isNotifyListeners) {
        return (Integer)Transaction.requiresNew((Function)new Function<Transaction, Integer>(){
            private int delCount = 0;

            @Override
            public Integer apply(Transaction transaction) {
                try {
                    DeleteOption option = new DeleteOption(false);
                    option.setPurge(true);
                    option.setCheckLockedByUser(false);
                    option.setNotifyListeners(isNotifyListeners);
                    for (Entity entity : entities) {
                        EntityToolService.this.em.delete(entity, option);
                        ++this.delCount;
                    }
                    return this.delCount;
                }
                catch (RuntimeException e) {
                    logger.error("delete entity data failed.", (Throwable)e);
                    throw e;
                }
            }
        });
    }

    private String getRS(String suffix, Object ... arguments) {
        return ToolsResourceBundleUtil.resourceString("entitytool." + suffix, arguments);
    }
}

