/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.entity;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlConverter;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.ServiceRegistry;

public class EntityViewDDLWriter
implements Closeable {
    private static final String DEFAULT_LOB_ID_SUFFIX = "_LOBID";
    private RdbAdapter rdb = ((RdbAdapterService)ServiceRegistry.getRegistry().getService(RdbAdapterService.class)).getRdbAdapter();
    private Map<String, Integer> shrinkedEntityNameMap = new HashMap<String, Integer>();
    private String lobIdSuffix = "_LOBID";
    private Writer writer;

    public EntityViewDDLWriter(Path path) throws IOException {
        this.writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    public void setLobIdSuffix(String suffix) {
        this.lobIdSuffix = suffix;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void write(EntityDefinition ... definitions) throws IOException {
        for (EntityDefinition ed : definitions) {
            this.writeEntityViewDDL(ed);
            this.writeReferenceViewDDL(ed);
        }
    }

    private String shrinkEntityPath(String path, int index) {
        CharSequence[] splitedPaths = path.split("\\.");
        if (splitedPaths[index] != null && !splitedPaths[index].isEmpty()) {
            splitedPaths[index] = ((String)splitedPaths[index]).substring(0, 1);
        }
        return String.join((CharSequence)".", splitedPaths);
    }

    private String joinEntityPathName(String path, String name) {
        return path != null && !path.isEmpty() ? path + "." + name : name;
    }

    private String shrinkEntityName(String entityName) {
        int maxLength = this.rdb.getMaxViewNameLength();
        if (maxLength < 0) {
            return entityName;
        }
        String shrinkedEntityName = entityName;
        if (entityName.length() > maxLength) {
            String path = null;
            String name = null;
            int pathIndex = entityName.lastIndexOf(46);
            if (pathIndex != -1) {
                path = entityName.substring(0, pathIndex);
                name = entityName.substring(pathIndex + 1);
            } else {
                name = entityName;
            }
            if (path != null && !path.isEmpty()) {
                int index = 0;
                int pathSize = path.split("\\.").length;
                while (shrinkedEntityName.length() > maxLength) {
                    if (index >= pathSize) {
                        shrinkedEntityName = shrinkedEntityName.substring(0, maxLength);
                        break;
                    }
                    path = this.shrinkEntityPath(path, index);
                    shrinkedEntityName = this.joinEntityPathName(path, name);
                    ++index;
                }
            } else {
                shrinkedEntityName = name.substring(0, maxLength);
            }
        }
        if (this.shrinkedEntityNameMap.containsKey(shrinkedEntityName)) {
            int cnt = this.shrinkedEntityNameMap.get(shrinkedEntityName) + 1;
            this.shrinkedEntityNameMap.put(shrinkedEntityName, cnt);
            String suffix = String.format("#%d", cnt);
            shrinkedEntityName = shrinkedEntityName.substring(0, shrinkedEntityName.length() - suffix.length()) + suffix;
        } else {
            this.shrinkedEntityNameMap.put(shrinkedEntityName, 1);
        }
        return shrinkedEntityName;
    }

    private String toViewName(String entityName) {
        return this.shrinkEntityName(entityName).replaceAll("\\.", "_");
    }

    private String toReferenceViewName(String entityName, String refColName) {
        return this.toViewName(String.format("%s$%s", entityName, refColName));
    }

    private void addColumn(StringBuilder sb, String column) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(column);
    }

    private String createViewColumn(int colNo, String colName, PropertyDefinitionType type) {
        switch (type) {
            case BINARY: {
                return this.rdb.createBinaryViewColumnSql(colNo, colName, this.lobIdSuffix);
            }
            case LONGTEXT: {
                return this.rdb.createLongTextViewColumnSql(colNo, colName, this.lobIdSuffix);
            }
        }
        return this.rdb.createViewColumnSql(colNo, colName);
    }

    private String toCreateViewDDL(String entityName, String columnSql, String selectSql) {
        String sql = String.format("SELECT %s FROM (%s) %s", columnSql, selectSql, this.rdb.getViewSubQueryAlias());
        return this.rdb.toCreateViewDDL(this.toViewName(entityName), sql, true);
    }

    private String generateEntityViewDDL(EntityDefinition ed) {
        StringBuilder sbColumn = new StringBuilder();
        StringBuilder sbProperty = new StringBuilder();
        int colNo = 1;
        block4: for (PropertyDefinition pd : ed.getPropertyList()) {
            int multiplicity = pd.getMultiplicity();
            switch (pd.getType()) {
                case EXPRESSION: {
                    this.addColumn(sbProperty, "null");
                    this.addColumn(sbColumn, this.createViewColumn(colNo, pd.getName(), pd.getType()));
                    ++colNo;
                    continue block4;
                }
                case REFERENCE: {
                    continue block4;
                }
            }
            this.addColumn(sbProperty, pd.getName());
            if (multiplicity > 1) {
                for (int i = 0; i < multiplicity; ++i) {
                    this.addColumn(sbColumn, this.createViewColumn(colNo, String.format("%s_%d", pd.getName(), i + 1), pd.getType()));
                    ++colNo;
                }
                continue;
            }
            this.addColumn(sbColumn, this.createViewColumn(colNo, pd.getName(), pd.getType()));
            colNo += multiplicity;
        }
        EntityContext ec = EntityContext.getCurrentContext();
        SqlQueryContext sqc = new SqlQueryContext(ec.getHandlerByName(ed.getName()), ec, this.rdb);
        SqlConverter sc = new SqlConverter(sqc, false);
        String eql = String.format("SELECT %s FROM %s", sbProperty.toString(), ed.getName());
        Query.newQuery((String)eql).accept((QueryVisitor)sc);
        return this.toCreateViewDDL(ed.getName(), sbColumn.toString(), sqc.toSelectSql());
    }

    private void writeEntityViewDDL(EntityDefinition ed) throws IOException {
        String ddl = this.generateEntityViewDDL(ed);
        this.writer.write(String.format("/* drop/create %s */\n", ed.getName()));
        this.writer.write(ddl);
    }

    private String generateReferenceViewDDL(EntityDefinition ed, PropertyDefinition pd) {
        String eql = String.format("SELECT oid, version, %s.oid, %s.version FROM %s", pd.getName(), pd.getName(), ed.getName());
        EntityContext ec = EntityContext.getCurrentContext();
        SqlQueryContext sqc = new SqlQueryContext(ec.getHandlerByName(ed.getName()), ec, this.rdb);
        SqlConverter sc = new SqlConverter(sqc, false);
        Query.newQuery((String)eql).accept((QueryVisitor)sc);
        StringBuilder sbCol = new StringBuilder();
        this.addColumn(sbCol, this.createViewColumn(1, "oid", PropertyDefinitionType.STRING));
        this.addColumn(sbCol, this.createViewColumn(2, "version", PropertyDefinitionType.INTEGER));
        this.addColumn(sbCol, this.createViewColumn(3, pd.getName() + "_oid", PropertyDefinitionType.STRING));
        this.addColumn(sbCol, this.createViewColumn(4, pd.getName() + "_version", PropertyDefinitionType.INTEGER));
        return this.toCreateViewDDL(this.toReferenceViewName(ed.getName(), pd.getName()), sbCol.toString(), sqc.toSelectSql());
    }

    private void writeReferenceViewDDL(EntityDefinition ed) throws IOException {
        List pdList = ed.getPropertyList().stream().filter(pd -> pd.getType() == PropertyDefinitionType.REFERENCE).collect(Collectors.toList());
        for (PropertyDefinition pd2 : pdList) {
            String ddl = this.generateReferenceViewDDL(ed, pd2);
            this.writer.write(String.format("/* drop/create %s$%s */\n", ed.getName(), pd2.getName()));
            this.writer.write(ddl);
        }
    }
}

