/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.entityport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.csv.EntityCsvImportOption;
import org.iplass.mtp.impl.csv.EntityCsvImportResult;
import org.iplass.mtp.impl.csv.EntityCsvImportService;
import org.iplass.mtp.impl.entity.csv.EntitySearchCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.parser.SyntaxService;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QuerySyntaxRegister;
import org.iplass.mtp.impl.tools.entityport.EntityDataExportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.entityport.EntityDataPortingRuntimeException;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public class EntityPortingService
implements Service {
    public static final String ENTITY_LOB_DIR = "lobs/";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSXXX";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private int uploadableCsvDownloadLoadSize;
    private SyntaxService syntaxService;
    private EntityDefinitionManager edm;

    public void init(Config config) {
        this.uploadableCsvDownloadLoadSize = (Integer)config.getValue("uploadableCsvDownloadLoadSize", Integer.class, (Object)1);
        this.syntaxService = (SyntaxService)config.getDependentService(SyntaxService.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    }

    public void destroy() {
    }

    public int write(OutputStream os, MetaDataEntry entry, EntityDataExportCondition condition) throws IOException {
        return this.writeWithBinary(os, entry, condition, null);
    }

    public int writeWithBinary(OutputStream os, MetaDataEntry entry, EntityDataExportCondition condition, ZipOutputStream zos) throws IOException {
        return this.writeWithBinary(os, entry, condition, zos, null);
    }

    public int writeWithBinary(OutputStream os, MetaDataEntry entry, EntityDataExportCondition condition, ZipOutputStream zos, String exportBinaryDataDir) throws IOException {
        EntityDefinition definition = this.edm.get(entry.getMetaData().getName());
        Where where = null;
        if (StringUtil.isNotEmpty((String)condition.getWhereClause())) {
            where = Where.newWhere((String)("where " + condition.getWhereClause()));
        }
        OrderBy orderBy = null;
        if (StringUtil.isNotEmpty((String)condition.getOrderByClause())) {
            try {
                SyntaxContext sc = this.syntaxService.getSyntaxContext(QuerySyntaxRegister.QUERY_CONTEXT);
                orderBy = ((OrderBySyntax)sc.getSyntax(OrderBySyntax.class)).parse(new ParseContext("order by " + condition.getOrderByClause()));
            }
            catch (ParseException e) {
                throw new EntityDataPortingRuntimeException(e);
            }
        } else {
            orderBy = new OrderBy();
            orderBy.add(new SortSpec("oid", SortSpec.SortType.ASC));
            orderBy.add(new SortSpec("version", SortSpec.SortType.ASC));
        }
        CsvUploadService csvUploadService = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
        EntityWriteOption option = new EntityWriteOption().withReferenceVersion(true).withBinary(true).exportBinaryDataDir(exportBinaryDataDir).where(where).orderBy(orderBy).dateFormat(DATE_FORMAT).datetimeSecFormat(DATE_TIME_FORMAT).timeSecFormat(TIME_FORMAT).loadSizeOfHasMultipleReferenceEntity(this.uploadableCsvDownloadLoadSize).mustOrderByWithLimit(csvUploadService.isMustOrderByWithLimit());
        int count = 0;
        try (EntitySearchCsvWriter writer = new EntitySearchCsvWriter(os, definition.getName(), option, zos);){
            count = writer.write();
        }
        return count;
    }

    public EntityDataImportResult importEntityData(String targetName, InputStream is, MetaDataEntry entry, EntityDataImportCondition condition, ZipFile zipFile) {
        return this.importEntityData(targetName, is, entry, condition, zipFile, null);
    }

    public EntityDataImportResult importEntityData(String targetName, InputStream is, MetaDataEntry entry, EntityDataImportCondition condition, ZipFile zipFile, String importBinaryDataDir) {
        EntityCsvImportOption option = new EntityCsvImportOption().truncate(condition.isTruncate()).bulkUpdate(condition.isBulkUpdate()).errorSkip(condition.isErrorSkip()).ignoreNotExistsProperty(condition.isIgnoreNotExistsProperty()).notifyListeners(condition.isNotifyListeners()).withValidation(condition.isWithValidation()).updateDisupdatableProperty(condition.isUpdateDisupdatableProperty()).insertEnableAuditPropertySpecification(condition.isInsertEnableAuditPropertySpecification()).prefixOid(condition.getPrefixOid()).commitLimit(condition.getCommitLimit()).fourceUpdate(condition.isFourceUpdate()).uniqueKey(condition.getUniqueKey()).locale(condition.getLocale()).timezone(condition.getTimezone());
        List<String> excludeEntityNames = Arrays.asList("mtp.maintenance.Package", "mtp.maintenance.MetaDataTag");
        EntityCsvImportService service = (EntityCsvImportService)ServiceRegistry.getRegistry().getService(EntityCsvImportService.class);
        EntityCsvImportResult ret = service.importEntityData(targetName, is, entry, option, zipFile, importBinaryDataDir, excludeEntityNames);
        EntityDataImportResult result = new EntityDataImportResult();
        result.setInsertCount(ret.getInsertCount());
        result.setUpdateCount(ret.getUpdateCount());
        result.setDeleteCount(ret.getDeleteCount());
        result.setMergeCount(ret.getMergeCount());
        result.setErrorCount(ret.getErrorCount());
        result.setError(ret.isError());
        result.setMessages(ret.getMessages());
        return result;
    }
}

