/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.lang;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.tools.lang.LangDataPortingInfo;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangDataPortingService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(LangDataPortingService.class);
    private DefinitionService definitionService;

    public void init(Config config) {
        this.definitionService = (DefinitionService)config.getDependentService(DefinitionService.class);
    }

    public void destroy() {
    }

    public List<LangDataPortingInfo> getDefinitionInfo(List<String> paths) {
        ArrayList<LangDataPortingInfo> infoList = new ArrayList<LangDataPortingInfo>();
        for (String path : paths) {
            LangDataPortingInfo info = this.getLangDataPortingInfo(path);
            if (info == null) continue;
            infoList.add(info);
        }
        return infoList;
    }

    public LangDataPortingInfo getLangDataPortingInfo(String path) {
        String replacedPath = this.definitionService.getPath(path);
        logger.debug("path(" + path + ") to (" + replacedPath + ")");
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(replacedPath);
        if (entry == null) {
            logger.warn("metadata " + replacedPath + " is not found.");
            return null;
        }
        LangDataPortingInfo info = null;
        RootMetaData meta = entry.getMetaData();
        if (meta instanceof RootMetaData && meta instanceof DefinableMetaData && (info = this.currentConfig(meta)).getDefinition() == null) {
            return null;
        }
        return info;
    }

    private LangDataPortingInfo currentConfig(RootMetaData meta) {
        Definition definition = this.definitionService.toDefinition(meta);
        String name = meta.getName();
        String contextPath = this.definitionService.getPrefixPath(definition.getClass());
        LangDataPortingInfo info = new LangDataPortingInfo();
        info.setDefinition(definition);
        info.setContextPath(contextPath);
        info.setName(name);
        return info;
    }
}

