/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.metaport;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportHandler;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingRuntimeException;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataImportHandlerImpl
implements MetaDataImportHandler {
    private static Logger auditLogger = LoggerFactory.getLogger((String)"mtp.audit.porting.metadata");
    private EntityService ehService;

    public void inited(MetaDataPortingService service, Config config) {
        this.ehService = (EntityService)config.getDependentService(EntityService.class);
    }

    public void destroyed() {
    }

    @Override
    public void storeMetaData(String path, RootMetaData importMeta, MetaDataEntry entry, boolean doAutoReload) {
        auditLogger.info("store metadata," + importMeta.getClass().getName() + ",path:" + path);
        if (StringUtil.isEmpty((String)importMeta.getId())) {
            importMeta.setId(new KeyGenerator().generateId());
        }
        if (importMeta instanceof MetaEntity) {
            this.storeMetaEntity(path, (MetaEntity)importMeta, entry, doAutoReload);
        } else {
            MetaDataConfig config = new MetaDataConfig(entry.isSharable(), entry.isOverwritable(), entry.isDataSharable(), entry.isPermissionSharable());
            MetaDataContext.getContext().store(path, importMeta, config, doAutoReload);
        }
    }

    private void storeMetaEntity(String path, MetaEntity newEntity, MetaDataEntry entry, boolean doAutoReload) {
        MetaDataConfig config = new MetaDataConfig(entry.isSharable(), entry.isOverwritable(), entry.isDataSharable(), entry.isPermissionSharable());
        this.ehService.createDataModelSchema(newEntity, config, doAutoReload);
    }

    @Override
    public void updateMetaData(String path, RootMetaData importMeta, MetaDataEntry entry, boolean doAutoReload) {
        auditLogger.info("update metadata," + importMeta.getClass().getName() + ",path:" + path);
        if (importMeta instanceof MetaEntity) {
            this.updateMetaEntity(path, (MetaEntity)importMeta, entry, doAutoReload);
        } else {
            MetaDataConfig config = new MetaDataConfig(entry.isSharable(), entry.isOverwritable(), entry.isDataSharable(), entry.isPermissionSharable());
            MetaDataContext.getContext().update(path, importMeta, config, doAutoReload);
        }
    }

    private void updateMetaEntity(String path, MetaEntity newEntity, MetaDataEntry entry, boolean doAutoReload) {
        MetaDataConfig config = new MetaDataConfig(entry.isSharable(), entry.isOverwritable(), entry.isDataSharable(), entry.isPermissionSharable());
        Future result = this.ehService.updateDataModelSchema(newEntity, config);
        try {
            result.get();
        }
        catch (ExecutionException e) {
            throw new MetaDataPortingRuntimeException("exception occured during entity definition update:" + e.getCause().getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new MetaDataPortingRuntimeException("execution interrrupted during entity definition update:" + e.getMessage(), e);
        }
    }

    @Override
    public void removeMetaData(String path, RootMetaData removeMeta, boolean doAutoReload) {
        auditLogger.info("remove metadata," + removeMeta.getClass().getName() + ",path:" + path);
        if (removeMeta instanceof MetaEntity) {
            this.removeMetaEntity(path, (MetaEntity)removeMeta, doAutoReload);
        } else {
            MetaDataContext.getContext().remove(path, doAutoReload);
        }
    }

    private void removeMetaEntity(String path, MetaEntity removeEntity, boolean doAutoReload) {
        Future result = this.ehService.removeDataModelSchema(removeEntity);
        try {
            result.get();
        }
        catch (ExecutionException e) {
            throw new MetaDataPortingRuntimeException("exception occured during entity definition remove:" + e.getCause().getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new MetaDataPortingRuntimeException("execution interrrupted during entity definition remove:" + e.getMessage(), e);
        }
    }

    @Override
    public boolean isTenantMeta(String path) {
        return path.startsWith("/tenant/");
    }
}

