/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.metaport;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.util.StringUtil;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class MetaDataNameListCsvWriter
implements Closeable {
    private CsvMapWriter csvWriter;
    private boolean removeLineFeedCode = true;
    private String[] header = new String[]{"Path", "Name", "Display Name", "Description", "ID", "Repository"};
    private CellProcessor[] processors = new CellProcessor[]{new ConvertNullTo((Object)""), new ConvertNullTo((Object)""), new ConvertNullTo((Object)""), new ConvertNullTo((Object)""), new ConvertNullTo((Object)""), new ConvertNullTo((Object)"")};

    public MetaDataNameListCsvWriter(OutputStream out) throws IOException {
        this(out, true);
    }

    public MetaDataNameListCsvWriter(OutputStream out, boolean removeLineFeedCode) throws IOException {
        out.write(239);
        out.write(187);
        out.write(191);
        this.init(new OutputStreamWriter(out, "UTF-8"));
    }

    private void init(Writer writer) {
        this.csvWriter = new CsvMapWriter(writer, new CsvPreference.Builder(CsvPreference.EXCEL_PREFERENCE).surroundingSpacesNeedQuotes(true).build());
    }

    public void writeHeader() throws SuperCsvException, IOException {
        this.csvWriter.writeHeader(this.header);
    }

    public void writeEntry(MetaDataEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        RootMetaData meta = entry.getMetaData();
        HashMap<String, String> recordMap = new HashMap<String, String>(this.header.length);
        recordMap.put(this.header[0], entry.getPath());
        recordMap.put(this.header[1], meta.getName());
        recordMap.put(this.header[2], I18nUtil.stringMeta((String)meta.getDisplayName(), (List)meta.getLocalizedDisplayNameList()));
        recordMap.put(this.header[3], this.outputString(meta.getDescription()));
        recordMap.put(this.header[4], meta.getId());
        String repositryType = null;
        if (entry.getRepositryType() != null) {
            repositryType = entry.getRepositryType().name();
        }
        recordMap.put(this.header[5], repositryType);
        this.csvWriter.write(recordMap, this.header, this.processors);
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    private String outputString(String value) {
        if (this.removeLineFeedCode) {
            return StringUtil.removeLineFeedCode((String)value);
        }
        return value;
    }
}

