/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.metaport;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.internal.InternalCredential;
import org.iplass.mtp.impl.command.MetaMetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.core.config.ConfigImpl;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.impl.datastore.DataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataContextListener;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataJAXBService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.metadata.xmlresource.ContextPath;
import org.iplass.mtp.impl.metadata.xmlresource.MetaDataEntryList;
import org.iplass.mtp.impl.metadata.xmlresource.XmlResourceMetaDataEntryThinWrapper;
import org.iplass.mtp.impl.metadata.xmlresource.XmlResourceMetaDataStore;
import org.iplass.mtp.impl.script.MetaUtilityClass;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportHandler;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportResult;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportStatus;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingRuntimeException;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.MetaDataWriteCallback;
import org.iplass.mtp.impl.tools.metaport.MetaDataWriteLoggingCallback;
import org.iplass.mtp.impl.tools.metaport.PatchEntityDataParameter;
import org.iplass.mtp.impl.tools.metaport.XMLEntryInfo;
import org.iplass.mtp.impl.xml.jaxb.SecureSAXParserFactory;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaDataPortingServiceImpl
implements MetaDataPortingService {
    private static Logger logger = LoggerFactory.getLogger(MetaDataPortingServiceImpl.class);
    private static Logger toolLogger = LoggerFactory.getLogger((String)"mtp.tools.metadata");
    private AuthService authService;
    private MetaDataJAXBService jaxbService;
    private MetaTenantService metaTenantService;
    private TenantContextService tContextService;
    private MetaDataImportHandler importHandler;

    public void init(Config config) {
        this.authService = (AuthService)config.getDependentService(AuthService.class);
        this.jaxbService = (MetaDataJAXBService)config.getDependentService(MetaDataJAXBService.class);
        this.metaTenantService = (MetaTenantService)config.getDependentService(MetaTenantService.class);
        this.tContextService = (TenantContextService)config.getDependentService(TenantContextService.class);
        this.importHandler = (MetaDataImportHandler)config.getBean("importHandler");
    }

    public void destroy() {
    }

    @Override
    public void write(PrintWriter writer, List<String> paths) {
        this.write(writer, paths, new MetaDataWriteLoggingCallback());
    }

    @Override
    public void write(PrintWriter writer, List<String> paths, MetaDataWriteCallback callback) {
        try {
            JAXBContext jaxbContext = this.jaxbService.getJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            callback.onStarted();
            this.writeHeader(writer);
            String beforeContextPath = "";
            boolean isWriteContext = false;
            for (String path : paths) {
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(path);
                if (entry == null) {
                    if (!callback.onWarning(path, "not found metadata configure.", null)) break;
                    continue;
                }
                String contextPath = this.getContextPath(entry.getPath(), entry.getMetaData().getName());
                if (!beforeContextPath.equals(contextPath)) {
                    if (!beforeContextPath.isEmpty()) {
                        writer.println("</contextPath>");
                    }
                    beforeContextPath = contextPath;
                    writer.println("<contextPath name=\"" + StringUtil.escapeXml10((String)contextPath) + "\">");
                    isWriteContext = true;
                }
                this.writeMetaDataEntry(writer, marshaller, entry);
                callback.onWrited(path, String.valueOf(entry.getVersion()));
            }
            if (isWriteContext) {
                writer.println("</contextPath>");
            }
            this.writeFooter(writer);
            callback.onFinished();
        }
        catch (JAXBException e) {
            throw new MetaDataPortingRuntimeException(this.getRS("canNotParsed", this.getJAXBExceptionMessage(e)), e);
        }
    }

    @Override
    public XMLEntryInfo getXMLMetaDataEntryInfo(InputStream is) {
        JAXBContext jaxbContext = this.jaxbService.getJAXBContext();
        MetaDataEntryList metaDataList = null;
        try {
            Unmarshaller um = jaxbContext.createUnmarshaller();
            metaDataList = (MetaDataEntryList)um.unmarshal((Source)this.toSaxSource(is));
        }
        catch (JAXBException e) {
            String detail = "";
            if (e.getMessage() != null) {
                detail = e.getMessage();
            } else if (e.getCause() != null && e.getCause().getMessage() != null) {
                detail = e.getCause().getMessage();
            }
            throw new MetaDataPortingRuntimeException(this.getRS("canNotParsed", detail), e);
        }
        return this.parse(metaDataList);
    }

    @Override
    public void writeHistory(PrintWriter writer, String definitionId, String[] versions) {
        this.writeHistory(writer, definitionId, versions, new MetaDataWriteLoggingCallback());
    }

    @Override
    public void writeHistory(PrintWriter writer, String definitionId, String[] versions, MetaDataWriteCallback callback) {
        try {
            JAXBContext jaxbContext = this.jaxbService.getJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            callback.onStarted();
            this.writeHeader(writer);
            String beforeContextPath = "";
            boolean isWriteContext = false;
            for (String temp : versions) {
                int version = Integer.parseInt(temp);
                MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntryById(definitionId, version);
                if (entry == null) {
                    if (!callback.onWarning(null, "not found metadata configure.", null)) break;
                    continue;
                }
                String contextPath = this.getContextPath(entry.getPath(), entry.getMetaData().getName());
                if (!beforeContextPath.equals(contextPath)) {
                    if (!beforeContextPath.isEmpty()) {
                        writer.println("</contextPath>");
                    }
                    beforeContextPath = contextPath;
                    writer.println("<contextPath name=\"" + StringUtil.escapeXml10((String)contextPath) + "\">");
                    isWriteContext = true;
                }
                this.writeMetaDataEntry(writer, marshaller, entry);
                callback.onWrited(entry.getPath(), String.valueOf(entry.getVersion()));
            }
            if (isWriteContext) {
                writer.println("</contextPath>");
            }
            this.writeFooter(writer);
            callback.onFinished();
        }
        catch (JAXBException e) {
            throw new MetaDataPortingRuntimeException(this.getRS("canNotParsed", this.getJAXBExceptionMessage(e)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataImportResult importMetaData(String targetName, XMLEntryInfo entryInfo, Tenant importTenant) {
        MetaDataImportResult metaDataImportResult;
        toolLogger.info("start metadata import. {target:{}}", (Object)targetName);
        MetaDataImportResult result = new MetaDataImportResult();
        try {
            ArrayList<MetaDataEntry> entryList = new ArrayList<MetaDataEntry>(entryInfo.getPathEntryMap().values());
            metaDataImportResult = this.doImportMetaData(entryInfo, entryList, result, importTenant);
            toolLogger.info("finish metadata import. {target:{}, result:{}}", (Object)targetName, (Object)(result.isError() ? "failed" : "success"));
        }
        catch (Throwable throwable) {
            toolLogger.info("finish metadata import. {target:{}, result:{}}", (Object)targetName, (Object)(result.isError() ? "failed" : "success"));
            throw throwable;
        }
        return metaDataImportResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataImportResult importMetaData(String targetName, XMLEntryInfo entryInfo, List<String> selectedPaths, Tenant importTenant) {
        Object object;
        ArrayList<MetaDataEntry> entryList;
        XMLEntryInfo filterEntryInfo;
        MetaDataImportResult result;
        block7: {
            toolLogger.info("start metadata import. {target:{}}", (Object)targetName);
            result = new MetaDataImportResult();
            try {
                filterEntryInfo = this.filterSelectedPaths(entryInfo, selectedPaths);
                entryList = new ArrayList<MetaDataEntry>();
                String curPath = null;
                try {
                    object = selectedPaths.iterator();
                    while (object.hasNext()) {
                        String path;
                        curPath = path = object.next();
                        MetaDataEntry entry = filterEntryInfo.getPathEntry(path);
                        if (entry == null) {
                            throw new MetaDataPortingRuntimeException(this.getRS("canNotGetMeta", path));
                        }
                        entryList.add(entry);
                    }
                }
                catch (Exception e) {
                    this.errorForImportMetaDataEntry(curPath, e, result);
                }
                if (!result.isError()) break block7;
                object = result;
                toolLogger.info("finish metadata import. {target:{}, result:{}}", (Object)targetName, (Object)(result.isError() ? "failed" : "success"));
            }
            catch (Throwable throwable) {
                toolLogger.info("finish metadata import. {target:{}, result:{}}", (Object)targetName, (Object)(result.isError() ? "failed" : "success"));
                throw throwable;
            }
            return object;
        }
        object = this.doImportMetaData(filterEntryInfo, entryList, result, importTenant);
        toolLogger.info("finish metadata import. {target:{}, result:{}}", (Object)targetName, (Object)(result.isError() ? "failed" : "success"));
        return object;
    }

    @Override
    public MetaDataImportStatus checkStatus(XMLEntryInfo xmlInfo, String importPath) {
        MetaDataEntry importEntry = xmlInfo.getPathEntry(importPath);
        if (importEntry == null) {
            throw new MetaDataPortingRuntimeException(this.getRS("canNotGetMeta", importPath));
        }
        RootMetaData importMetaData = importEntry.getMetaData();
        String importId = importMetaData.getId();
        MetaDataImportStatus status = new MetaDataImportStatus(importId, importPath);
        boolean isTenant = this.isTenantMeta(importPath);
        if (isTenant) {
            Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            if (!tenant.getName().equals(importMetaData.getName())) {
                status.setWarn(true);
                status.setMessage(this.getRS("statusIncludeUnMatchTenant", new Object[0]));
                status.setMessageDetail(this.getRS("statusIncludeUnMatchTenantDetail", new Object[0]));
            } else {
                status.setInfo(true);
                status.setMessage(this.getRS("statusIncludeTenant", new Object[0]));
                status.setMessageDetail(this.getRS("statusIncludeTenantDetail", new Object[0]));
            }
            status.setAction(MetaDataImportStatus.ImportAction.UPDATE);
            return status;
        }
        MetaDataEntry storedIDEntry = null;
        if (StringUtil.isNotEmpty((String)importId)) {
            storedIDEntry = MetaDataContext.getContext().getMetaDataEntryById(importId);
        }
        if (storedIDEntry != null) {
            if (MetaDataEntry.RepositoryType.SHARED == storedIDEntry.getRepositryType() && !storedIDEntry.isOverwritable()) {
                status.setAction(MetaDataImportStatus.ImportAction.ERROR);
                status.setError(true);
                status.setMessage(this.getRS("statusCanNotOverwrite", importId, importPath));
                status.setMessageDetail(this.getRS("statusCanNotOverwriteDetail", importId, importPath));
                return status;
            }
            if (storedIDEntry.getPath().equals(importPath)) {
                status.setAction(MetaDataImportStatus.ImportAction.UPDATE);
                return status;
            }
            if (MetaDataEntry.RepositoryType.SHARED == storedIDEntry.getRepositryType()) {
                status.setAction(MetaDataImportStatus.ImportAction.ERROR);
                status.setError(true);
                status.setMessage(this.getRS("statusCanNotRenameSharedData", importId, storedIDEntry.getPath(), importPath));
                status.setMessageDetail(this.getRS("statusCanNotRenameSharedDataDetail", importId, storedIDEntry.getPath(), importPath));
                return status;
            }
            MetaDataEntry storedRenamePathEntry = MetaDataContext.getContext().getMetaDataEntry(importPath);
            if (storedRenamePathEntry == null) {
                status.setAction(MetaDataImportStatus.ImportAction.RENAME);
                status.setInfo(true);
                status.setMessage(this.getRS("statusRename", importId, storedIDEntry.getPath(), importPath));
                status.setMessageDetail(this.getRS("statusRenameDetail", importId, storedIDEntry.getPath(), importPath));
                return status;
            }
            MetaDataEntry importRenamePathEntry = xmlInfo.getIdEntry(storedRenamePathEntry.getMetaData().getId());
            if (importRenamePathEntry != null) {
                status.setAction(MetaDataImportStatus.ImportAction.RENAMEWITHCOMBI);
                status.setCombiMetaDataId(importRenamePathEntry.getMetaData().getId());
                status.setCombiMetaDataPath(importRenamePathEntry.getPath());
                status.setCombiMetaData(importRenamePathEntry.getMetaData());
                status.setInfo(true);
                status.setMessage(this.getRS("statusRenameWithCombi", importId, storedIDEntry.getPath(), importPath, importRenamePathEntry.getMetaData().getId(), importRenamePathEntry.getPath()));
                status.setMessageDetail(this.getRS("statusRenameWithCombiDetail", importId, storedIDEntry.getPath(), importPath, importRenamePathEntry.getMetaData().getId(), importRenamePathEntry.getPath()));
                return status;
            }
            if (MetaDataEntry.RepositoryType.SHARED == storedRenamePathEntry.getRepositryType() || MetaDataEntry.RepositoryType.SHARED_OVERWRITE == storedRenamePathEntry.getRepositryType()) {
                status.setAction(MetaDataImportStatus.ImportAction.ERROR);
                status.setError(true);
                status.setMessage(this.getRS("statusCanNotRenameWithSharedDelete", importId, storedIDEntry.getPath(), importPath, storedRenamePathEntry.getMetaData().getId()));
                status.setMessageDetail(this.getRS("statusCanNotRenameWithSharedDeleteDetail", importId, storedIDEntry.getPath(), importPath, storedRenamePathEntry.getMetaData().getId()));
                return status;
            }
            status.setAction(MetaDataImportStatus.ImportAction.RENAMEWITHDELETE);
            status.setRemoveMetaDataId(storedRenamePathEntry.getMetaData().getId());
            status.setRemoveMetaDataPath(storedRenamePathEntry.getPath());
            status.setRemoveMetaData(storedRenamePathEntry.getMetaData());
            status.setInfo(true);
            status.setMessage(this.getRS("statusRenameWithDelete", importId, storedIDEntry.getPath(), importPath, storedRenamePathEntry.getMetaData().getId()));
            status.setMessageDetail(this.getRS("statusRenameWithDeleteDetail", importId, storedIDEntry.getPath(), importPath, storedRenamePathEntry.getMetaData().getId()));
            return status;
        }
        MetaDataEntry storedPathEntry = MetaDataContext.getContext().getMetaDataEntry(importPath);
        if (storedPathEntry != null) {
            MetaDataEntry importRenamePathEntry = xmlInfo.getIdEntry(storedPathEntry.getMetaData().getId());
            if (importRenamePathEntry != null) {
                status.setAction(MetaDataImportStatus.ImportAction.INSERTWITHCOMBI);
                status.setCombiMetaDataId(importRenamePathEntry.getMetaData().getId());
                status.setCombiMetaDataPath(importRenamePathEntry.getPath());
                status.setCombiMetaData(importRenamePathEntry.getMetaData());
                status.setInfo(true);
                status.setMessage(this.getRS("statusInsertWithCombi", importId, importPath, importRenamePathEntry.getMetaData().getId(), importRenamePathEntry.getPath()));
                status.setMessageDetail(this.getRS("statusInsertWithCombiDetail", importId, importPath, importRenamePathEntry.getMetaData().getId(), importRenamePathEntry.getPath()));
                return status;
            }
            if (MetaDataEntry.RepositoryType.SHARED == storedPathEntry.getRepositryType() || MetaDataEntry.RepositoryType.SHARED_OVERWRITE == storedPathEntry.getRepositryType()) {
                status.setAction(MetaDataImportStatus.ImportAction.ERROR);
                status.setError(true);
                status.setMessage(this.getRS("statusCanNotInsertWithSharedDelete", importId, importPath, storedPathEntry.getMetaData().getId()));
                status.setMessageDetail(this.getRS("statusCanNotInsertWithSharedDeleteDetail", importId, importPath, storedPathEntry.getMetaData().getId()));
                return status;
            }
            status.setAction(MetaDataImportStatus.ImportAction.INSERTWITHDELETE);
            status.setRemoveMetaDataId(storedPathEntry.getMetaData().getId());
            status.setRemoveMetaDataPath(storedPathEntry.getPath());
            status.setRemoveMetaData(storedPathEntry.getMetaData());
            status.setInfo(true);
            status.setMessage(this.getRS("statusInsertWithDelete", importId, importPath, storedPathEntry.getMetaData().getId()));
            status.setMessageDetail(this.getRS("statusInsertWithDeleteDetail", importId, importPath, storedPathEntry.getMetaData().getId()));
            return status;
        }
        status.setAction(MetaDataImportStatus.ImportAction.INSERT);
        return status;
    }

    @Override
    public boolean isTenantMeta(String importPath) {
        return this.importHandler.isTenantMeta(importPath);
    }

    private String getJAXBExceptionMessage(JAXBException e) {
        String detail = "";
        if (e.getMessage() != null) {
            detail = e.getMessage();
        } else if (e.getCause() != null && e.getCause().getMessage() != null) {
            detail = e.getCause().getMessage();
        }
        return detail;
    }

    private SAXSource toSaxSource(InputStream is) throws JAXBException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        f.setValidating(false);
        f = new SecureSAXParserFactory(f);
        try {
            return new SAXSource(f.newSAXParser().getXMLReader(), new InputSource(is));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private XMLEntryInfo filterSelectedPaths(XMLEntryInfo entryInfo, List<String> selectedPaths) {
        XMLEntryInfo filterInfo = new XMLEntryInfo();
        for (String path : selectedPaths) {
            MetaDataEntry entry = entryInfo.getPathEntry(path);
            if (entry == null) continue;
            filterInfo.putPathEntry(path, entry);
            String id = entry.getMetaData().getId();
            if (StringUtil.isNotEmpty((String)id)) {
                filterInfo.putIdEntry(id, entry);
                continue;
            }
            filterInfo.addIdBlankEntry(entry);
        }
        return filterInfo;
    }

    private MetaDataImportResult doImportMetaData(XMLEntryInfo entryInfo, List<MetaDataEntry> entryList, MetaDataImportResult result, Tenant importTenant) {
        String curPath = null;
        ArrayList<ImportMetaDataInfo> removeList = new ArrayList<ImportMetaDataInfo>();
        HashMap<String, ImportMetaDataInfo> normalList = new HashMap<String, ImportMetaDataInfo>();
        ArrayList<ImportMetaDataInfo> normalCombiList = new ArrayList<ImportMetaDataInfo>();
        HashMap<String, ImportMetaDataInfo> individualList = new HashMap<String, ImportMetaDataInfo>();
        ArrayList<ImportMetaDataInfo> individualCombiList = new ArrayList<ImportMetaDataInfo>();
        ArrayList<String> combiIdList = new ArrayList<String>();
        boolean needTenantReload = false;
        boolean needMetaContextReload = false;
        try {
            for (MetaDataEntry entry : entryList) {
                curPath = entry.getPath();
                RootMetaData metaData = entry.getMetaData();
                MetaDataImportStatus status = this.checkStatus(entryInfo, entry.getPath());
                if (status.isError()) {
                    throw new MetaDataPortingRuntimeException(status.getMessage());
                }
                if (status.isWarn()) {
                    logger.warn(status.getMessage());
                }
                ImportMetaDataInfo info = new ImportMetaDataInfo(curPath, metaData, entry, status);
                if (metaData instanceof MetaEntity) {
                    if (status.hasRemoveMetaData()) {
                        individualList.put(info.status.getImportId(), info);
                    } else if (status.isInsert()) {
                        if (status.hasCombiMetaData()) {
                            individualList.put(info.status.getImportId(), info);
                            combiIdList.add(info.status.getCombiMetaDataId());
                        } else {
                            normalList.put(info.status.getImportId(), info);
                        }
                    } else if (status.isUpdate()) {
                        individualList.put(info.status.getImportId(), info);
                    }
                    needMetaContextReload = true;
                } else {
                    if (status.isInsert() && status.hasCombiMetaData()) {
                        individualList.put(info.status.getImportId(), info);
                        combiIdList.add(info.status.getCombiMetaDataId());
                    } else {
                        normalList.put(info.status.getImportId(), info);
                    }
                    if (metaData instanceof MetaUtilityClass) {
                        needTenantReload = true;
                    } else {
                        needMetaContextReload = metaData instanceof MetaMetaCommand ? true : true;
                    }
                }
                if (!status.hasRemoveMetaData()) continue;
                removeList.add(new ImportMetaDataInfo(status.getRemoveMetaDataPath(), status.getRemoveMetaData()));
            }
            if (!combiIdList.isEmpty()) {
                for (String combiId : combiIdList) {
                    if (normalList.containsKey(combiId)) {
                        normalCombiList.add((ImportMetaDataInfo)normalList.get(combiId));
                        normalList.remove(combiId);
                    }
                    if (!individualList.containsKey(combiId)) continue;
                    individualCombiList.add((ImportMetaDataInfo)individualList.get(combiId));
                    individualList.remove(combiId);
                }
            }
        }
        catch (Exception e) {
            this.errorForImportMetaDataEntry(curPath, e, result);
        }
        if (!result.isError()) {
            this.doImportNormalMetaData(removeList, normalCombiList, new ArrayList<ImportMetaDataInfo>(normalList.values()), importTenant, needTenantReload, needMetaContextReload, result);
        }
        if (!result.isError()) {
            this.doImportIndividualMetaData(individualCombiList, new ArrayList<ImportMetaDataInfo>(individualList.values()), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportNormalMetaData(List<ImportMetaDataInfo> removeList, List<ImportMetaDataInfo> normalCombiList, List<ImportMetaDataInfo> normalList, Tenant importTenant, boolean needTenantReload, boolean needMetaContextReload, MetaDataImportResult result) {
        if (removeList.isEmpty() && normalList.isEmpty()) {
            return;
        }
        Collections.sort(removeList, new ImportMetaDataInfoComparator());
        Collections.sort(normalCombiList, new ImportMetaDataInfoComparator());
        Collections.sort(normalList, new ImportMetaDataInfoComparator());
        MetaDataContextListener listener = new MetaDataContextListener(){

            public void updated(String path, String pathBefore) {
                logger.debug("metadata context updated. path=" + path + " pathBefore=" + pathBefore);
            }

            public void removed(String path) {
                logger.debug("metadata context removed. path=" + path);
            }

            public void created(String path) {
                logger.debug("metadata context created. path=" + path);
            }
        };
        try {
            Transaction.requiresNew(t -> {
                boolean doAutoReload = !needTenantReload && !needMetaContextReload;
                MetaDataContext.getContext().addMetaDataContextListener(listener);
                for (ImportMetaDataInfo info : removeList) {
                    try {
                        this.importHandler.removeMetaData(info.path, info.metaData, doAutoReload);
                        logger.debug("metadata removed. path=" + info.path);
                        result.addMessages(this.getRS("removeMeta", info.path));
                    }
                    catch (Exception e) {
                        this.errorForImportMetaDataEntry(info.path, e, result);
                        return null;
                    }
                }
                for (ImportMetaDataInfo info : normalCombiList) {
                    try {
                        this.doImportNormalMetaData(info, importTenant, doAutoReload, result);
                    }
                    catch (Exception e) {
                        this.errorForImportMetaDataEntry(info.path, e, result);
                        return null;
                    }
                }
                for (ImportMetaDataInfo info : normalList) {
                    try {
                        this.doImportNormalMetaData(info, importTenant, doAutoReload, result);
                    }
                    catch (Exception e) {
                        this.errorForImportMetaDataEntry(info.path, e, result);
                        return null;
                    }
                }
                return null;
            });
            Transaction.requiresNew(t -> {
                if (needTenantReload) {
                    this.tContextService.reloadTenantContext(ExecuteContext.getCurrentContext().getTenantContext().getTenantId(), false);
                    logger.debug("reload tenant context. trigger is metadata import.");
                    result.addMessages(this.getRS("reloadTenantContext", new Object[0]));
                } else if (needMetaContextReload) {
                    MetaDataContext.getContext().clearAllCache();
                    logger.debug("clear metadata context. trigger is metadata import.");
                    result.addMessages(this.getRS("clearAllMetaDataContext", new Object[0]));
                } else {
                    logger.debug("update metadata context only target. trigger is metadata import.");
                    result.addMessages(this.getRS("updateMetaDataContext", new Object[0]));
                }
            });
        }
        finally {
            MetaDataContext.getContext().removeMetaDataContextListener(listener);
        }
    }

    private void doImportNormalMetaData(ImportMetaDataInfo info, Tenant importTenant, boolean doAutoReload, MetaDataImportResult result) {
        if (info.metaData instanceof MetaTenant) {
            Tenant currentTenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            String tenantPath = new MetaTenantService.TypeMap().toPath(currentTenant.getName());
            if (importTenant == null) {
                logger.debug("Tenant metadata skipped import.");
                result.addMessages(this.getRS("tenantImportSkip", tenantPath));
            } else {
                MetaTenant updateMetaTenant = new MetaTenant(importTenant);
                MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(currentTenant.getName());
                updateMetaTenant.setId(handler.getMetaData().getId());
                updateMetaTenant.setName(handler.getMetaData().getName());
                this.importHandler.updateMetaData(tenantPath, (RootMetaData)updateMetaTenant, info.entry, doAutoReload);
                logger.debug("metadata updated. path=" + tenantPath);
                result.addMessages(this.getRS("tenantImport", tenantPath));
            }
        } else if (info.status.isInsert()) {
            this.importHandler.storeMetaData(info.path, info.metaData, info.entry, doAutoReload);
            logger.debug("metadata stored. path=" + info.path);
            result.addMessages(this.getRS("insertMeta", info.path));
        } else if (info.status.isUpdate()) {
            this.importHandler.updateMetaData(info.path, info.metaData, info.entry, doAutoReload);
            logger.debug("metadata updated. path=" + info.path);
            result.addMessages(this.getRS("updateMeta", info.path));
        }
    }

    private void doImportIndividualMetaData(List<ImportMetaDataInfo> individualCombiList, List<ImportMetaDataInfo> individualList, MetaDataImportResult result) {
        if (individualList.isEmpty()) {
            return;
        }
        Collections.sort(individualList, new ImportMetaDataInfoComparator());
        Transaction.requiresNew(t -> {
            ExecuteContext current = ExecuteContext.getCurrentContext();
            TenantContext tenantContext = this.tContextService.getTenantContext(ExecuteContext.getCurrentContext().getCurrentTenant().getId());
            ExecuteContext.executeAs((TenantContext)tenantContext, () -> {
                ExecuteContext.getCurrentContext().setLanguage(current.getLanguage());
                boolean doAutoReload = true;
                for (ImportMetaDataInfo info : individualCombiList) {
                    try {
                        this.doImportIndividualMetaData(info, doAutoReload, result);
                    }
                    catch (Exception e) {
                        this.errorForImportMetaDataEntry(info.path, e, result);
                        return null;
                    }
                }
                for (ImportMetaDataInfo info : individualList) {
                    try {
                        this.doImportIndividualMetaData(info, doAutoReload, result);
                    }
                    catch (Exception e) {
                        this.errorForImportMetaDataEntry(info.path, e, result);
                        return null;
                    }
                }
                return null;
            });
            return null;
        });
    }

    private void doImportIndividualMetaData(ImportMetaDataInfo info, boolean doAutoReload, MetaDataImportResult result) {
        if (info.status.isInsert()) {
            this.importHandler.storeMetaData(info.path, info.metaData, info.entry, doAutoReload);
            logger.debug("metadata stored. path=" + info.path);
            result.addMessages(this.getRS("insertMeta", info.path));
        } else if (info.status.isUpdate()) {
            this.importHandler.updateMetaData(info.path, info.metaData, info.entry, doAutoReload);
            logger.debug("metadata updated. path=" + info.path);
            result.addMessages(this.getRS("updateMeta", info.path));
        }
    }

    private void errorForImportMetaDataEntry(String path, Exception e, MetaDataImportResult result) {
        TransactionManager tm = (TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class);
        Transaction t = tm.currentTransaction();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE && !t.isRollbackOnly()) {
            logger.debug("set transaction rollback.");
            t.setRollbackOnly();
        }
        logger.error("meta data import failed. target path=" + path, (Throwable)e);
        result.setError(true);
        List<String> msgStack = result.getMessages();
        result.clearMessages();
        result.addMessages(this.getRS("errorImportMetaData", path));
        result.addMessages(this.getRS("causeTitle", e.getMessage()));
        if (msgStack != null) {
            result.addMessages(this.getRS("logTitle", new Object[0]));
            result.addMessages("-----------------------------------------");
            result.addMessages(msgStack);
            result.addMessages("-----------------------------------------");
        }
    }

    private void writeHeader(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        writer.println("<metaDataList>");
    }

    private void writeFooter(PrintWriter writer) {
        writer.println("</metaDataList>");
    }

    private void writeMetaDataEntry(PrintWriter writer, Marshaller marshaller, MetaDataEntry entry) throws JAXBException {
        XmlResourceMetaDataEntryThinWrapper meta = new XmlResourceMetaDataEntryThinWrapper(entry.getMetaData());
        meta.setOverwritable(entry.isOverwritable());
        meta.setSharable(entry.isSharable());
        meta.setDataSharable(entry.isDataSharable());
        meta.setPermissionSharable(entry.isPermissionSharable());
        marshaller.marshal((Object)meta, (Writer)writer);
        writer.println();
    }

    private String getContextPath(String path, String name) {
        String checkName = name.replace(".", "/");
        String contextPath = null;
        contextPath = path.endsWith(checkName) ? path.substring(0, path.length() - checkName.length() - 1) : (path.endsWith(name) ? path.substring(0, path.length() - name.length() - 1) : path);
        return contextPath;
    }

    private XMLEntryInfo parse(MetaDataEntryList metaList) {
        XMLEntryInfo entryInfo = new XMLEntryInfo();
        if (metaList.getContextPath() != null) {
            for (ContextPath context : metaList.getContextPath()) {
                this.parseContextPath(entryInfo, context, "", context.getName());
            }
        }
        return entryInfo;
    }

    private void parseContextPath(XMLEntryInfo entryInfo, ContextPath context, String prefixPath, String rootPath) {
        if (context.getContextPath() != null) {
            for (ContextPath child : context.getContextPath()) {
                this.parseContextPath(entryInfo, child, prefixPath + context.getName() + "/", rootPath);
            }
        }
        if (context.getEntry() != null) {
            for (XmlResourceMetaDataEntryThinWrapper xmlEntry : context.getEntry()) {
                String path;
                if (xmlEntry.getMetaData() == null) {
                    path = xmlEntry.getName();
                    if (path == null) {
                        path = prefixPath + context.getName() + "/null(unknown)";
                    }
                    logger.warn(path + "'s Entry is null, maybe Old(No longer available) MetaData Type specified.");
                    continue;
                }
                path = xmlEntry.getName();
                if (path == null) {
                    path = this.convertPath(prefixPath + context.getName() + "/" + xmlEntry.getMetaData().getName());
                }
                MetaDataEntry entry = new MetaDataEntry(path, xmlEntry.getMetaData(), MetaDataEntry.State.VALID, 0, xmlEntry.isOverwritable(), xmlEntry.isSharable(), xmlEntry.isDataSharable(), xmlEntry.isPermissionSharable());
                entryInfo.putPathEntry(path, entry);
                if (StringUtil.isEmpty((String)entry.getMetaData().getId())) {
                    entryInfo.addIdBlankEntry(entry);
                    continue;
                }
                entryInfo.putIdEntry(entry.getMetaData().getId(), entry);
            }
        }
    }

    private String convertPath(String path) {
        if (path.startsWith("/entity/") || path.startsWith("/view/generic/") || path.startsWith("/view/filter/") || path.startsWith("/entityWebapi/") || path.startsWith("/utilityClass/")) {
            return path.replace(".", "/");
        }
        return path;
    }

    private String getRS(String suffix, Object ... arguments) {
        return ToolsResourceBundleUtil.resourceString("metaport." + suffix, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void patchEntityData(PatchEntityDataParameter param) {
        ConfigImpl newConfig = new ConfigImpl("forPatchNew", new NameValue[]{new NameValue("filePath", param.getNewMetaDataFilePath())}, null);
        newConfig.addDependentService(MetaDataJAXBService.class.getName(), (Service)this.jaxbService);
        XmlResourceMetaDataStore newRepo = new XmlResourceMetaDataStore();
        newRepo.inited(null, (Config)newConfig);
        ConfigImpl oldConfig = new ConfigImpl("forPatchOld", new NameValue[]{new NameValue("filePath", param.getOldMetaDataFilePath())}, null);
        oldConfig.addDependentService(MetaDataJAXBService.class.getName(), (Service)this.jaxbService);
        XmlResourceMetaDataStore oldRepo = new XmlResourceMetaDataStore();
        oldRepo.inited(null, (Config)oldConfig);
        Transaction t = ((TransactionManager)ManagerLocator.getInstance().getManager(TransactionManager.class)).newTransaction();
        try {
            List entityList = newRepo.definitionList(param.getTenantId(), "/entity");
            if (entityList != null) {
                entityList.forEach(entry -> {
                    MetaEntity newMetaEntity = (MetaEntity)newRepo.load(param.getTenantId(), entry.getPath()).getMetaData();
                    MetaEntity oldMetaEntity = (MetaEntity)oldRepo.load(param.getTenantId(), entry.getPath()).getMetaData();
                    if (oldMetaEntity != null) {
                        StoreService storeService = (StoreService)ServiceRegistry.getRegistry().getService(StoreService.class);
                        DataStore srds = storeService.getDataStore();
                        EntityContext ec = EntityContext.getCurrentContext();
                        srds.getApplyMetaDataStrategy().patchData(newMetaEntity, oldMetaEntity, ec, EntityContext.getCurrentContext().getLocalTenantId());
                    }
                });
            }
        }
        catch (Exception e) {
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.rollback();
                throw e;
            }
        }
        finally {
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.commit();
            }
        }
    }

    @Override
    public void patchEntityDataWithPrivilegedAuth(PatchEntityDataParameter param) {
        this.authService.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), () -> {
            this.patchEntityData(param);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void patchEntityDataWithUserAuth(PatchEntityDataParameter param, String userId, String password) {
        try {
            this.authService.login((Credential)(StringUtil.isNotEmpty((String)password) ? new IdPasswordCredential(userId, password) : new InternalCredential(userId)));
            this.authService.doSecuredAction(AuthContextHolder.getAuthContext(), () -> {
                this.patchEntityData(param);
                return null;
            });
        }
        finally {
            this.authService.logout();
        }
    }

    private class ImportMetaDataInfoComparator
    implements Comparator<ImportMetaDataInfo> {
        private ImportMetaDataInfoComparator() {
        }

        @Override
        public int compare(ImportMetaDataInfo o1, ImportMetaDataInfo o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.path.compareTo(o2.path);
        }
    }

    private class ImportMetaDataInfo {
        String path;
        RootMetaData metaData;
        MetaDataEntry entry;
        MetaDataImportStatus status;

        public ImportMetaDataInfo(String path, RootMetaData metaData) {
            this.path = path;
            this.metaData = metaData;
        }

        public ImportMetaDataInfo(String path, RootMetaData metaData, MetaDataEntry entry, MetaDataImportStatus status) {
            this.path = path;
            this.metaData = metaData;
            this.entry = entry;
            this.status = status;
        }
    }
}

