/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.pack;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.entityport.EntityDataExportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.entityport.EntityPortingService;
import org.iplass.mtp.impl.tools.metaport.MetaDataImportResult;
import org.iplass.mtp.impl.tools.metaport.MetaDataPortingService;
import org.iplass.mtp.impl.tools.metaport.MetaDataWriteCallback;
import org.iplass.mtp.impl.tools.metaport.XMLEntryInfo;
import org.iplass.mtp.impl.tools.pack.PackageCreateCondition;
import org.iplass.mtp.impl.tools.pack.PackageCreateResult;
import org.iplass.mtp.impl.tools.pack.PackageInfo;
import org.iplass.mtp.impl.tools.pack.PackageRuntimeException;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(PackageService.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"mtp.audit.porting.pack");
    private static Logger toolLogger = LoggerFactory.getLogger((String)"mtp.tools.packaging");
    private static final String PACKAGE_FILE_TYPE = "application/zip";
    private static final String META_DATA_FILE_NAME = "metadata.xml";
    private List<String> nonSupportEntityPathList;
    private MetaDataPortingService metaService;
    private EntityPortingService entityService;
    private AsyncTaskService asyncService;
    private EntityManager em;

    public void init(Config config) {
        this.metaService = (MetaDataPortingService)config.getDependentService(MetaDataPortingService.class);
        this.entityService = (EntityPortingService)config.getDependentService(EntityPortingService.class);
        this.asyncService = (AsyncTaskService)config.getDependentService(AsyncTaskService.class);
        this.em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        this.nonSupportEntityPathList = Arrays.asList("/entity/mtp/maintenance/Package");
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInfo getPackageInfo(String packOid) {
        File archive = null;
        try {
            Entity packEntity = this.loadWithCheckExist(packOid);
            archive = this.getPackageArchiveFile(packEntity);
            PackageInfo info = this.getPackageInfo(archive);
            info.setPackageName(packEntity.getName());
            PackageInfo packageInfo = info;
            return packageInfo;
        }
        finally {
            if (archive != null && !archive.delete()) {
                logger.warn("Fail to delete temporary resource:" + archive.getPath());
            }
        }
    }

    public PackageInfo getPackageInfo(File archive) {
        PackageInfo info = new PackageInfo();
        try (ZipFile zip = new ZipFile(archive);){
            zip.stream().filter(entry -> !entry.isDirectory()).forEach(entry -> {
                block18: {
                    try {
                        if (!this.checkSum(zip, (ZipEntry)entry)) {
                            throw new PackageRuntimeException(this.rs("pack.fileCorrupted", entry.getName()));
                        }
                        if (META_DATA_FILE_NAME.equals(entry.getName())) {
                            try (InputStream is = zip.getInputStream((ZipEntry)entry);){
                                PackageMetaDataInfo metaDataInfo = this.getMetaDataList(is);
                                info.setMetaDataPaths(metaDataInfo.entryList);
                                info.setTenant(metaDataInfo.tenant);
                                info.setWarningTenant(metaDataInfo.warningTenant);
                                break block18;
                            }
                        }
                        if (entry.getName().startsWith("lobs/")) {
                            info.setHasLobData(true);
                            break block18;
                        }
                        if (entry.getName().endsWith("csv")) {
                            info.addEntityPaths(entry.getName());
                            break block18;
                        }
                        throw new PackageRuntimeException(this.rs("pack.canNotParse", entry.getName()));
                    }
                    catch (IOException e) {
                        throw new PackageRuntimeException(this.rs("pack.canNotParseCorrupted", new Object[0]), e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new PackageRuntimeException(this.rs("pack.canNotParseCorrupted", new Object[0]), e);
        }
        if (info.getEntityPaths() != null) {
            info.getEntityPaths().sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getMetaDataInputStream(File archive) {
        try (ZipFile zip = new ZipFile(archive);){
            Optional<ZipEntry> meta = zip.stream().filter(entry -> !entry.isDirectory()).filter(entry -> META_DATA_FILE_NAME.equals(entry.getName())).findFirst();
            if (!meta.isPresent()) return null;
            if (!this.checkSum(zip, meta.get())) {
                throw new PackageRuntimeException(this.rs("pack.fileCorrupted", meta.get().getName()));
            }
            InputStream inputStream = zip.getInputStream(meta.get());
            return inputStream;
        }
        catch (IOException e) {
            throw new PackageRuntimeException(this.rs("pack.canNotParseCorrupted", new Object[0]), e);
        }
    }

    private boolean checkSum(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        long expected = zipEntry.getCrc();
        if (expected == -1L) {
            return true;
        }
        try (CheckedInputStream is = new CheckedInputStream(zipFile.getInputStream(zipEntry), new CRC32());){
            byte[] buf = new byte[1024];
            while (is.read(buf) >= 0) {
            }
            if (is.getChecksum().getValue() == expected) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private PackageMetaDataInfo getMetaDataList(InputStream is) {
        XMLEntryInfo entryInfo = this.metaService.getXMLMetaDataEntryInfo(is);
        ArrayList<String> entryPathList = new ArrayList<String>(entryInfo.getPathEntryMap().keySet());
        entryPathList.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        Tenant tenant = null;
        boolean warningTenant = false;
        for (Map.Entry<String, MetaDataEntry> entry : entryInfo.getPathEntryMap().entrySet()) {
            if (!this.metaService.isTenantMeta(entry.getKey())) continue;
            MetaTenant importMetaTenant = (MetaTenant)entry.getValue().getMetaData();
            tenant = new Tenant();
            importMetaTenant.applyToTenant(tenant);
            tenant.setId(-1);
            tenant.setName(importMetaTenant.getName());
            tenant.setDescription(importMetaTenant.getDescription());
            Tenant currentTenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            if (currentTenant.getName().equals(importMetaTenant.getName())) continue;
            warningTenant = true;
        }
        PackageMetaDataInfo result = new PackageMetaDataInfo();
        result.entryList = entryPathList;
        result.tenant = tenant;
        result.warningTenant = warningTenant;
        return result;
    }

    public String uploadPackage(String name, String description, File archive) {
        return this.uploadPackage(name, description, archive, "20");
    }

    public String uploadPackage(String name, String description, File archive, String type) {
        GenericEntity entity = new GenericEntity("mtp.maintenance.Package");
        entity.setName(name);
        entity.setDescription(description);
        entity.setValue("type", (Object)new SelectValue(type));
        entity.setValue("status", (Object)new SelectValue("20"));
        entity.setValue("taskCount", (Object)1);
        entity.setValue("completeTaskCount", (Object)1);
        Timestamp timestamp = ExecuteContext.getCurrentContext().getCurrentTimestamp();
        entity.setValue("execStartDate", (Object)timestamp);
        entity.setValue("execEndDate", (Object)timestamp);
        BinaryReference br = this.toBinaryReference(name, archive);
        entity.setValue("archive", (Object)br);
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        String oid = em.insert((Entity)entity);
        return oid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BinaryReference toBinaryReference(String name, File file) {
        try (FileInputStream is = new FileInputStream(file);){
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            BinaryReference binaryReference = em.createBinaryReference(name, PACKAGE_FILE_TYPE, (InputStream)is);
            return binaryReference;
        }
        catch (IOException e) {
            throw new SystemException("not found import file.", (Throwable)e);
        }
    }

    public String storePackage(PackageCreateCondition condition) {
        return this.storePackage(condition, "10");
    }

    public String storePackage(PackageCreateCondition condition, String type) {
        GenericEntity entity = new GenericEntity("mtp.maintenance.Package");
        entity.setName(condition.getName());
        entity.setDescription(condition.getDescription());
        entity.setValue("type", (Object)new SelectValue(type));
        entity.setValue("status", (Object)new SelectValue("00"));
        entity.setValue("createSetting", (Object)this.toBinaryReference(condition));
        int taskCount = 0;
        if (condition.getMetaDataPaths() != null && !condition.getMetaDataPaths().isEmpty()) {
            ++taskCount;
        }
        if (condition.getEntityPaths() != null && !condition.getEntityPaths().isEmpty()) {
            taskCount += condition.getEntityPaths().size();
        }
        entity.setValue("taskCount", (Object)(++taskCount));
        entity.setValue("completeTaskCount", (Object)0);
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        String oid = em.insert((Entity)entity);
        return oid;
    }

    public PackageCreateResult archivePackage(String packOid) {
        Entity entity = this.em.load(packOid, "mtp.maintenance.Package");
        if (entity == null) {
            throw new PackageRuntimeException("not found package setting. id=" + packOid);
        }
        BinaryReference settingRef = (BinaryReference)entity.getValue("createSetting");
        PackageCreateCondition condition = this.toCreatePackageCondition(settingRef);
        if (condition == null) {
            throw new PackageRuntimeException("failed to read package setting. id=" + packOid);
        }
        return this.doArchive(entity, condition);
    }

    public void archivePackageAsync(String packOid) {
        Entity entity = this.em.load(packOid, "mtp.maintenance.Package");
        if (entity == null) {
            throw new PackageRuntimeException("not found package setting. id=" + packOid);
        }
        BinaryReference settingRef = (BinaryReference)entity.getValue("createSetting");
        PackageCreateCondition condition = this.toCreatePackageCondition(settingRef);
        if (condition == null) {
            throw new PackageRuntimeException("failed to read package setting. id=" + packOid);
        }
        this.asyncService.execute(() -> (PackageCreateResult)Transaction.required(transaction -> this.doArchive(entity, condition)));
    }

    public List<String> getNonSupportEntityPathList() {
        return this.nonSupportEntityPathList;
    }

    public void write(OutputStream os, PackageCreateCondition condition) {
        this.write(os, condition, new PackageCreateResult(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os, PackageCreateCondition condition, final PackageCreateResult result, final Entity packEntity) {
        block59: {
            try (ZipOutputStream zos = new ZipOutputStream(os, StandardCharsets.UTF_8);){
                if (packEntity != null) {
                    Transaction.requiresNew(transaction -> {
                        packEntity.setValue("status", (Object)new SelectValue("10"));
                        packEntity.setValue("execStartDate", (Object)ExecuteContext.getCurrentContext().getCurrentTimestamp());
                        UpdateOption option = new UpdateOption(false);
                        option.setUpdateProperties(new String[]{"status", "execStartDate"});
                        this.em.update(packEntity, option);
                        return null;
                    });
                }
                if (condition.getMetaDataPaths() != null && !condition.getMetaDataPaths().isEmpty()) {
                    logger.debug("pack metadata path count : " + condition.getMetaDataPaths().size());
                    result.addMessages(this.rs("pack.startExportMetaData", new Object[0]));
                    File metadataFile = File.createTempFile("tmp", ".tmp");
                    try {
                        try (PrintWriter writer = new PrintWriter(metadataFile, "UTF-8");){
                            this.metaService.write(writer, condition.getMetaDataPaths(), new MetaDataWriteCallback(){

                                @Override
                                public void onWrited(String path, String version) {
                                    result.addMessages(PackageService.this.rs("pack.outputMetaData", new Object[]{path}));
                                    auditLogger.info("create package metadata,metadata.xml,path:" + path + " packageOid:" + (packEntity != null ? packEntity.getOid() : "direct"));
                                }

                                @Override
                                public boolean onWarning(String path, String message, String version) {
                                    result.addMessages(PackageService.this.rs("pack.warningOutputMetaData", new Object[]{path}));
                                    result.addMessages(message);
                                    return true;
                                }

                                @Override
                                public void onStarted() {
                                }

                                @Override
                                public void onFinished() {
                                }

                                @Override
                                public boolean onErrored(String path, String message, String version) {
                                    result.addMessages(PackageService.this.rs("pack.errorOutputMetaData", new Object[]{path}));
                                    result.addMessages(message);
                                    return false;
                                }
                            });
                        }
                        this.addZipEntry(zos, metadataFile, META_DATA_FILE_NAME);
                        if (!metadataFile.delete()) {
                            logger.warn("Fail to delete temporary resource:" + metadataFile.getPath());
                        }
                        metadataFile = null;
                        if (packEntity != null) {
                            Transaction.requiresNew(transaction -> {
                                long curCompleteCount = (Long)packEntity.getValueAs(Long.class, "completeTaskCount");
                                packEntity.setValue("completeTaskCount", (Object)(curCompleteCount + 1L));
                                UpdateOption option = new UpdateOption(false);
                                option.setUpdateProperties(new String[]{"completeTaskCount"});
                                this.em.update(packEntity, option);
                                return null;
                            });
                        }
                        result.addMessages(this.rs("pack.completedExportMetaData", new Object[0]));
                    }
                    finally {
                        if (metadataFile != null) {
                            if (!metadataFile.delete()) {
                                logger.warn("Fail to delete temporary resource:" + metadataFile.getPath());
                            }
                            metadataFile = null;
                        }
                    }
                }
                result.addMessages(this.rs("pack.nonTargetMetaData", new Object[0]));
                logger.debug("pack metadata path count : 0");
                if (condition.getEntityPaths() != null && !condition.getEntityPaths().isEmpty()) {
                    logger.debug("pack entity path count : " + condition.getEntityPaths().size());
                    Map<Object, Object> entityConditions = condition.getEntityConditions() != null ? condition.getEntityConditions() : Collections.emptyMap();
                    result.addMessages(this.rs("pack.startExportEntity", new Object[0]));
                    for (String path : condition.getEntityPaths()) {
                        if (this.nonSupportEntityPathList.contains(path)) {
                            result.addMessages(this.rs("pack.skipNonSupportEntity", path));
                            logger.warn("warning entity data write proccess. path = " + path + ". message = not support entity.");
                            continue;
                        }
                        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(path);
                        if (entry == null) {
                            result.addMessages(this.rs("pack.skipExportEntity", path));
                            logger.warn("warning entity data write proccess. path = " + path + ". message = not found metadata configure.");
                            continue;
                        }
                        String fileName = entry.getMetaData().getName() + ".csv";
                        auditLogger.info("create package entity," + fileName + ",entityName:" + entry.getMetaData().getName() + " packageOid:" + (packEntity != null ? packEntity.getOid() : "direct"));
                        EntityDataExportCondition entityCond = entityConditions.getOrDefault(entry.getMetaData().getName(), new EntityDataExportCondition());
                        long count = 0L;
                        File entityCsvFile = File.createTempFile("tmp", ".tmp");
                        try {
                            try (FileOutputStream csvOS = new FileOutputStream(entityCsvFile);){
                                count = this.entityService.writeWithBinary(csvOS, entry, entityCond, zos);
                            }
                            this.addZipEntry(zos, entityCsvFile, fileName);
                            if (!entityCsvFile.delete()) {
                                logger.warn("Fail to delete temporary resource:" + entityCsvFile.getPath());
                            }
                            entityCsvFile = null;
                            if (packEntity != null) {
                                Transaction.requiresNew(transaction -> {
                                    long curCompleteCount = (Long)packEntity.getValueAs(Long.class, "completeTaskCount");
                                    packEntity.setValue("completeTaskCount", (Object)(curCompleteCount + 1L));
                                    UpdateOption option = new UpdateOption(false);
                                    option.setUpdateProperties(new String[]{"completeTaskCount"});
                                    this.em.update(packEntity, option);
                                    return null;
                                });
                            }
                            result.addMessages(this.rs("pack.outputEntity", entry.getMetaData().getName(), count));
                        }
                        finally {
                            if (entityCsvFile == null) continue;
                            if (!entityCsvFile.delete()) {
                                logger.warn("Fail to delete temporary resource:" + entityCsvFile.getPath());
                            }
                            entityCsvFile = null;
                        }
                    }
                    result.addMessages(this.rs("pack.completedExportEntity", new Object[0]));
                    break block59;
                }
                result.addMessages(this.rs("pack.nonTargetEntity", new Object[0]));
                logger.debug("pack entity path count : 0");
            }
            catch (Exception e) {
                throw new PackageRuntimeException(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private BinaryReference toBinaryReference(PackageCreateCondition condition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private PackageCreateCondition toCreatePackageCondition(BinaryReference binary) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PackageCreateResult doArchive(Entity packEntity, PackageCreateCondition condition) {
        PackageCreateResult result = new PackageCreateResult();
        try {
            logger.info("start packaging " + condition.getName());
            String zipName = condition.getName() + ".zip";
            BinaryReference zipBin = this.createZipBinaryReference(zipName);
            try (OutputStream binos = this.getZipBinaryOutputStream(zipBin);){
                this.write(binos, condition, result, packEntity);
            }
            packEntity.setValue("archive", (Object)zipBin);
            long curCompleteCount = (Long)packEntity.getValueAs(Long.class, "completeTaskCount");
            packEntity.setValue("completeTaskCount", (Object)(curCompleteCount + 1L));
            packEntity.setValue("status", (Object)new SelectValue("20"));
            packEntity.setValue("execEndDate", (Object)ExecuteContext.getCurrentContext().getCurrentTimestamp());
            UpdateOption option = new UpdateOption(false);
            option.setUpdateProperties(new String[]{"archive", "completeTaskCount", "status", "execEndDate"});
            this.em.update(packEntity, option);
            result.addMessages(this.rs("pack.completedCreatePackage", zipName));
            logger.info("complete packaging " + condition.getName());
        }
        catch (Exception e) {
            logger.error("error packaging " + condition.getName(), (Throwable)e);
            Transaction.requiresNew(transaction -> {
                packEntity.setValue("status", (Object)new SelectValue("90"));
                packEntity.setValue("execEndDate", (Object)ExecuteContext.getCurrentContext().getCurrentTimestamp());
                UpdateOption option = new UpdateOption(false);
                option.setUpdateProperties(new String[]{"status", "execEndDate"});
                this.em.update(packEntity, option);
                return null;
            });
            result.setError(true);
            result.addMessages(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
        }
        return result;
    }

    private BinaryReference createZipBinaryReference(String name) {
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        return em.createBinaryReference(name, PACKAGE_FILE_TYPE, null);
    }

    private OutputStream getZipBinaryOutputStream(BinaryReference bin) {
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        return em.getOutputStream(bin);
    }

    private void addZipEntry(ZipOutputStream zos, File file, String entryName) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zos.putNextEntry(zentry);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)bis).read(buf)) >= 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
        }
    }

    public SearchResult<Entity> getPackageList() {
        Query q = new Query().selectAll("mtp.maintenance.Package", false, true).from("mtp.maintenance.Package").order(new SortSpec[]{new SortSpec("createDate", SortSpec.SortType.DESC), new SortSpec("oid", SortSpec.SortType.DESC)});
        return this.em.searchEntity(q);
    }

    private Entity load(String packOid) {
        return this.em.load(packOid, "mtp.maintenance.Package");
    }

    public void deletePackage(List<String> packOids) {
        for (String oid : packOids) {
            Entity entity = this.load(oid);
            if (entity == null) continue;
            DeleteOption option = new DeleteOption(false);
            option.setPurge(true);
            this.em.delete(entity, option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataImportResult importPackageMetaData(String packOid, Tenant importTenant) {
        Entity packEntity = null;
        try {
            packEntity = this.loadWithCheckExist(packOid);
        }
        catch (PackageRuntimeException e) {
            toolLogger.info("start package metadata import. {target:{}}", (Object)packOid);
            toolLogger.info("finish package metadata import. {target:{}, result:{}}", (Object)packOid, (Object)"failed");
            throw e;
        }
        File archive = null;
        try {
            archive = this.getPackageArchiveFile(packEntity);
            MetaDataImportResult metaDataImportResult = this.importPackageMetaData(archive, packEntity.getName(), importTenant);
            return metaDataImportResult;
        }
        finally {
            if (archive != null && !archive.delete()) {
                logger.warn("Fail to delete temporary resource:" + archive.getPath());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public MetaDataImportResult importPackageMetaData(File archive, String packName, Tenant importTenant) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDataImportResult importPackageEntityData(String packOid, String path, EntityDataImportCondition condition) {
        Entity packEntity = null;
        try {
            packEntity = this.loadWithCheckExist(packOid);
        }
        catch (PackageRuntimeException e) {
            toolLogger.info("start package entity import. {target:{}, entity:{}}", (Object)packOid, (Object)path);
            toolLogger.info("finish package entity import. {target:{}, entity:{}, result:{}}", new Object[]{packOid, path, "failed"});
            throw e;
        }
        File archive = null;
        try {
            archive = this.getPackageArchiveFile(packEntity);
            EntityDataImportResult entityDataImportResult = this.importPackageEntityData(archive, packEntity.getName(), path, condition);
            return entityDataImportResult;
        }
        finally {
            if (archive != null && !archive.delete()) {
                logger.warn("Fail to delete temporary resource:" + archive.getPath());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public EntityDataImportResult importPackageEntityData(File archive, String packName, String path, EntityDataImportCondition condition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Entity loadWithCheckExist(String packOid) {
        Entity entity = this.load(packOid);
        if (entity == null) {
            throw new PackageRuntimeException("not found package . id=" + packOid);
        }
        return entity;
    }

    private File getPackageArchiveFile(Entity packEntity) {
        BinaryReference archiveRef = (BinaryReference)packEntity.getValue("archive");
        if (archiveRef == null) {
            throw new PackageRuntimeException("not found package archive info. id=" + packEntity.getOid());
        }
        try {
            File archive = File.createTempFile("tmp", ".tmp");
            try (FileOutputStream fos = new FileOutputStream(archive);
                 InputStream is = this.em.getInputStream(archiveRef);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
            return archive;
        }
        catch (IOException e) {
            throw new PackageRuntimeException("Fail to prepare to read package archive info. id=" + packEntity.getOid(), e);
        }
    }

    private String rs(String key, Object ... arguments) {
        return ToolsResourceBundleUtil.resourceString(key, arguments);
    }

    private static class PackageMetaDataInfo {
        private List<String> entryList;
        private Tenant tenant;
        private boolean warningTenant;

        private PackageMetaDataInfo() {
        }
    }
}

