/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.storagespace;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.EntityDefinitionModifyResult;
import org.iplass.mtp.entity.definition.stores.SchemalessRdbStore;
import org.iplass.mtp.impl.datastore.RdbDataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.entityport.EntityDataExportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportCondition;
import org.iplass.mtp.impl.tools.entityport.EntityDataImportResult;
import org.iplass.mtp.impl.tools.entityport.EntityPortingService;
import org.iplass.mtp.impl.tools.storagespace.StorageSpaceRuntimeException;
import org.iplass.mtp.impl.tools.storagespace.StorageSpaceService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;

public class StorageSpaceServiceImpl
implements StorageSpaceService {
    private static final String TBL_OBJ_STORE = "obj_store";
    private static final String TBL_OBJ_STORE_RB = "obj_store_rb";
    private static final String COL_TENANT_ID = "tenant_id";
    private static final String COL_OBJ_DEF_ID = "obj_def_id";
    private static final String COL_OBJ_ID = "obj_id";
    private static final String[] CLEANUP_TABLES = new String[]{"obj_index_date", "obj_index_dbl", "obj_index_num", "obj_index_str", "obj_index_ts", "obj_ref", "obj_ref_rb", "obj_store", "obj_store_rb", "obj_unique_date", "obj_unique_dbl", "obj_unique_num", "obj_unique_str", "obj_unique_ts"};
    private static final String[] INDEX_TABLES = new String[]{"obj_index_date", "obj_index_dbl", "obj_index_num", "obj_index_str", "obj_index_ts"};
    private static final String[] UNIQUE_TABLES = new String[]{"obj_unique_date", "obj_unique_dbl", "obj_unique_num", "obj_unique_str", "obj_unique_ts"};
    private StoreService storeService;
    private RdbAdapterService rdbAdapterService;
    private EntityPortingService entityPortingService;
    private EntityDefinitionManager edm;
    private int migrateCommitLimit = -1;
    private int cleanupCommitLimit = -1;

    public void init(Config config) {
        this.storeService = (StoreService)config.getDependentService(StoreService.class);
        this.rdbAdapterService = (RdbAdapterService)config.getDependentService(RdbAdapterService.class);
        this.entityPortingService = (EntityPortingService)config.getDependentService(EntityPortingService.class);
        if (config.getValue("migrateCommitLimit") != null) {
            this.migrateCommitLimit = Integer.parseInt(config.getValue("migrateCommitLimit"));
        }
        if (config.getValue("cleanupCommitLimit") != null) {
            this.cleanupCommitLimit = Integer.parseInt(config.getValue("cleanupCommitLimit"));
        }
        this.edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    }

    public void destroy() {
    }

    @Override
    public void migrate(String storageSpaceName, EntityDefinition entityDefinition) {
        boolean existStorageSpace = false;
        for (String storageSpace : ((RdbDataStore)this.storeService.getDataStore()).getStorageSpaceList()) {
            if (!storageSpace.equals(storageSpaceName)) continue;
            existStorageSpace = true;
            break;
        }
        if (!existStorageSpace) {
            throw new IllegalArgumentException(this.getRS("noStorageSpace", storageSpaceName));
        }
        String currentStorageSpaceName = ((SchemalessRdbStore)this.edm.get(entityDefinition.getName()).getStoreDefinition()).getStorageSpace();
        if (storageSpaceName.equals(currentStorageSpaceName)) {
            throw new IllegalArgumentException(this.getRS("sameStorageSpace", storageSpaceName));
        }
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry("/entity/" + entityDefinition.getName().replace(".", "/"));
        File tempFile = null;
        try {
            tempFile = Files.createTempFile("mtp", ".csv", new FileAttribute[0]).toFile();
            this.exportCSV(tempFile, entry);
            if (!this.changeStorageSpace(this.edm.get(entityDefinition.getName()), storageSpaceName)) {
                throw new StorageSpaceRuntimeException(this.getRS("failedChangeStorageSpace", new Object[0]));
            }
            if (!this.importCSV(tempFile, entityDefinition.getName(), entry)) {
                throw new StorageSpaceRuntimeException(this.getRS("failedImportEntityCSVData", new Object[0]));
            }
        }
        catch (IOException e) {
            throw new StorageSpaceRuntimeException(this.getRS("unexpectedError", new Object[0]), e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void cleanup(final int tenantId, String storageSpaceName, MetaEntity metaEntity) {
        boolean exists;
        StorageSpaceMap ssm = ((GRdbDataStore)this.storeService.getDataStore()).getStorageSpaceMapOrDefault(storageSpaceName);
        if (!ssm.getStorageSpaceName().equals(storageSpaceName)) {
            throw new IllegalArgumentException(this.getRS("noStorageSpace", storageSpaceName));
        }
        List postfixList = ssm.allTableNamePostfix();
        final String objDefId = metaEntity.getId();
        List<String> objIdList = this.findObjId(tenantId, objDefId, postfixList, this.rdbAdapterService.getRdbAdapter());
        List<String> cleanupTableList = this.makeCleanupTableList(postfixList, ssm.isUseExternalIndexedTable(), ssm.isUseExternalUniqueIndexedTable());
        int index = 0;
        boolean bl = exists = !objIdList.isEmpty();
        while (exists) {
            int toIndex = this.cleanupCommitLimit > 0 ? (index + this.cleanupCommitLimit > objIdList.size() ? objIdList.size() : index + this.cleanupCommitLimit) : objIdList.size();
            final List<String> objIdSubList = objIdList.subList(index, toIndex);
            Transaction.requiresNew(t -> {
                for (final String table : cleanupTableList) {
                    SqlExecuter<int[]> sqlExec = new SqlExecuter<int[]>(){

                        public int[] logic() throws SQLException {
                            StringBuilder sbSql = new StringBuilder();
                            sbSql.append("DELETE FROM ").append(table);
                            sbSql.append(" WHERE ").append(StorageSpaceServiceImpl.COL_TENANT_ID).append("=?");
                            sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_DEF_ID).append("=?");
                            sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_ID).append("=?");
                            PreparedStatement ps = this.getPreparedStatement(sbSql.toString());
                            for (String objId : objIdSubList) {
                                ps.setInt(1, tenantId);
                                ps.setString(2, objDefId);
                                ps.setString(3, objId);
                                ps.addBatch();
                            }
                            return ps.executeBatch();
                        }
                    };
                    sqlExec.execute(this.rdbAdapterService.getRdbAdapter(), true);
                }
                t.commit();
            });
            index = toIndex;
            exists = index < objIdList.size();
        }
    }

    private void exportCSV(File file, MetaDataEntry entry) throws IOException {
        EntityDataExportCondition condition = new EntityDataExportCondition();
        condition.setVersioned(true);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            this.entityPortingService.write(os, entry, condition);
            ((OutputStream)os).flush();
        }
    }

    private boolean importCSV(File file, String entityName, MetaDataEntry entry) throws IOException {
        EntityDataImportCondition condition = new EntityDataImportCondition();
        condition.setCommitLimit(this.migrateCommitLimit);
        condition.setIgnoreNotExistsProperty(false);
        condition.setUpdateDisupdatableProperty(true);
        condition.setUniqueKey("oid");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            EntityDataImportResult result = this.entityPortingService.importEntityData(entityName, is, entry, condition, null);
            boolean bl = !result.isError();
            return bl;
        }
    }

    private boolean changeStorageSpace(EntityDefinition ed, String storageSpaceName) {
        SchemalessRdbStore sd = (SchemalessRdbStore)ed.getStoreDefinition();
        sd.setStorageSpace(storageSpaceName);
        EntityDefinitionModifyResult result = this.edm.update(ed);
        return result.isSuccess();
    }

    private List<String> findObjId(final int tenantId, final String objDefId, final List<String> postfixList, final RdbAdapter rdb) {
        SqlExecuter<List<String>> exec = new SqlExecuter<List<String>>(){

            public List<String> logic() throws SQLException {
                String sanitizedObjDefId = rdb.sanitize(objDefId);
                StringBuilder sbSql = new StringBuilder();
                if (!postfixList.isEmpty()) {
                    postfixList.forEach(postfix -> {
                        if (sbSql.length() > 0) {
                            sbSql.append(" UNION ");
                        }
                        sbSql.append("SELECT ").append(StorageSpaceServiceImpl.COL_OBJ_ID).append(" FROM ").append(StorageSpaceServiceImpl.TBL_OBJ_STORE);
                        if (StringUtil.isNotBlank((String)postfix)) {
                            sbSql.append("__").append((String)postfix);
                        }
                        sbSql.append(" WHERE ").append(StorageSpaceServiceImpl.COL_TENANT_ID).append("=").append(tenantId);
                        sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_DEF_ID).append("='").append(sanitizedObjDefId).append("'");
                        sbSql.append(" UNION ");
                        sbSql.append("SELECT ").append(StorageSpaceServiceImpl.COL_OBJ_ID).append(" FROM ").append(StorageSpaceServiceImpl.TBL_OBJ_STORE_RB);
                        if (StringUtil.isNotBlank((String)postfix)) {
                            sbSql.append("__").append((String)postfix);
                        }
                        sbSql.append(" WHERE ").append(StorageSpaceServiceImpl.COL_TENANT_ID).append("=").append(tenantId);
                        sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_DEF_ID).append("='").append(sanitizedObjDefId).append("'");
                    });
                } else {
                    sbSql.append("SELECT ").append(StorageSpaceServiceImpl.COL_OBJ_ID).append(" FROM ").append(StorageSpaceServiceImpl.TBL_OBJ_STORE);
                    sbSql.append(" WHERE ").append(StorageSpaceServiceImpl.COL_TENANT_ID).append("=").append(tenantId);
                    sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_DEF_ID).append("='").append(sanitizedObjDefId).append("'");
                    sbSql.append(" UNION ");
                    sbSql.append("SELECT ").append(StorageSpaceServiceImpl.COL_OBJ_ID).append(" FROM ").append(StorageSpaceServiceImpl.TBL_OBJ_STORE_RB);
                    sbSql.append(" WHERE ").append(StorageSpaceServiceImpl.COL_TENANT_ID).append("=").append(tenantId);
                    sbSql.append(" AND ").append(StorageSpaceServiceImpl.COL_OBJ_DEF_ID).append("='").append(sanitizedObjDefId).append("'");
                }
                ArrayList<String> ret = new ArrayList<String>();
                try (ResultSet rs = this.getStatement().executeQuery(sbSql.toString());){
                    while (rs.next()) {
                        ret.add(rs.getString(1));
                    }
                }
                return ret;
            }
        };
        return (List)exec.execute(this.rdbAdapterService.getRdbAdapter(), true);
    }

    private List<String> makeCleanupTableList(List<String> postfixList, boolean useExternalIndexedTable, boolean useExternalUniqueIndexedTable) {
        if (postfixList.isEmpty()) {
            return Arrays.asList(CLEANUP_TABLES);
        }
        ArrayList<String> list = new ArrayList<String>();
        postfixList.forEach(postfix -> {
            for (String table : CLEANUP_TABLES) {
                if (StringUtil.isNotBlank((String)postfix)) {
                    if (!useExternalIndexedTable && Arrays.asList(INDEX_TABLES).contains(table) || !useExternalUniqueIndexedTable && Arrays.asList(UNIQUE_TABLES).contains(table)) continue;
                    list.add(table + "__" + postfix);
                    continue;
                }
                list.add(table);
            }
        });
        return list;
    }

    private String getRS(String suffix, Object ... arguments) {
        return ToolsResourceBundleUtil.resourceString("storagespace." + suffix, arguments);
    }
}

