/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAuthenticationProvider;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.TenantDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.create.TenantCreateProcess;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerFactory;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;
import org.iplass.mtp.tenant.TenantConfig;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.tenant.TenantMailInfo;
import org.iplass.mtp.tenant.gem.TenantGemInfo;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantToolService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(TenantToolService.class);
    private List<TenantCreateProcess> createProcesses;
    private TenantContextService tenantContextService;
    private TenantService tenantService;
    private MetaTenantService metaTenantService;
    private AuthService authService;
    private String defaultEnableLanguages = "ja,en,zh-CN,zh-TW,th";
    private TenantRdbManager rdbManager;

    public void init(Config config) {
        this.tenantContextService = (TenantContextService)config.getDependentService(TenantContextService.class);
        this.tenantService = (TenantService)config.getDependentService(TenantService.class);
        this.metaTenantService = (MetaTenantService)config.getDependentService(MetaTenantService.class);
        this.authService = (AuthService)config.getDependentService(AuthService.class);
        RdbAdapter rdbAdapter = ((RdbAdapterService)config.getDependentService(RdbAdapterService.class)).getRdbAdapter();
        this.createProcesses = config.getValues("createProcesses", TenantCreateProcess.class);
        TenantRdbManagerParameter parameter = (TenantRdbManagerParameter)config.getValue("tenantRdbManagerParameter", TenantRdbManagerParameter.class);
        this.rdbManager = new TenantRdbManagerFactory().createManager(rdbAdapter, parameter);
    }

    public void destroy() {
    }

    public List<TenantInfo> getValidTenantInfoList() {
        return (List)Transaction.required(t -> this.rdbManager.getValidTenantInfoList());
    }

    public List<TenantInfo> getAllTenantInfoList() {
        return (List)Transaction.required(t -> this.rdbManager.getAllTenantInfoList());
    }

    public boolean existsURL(String url) {
        return (Boolean)Transaction.required(t -> this.rdbManager.existsURL(url));
    }

    public TenantInfo getTenantInfo(String url) {
        return (TenantInfo)Transaction.required(t -> this.rdbManager.getTenantInfo(url));
    }

    public String getDefaultEnableLanguages() {
        return this.defaultEnableLanguages;
    }

    public boolean create(TenantCreateParameter param) {
        return this.create(param, new LogHandler(){});
    }

    public boolean create(TenantCreateParameter param, LogHandler logHandler) {
        WrappedLogger wrapLogger = new WrappedLogger(logHandler);
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            Tenant tenant = this.createTenantData(param, wrapLogger);
            boolean ret = this.createPartition(param, tenant, wrapLogger);
            if (!ret) {
                return false;
            }
            TenantContext tContext = this.tenantContextService.getTenantContext(tenant.getId());
            ExecuteContext.executeAs((TenantContext)tContext, () -> {
                this.updateMetaTenantData(param, tenant, wrapLogger);
                return null;
            });
            tContext = this.tenantContextService.getTenantContext(tenant.getId());
            ExecuteContext.executeAs((TenantContext)tContext, () -> {
                for (TenantCreateProcess process : this.createProcesses) {
                    logger.debug("execute " + process.getClass().getSimpleName());
                    if (process.execute(param, logHandler)) continue;
                    break;
                }
                return null;
            });
            return true;
        });
        return isSuccess;
    }

    private Tenant createTenantData(TenantCreateParameter param, LogHandler logHandler) {
        if (this.rdbManager.existsURL(param.getTenantUrl())) {
            throw new IllegalArgumentException(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.existsURLMsg", param.getTenantUrl()));
        }
        Tenant tenant = new Tenant();
        tenant.setName(param.getTenantName());
        tenant.setUrl(param.getTenantUrl());
        tenant.setDescription(param.getTenantDisplayName());
        tenant.setFrom(InternalDateUtil.getNowForSqlDate());
        tenant.setTo(InternalDateUtil.getYukoDateTo());
        this.tenantService.registTenant(tenant, param.getRegistId());
        tenant = this.tenantService.getTenant(tenant.getUrl());
        logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.createdTenantInfoMsg", tenant.getId()));
        return tenant;
    }

    private boolean createPartition(TenantCreateParameter param, Tenant tenant, LogHandler logHandler) {
        if (!this.rdbManager.isSupportPartition()) {
            return true;
        }
        PartitionCreateParameter partitionParam = new PartitionCreateParameter();
        partitionParam.setTenantId(tenant.getId());
        partitionParam.setSubPartitionSize(param.getSubPartitionSize());
        partitionParam.setOnlyPartitionCreate(false);
        partitionParam.setLoggerLanguage(param.getLoggerLanguage());
        return this.createPartition(partitionParam, logHandler);
    }

    private void updateMetaTenantData(TenantCreateParameter param, Tenant tenant, LogHandler logHandler) {
        boolean metaUpdate = false;
        if (StringUtil.isNotBlank((String)param.getTenantDisplayName())) {
            tenant.setDisplayName(param.getTenantDisplayName());
            metaUpdate = true;
        }
        if (StringUtil.isNotBlank((String)param.getTopUrl())) {
            this.setDefaultTenantWebInfo(param, tenant);
            metaUpdate = true;
        }
        if (metaUpdate || !this.defaultEnableLanguages.equals(param.getUseLanguages())) {
            this.setDefaultTenantI18nInfo(param, tenant);
            metaUpdate = true;
        }
        if (metaUpdate) {
            MetaTenant metaTenant = new MetaTenant();
            metaTenant.applyConfig(tenant);
            this.metaTenantService.updateMetaData(metaTenant);
            logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.updatedTenantMetaMsg", tenant.getId()));
        }
    }

    private void setDefaultTenantInfo(TenantCreateParameter param, Tenant tenant) {
        TenantAuthInfo authInfo = new TenantAuthInfo();
        tenant.setTenantConfig((TenantConfig)authInfo);
        TenantMailInfo mailInfo = new TenantMailInfo();
        mailInfo.setSendMailEnable(false);
        tenant.setTenantConfig((TenantConfig)mailInfo);
        TenantI18nInfo i18Info = new TenantI18nInfo();
        i18Info.setUseMultilingual(true);
        if (param.getUseLanguages() != null && !param.getUseLanguages().isEmpty()) {
            String[] langArray = param.getUseLanguages().split(",");
            ArrayList<String> useLanguageList = new ArrayList<String>(langArray.length);
            for (String lang : langArray) {
                useLanguageList.add(lang);
            }
            i18Info.setUseLanguageList(useLanguageList);
        }
        tenant.setTenantConfig((TenantConfig)i18Info);
        TenantWebInfo webInfo = new TenantWebInfo();
        webInfo.setHomeUrl(param.getTopUrl());
        tenant.setTenantConfig((TenantConfig)webInfo);
        TenantGemInfo gemInfo = new TenantGemInfo();
        gemInfo.setIconUrl(param.getIconUrl());
        tenant.setTenantConfig((TenantConfig)gemInfo);
    }

    private void setDefaultTenantI18nInfo(TenantCreateParameter param, Tenant tenant) {
        TenantI18nInfo i18Info = new TenantI18nInfo();
        if (param.getUseLanguages() != null && !param.getUseLanguages().isEmpty()) {
            String[] langArray = param.getUseLanguages().split(",");
            ArrayList<String> useLanguageList = new ArrayList<String>(langArray.length);
            for (String lang : langArray) {
                useLanguageList.add(lang);
            }
            i18Info.setUseLanguageList(useLanguageList);
            i18Info.setUseMultilingual(true);
        }
        tenant.setTenantConfig((TenantConfig)i18Info);
    }

    private void setDefaultTenantWebInfo(TenantCreateParameter param, Tenant tenant) {
        TenantWebInfo webInfo = new TenantWebInfo();
        webInfo.setHomeUrl(param.getTopUrl());
        tenant.setTenantConfig((TenantConfig)webInfo);
    }

    public boolean remove(TenantDeleteParameter param) {
        return this.remove(param, new LogHandler(){});
    }

    public boolean remove(TenantDeleteParameter param, LogHandler logHandler) {
        WrappedLogger wrapLogger = new WrappedLogger(logHandler);
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            boolean deleteAccount = false;
            AuthenticationProvider provider = this.authService.getAuthenticationProvider();
            if (provider instanceof BuiltinAuthenticationProvider) {
                deleteAccount = true;
            }
            this.rdbManager.deleteTenant(param, deleteAccount, wrapLogger);
            return true;
        });
        return isSuccess;
    }

    public List<PartitionInfo> getPartitionInfo() {
        if (this.rdbManager.isSupportPartition()) {
            return (List)Transaction.required(t -> this.rdbManager.getPartitionInfo());
        }
        return null;
    }

    public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
        if (this.rdbManager.isSupportPartition()) {
            return (Boolean)Transaction.required(t -> this.rdbManager.createPartition(param, logHandler));
        }
        return false;
    }

    private static class WrappedLogger
    implements LogHandler {
        private LogHandler logHandler;

        public WrappedLogger(LogHandler logHandler) {
            this.logHandler = logHandler;
        }

        @Override
        public void debug(String message) {
            logger.debug(message);
            this.logHandler.debug(message);
        }

        @Override
        public void debug(String message, Throwable e) {
            logger.debug(message, e);
            this.logHandler.debug(message, e);
        }

        @Override
        public void info(String message) {
            logger.info(message);
            this.logHandler.info(message);
        }

        @Override
        public void info(String message, Throwable e) {
            logger.info(message, e);
            this.logHandler.info(message, e);
        }

        @Override
        public void warn(String message) {
            logger.warn(message);
            this.logHandler.warn(message);
        }

        @Override
        public void warn(String message, Throwable e) {
            logger.warn(message, e);
            this.logHandler.warn(message, e);
        }

        @Override
        public void error(String message) {
            logger.error(message);
            this.logHandler.error(message);
        }

        @Override
        public void error(String message, Throwable e) {
            logger.error(message, e);
            this.logHandler.error(message, e);
        }
    }
}

