/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.create;

import org.iplass.mtp.auth.Group;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.tools.tenant.create.TenantCreateProcess;

public abstract class AbstractCreateRoleProcess
implements TenantCreateProcess {
    protected Entity insertGroupRole(String roleName, EntityManager em) {
        Group group = new Group();
        group.setName(roleName);
        group.setCode(roleName);
        em.insert((Entity)group);
        GenericEntity role = new GenericEntity("mtp.auth.Role");
        role.setName(roleName);
        role.setValue("code", (Object)roleName);
        em.insert((Entity)role);
        GenericEntity roleCond = new GenericEntity("mtp.auth.RoleCondition");
        roleCond.setName(roleName);
        roleCond.setValue("role", (Object)role);
        roleCond.setValue("expression", (Object)("user.memberOf(\"" + roleName + "\")"));
        em.insert((Entity)roleCond);
        return role;
    }

    protected Entity searchRole(String roleName, EntityManager em) {
        Query query = new Query();
        query.select(new Object[]{"oid", "version", "name"}).from("mtp.auth.Role").where((Condition)new Equals("code", (Object)roleName));
        return (Entity)em.searchEntity(query).getFirst();
    }

    protected GenericEntity createActionPermission(String targetAction, Entity role) {
        GenericEntity permission = new GenericEntity("mtp.auth.ActionPermission");
        permission.setName(targetAction);
        permission.setValue("role", (Object)role);
        permission.setValue("targetAction", (Object)targetAction);
        return permission;
    }

    protected GenericEntity createEntityPermission(String targetEntity, Entity role, boolean canReference, boolean canCreate, boolean canUpdate, boolean canDelete) {
        GenericEntity permission = new GenericEntity("mtp.auth.EntityPermission");
        permission.setName(targetEntity);
        permission.setValue("role", (Object)role);
        permission.setValue("targetEntity", (Object)targetEntity);
        permission.setValue("canReference", (Object)canReference);
        permission.setValue("canCreate", (Object)canCreate);
        permission.setValue("canUpdate", (Object)canUpdate);
        permission.setValue("canDelete", (Object)canDelete);
        return permission;
    }

    protected GenericEntity createWebApiPermission(String targetWebApi, Entity role) {
        GenericEntity permission = new GenericEntity("mtp.auth.WebApiPermission");
        permission.setName(targetWebApi);
        permission.setValue("role", (Object)role);
        permission.setValue("targetWebApi", (Object)targetWebApi);
        return permission;
    }
}

