/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.create;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.TenantToolService;
import org.iplass.mtp.impl.tools.tenant.create.TenantCreateProcess;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.spi.Config;

public class CreateAdminUserProcess
implements TenantCreateProcess {
    private AuthenticationPolicyService authPolicyService;

    @Override
    public void inited(TenantToolService service, Config config) {
        this.authPolicyService = (AuthenticationPolicyService)config.getDependentService(AuthenticationPolicyService.class);
    }

    @Override
    public boolean execute(TenantCreateParameter param, LogHandler logHandler) {
        User user = new User();
        user.setValue("accountId", (Object)param.getAdminUserId());
        user.setValue("firstName", (Object)"Admin");
        user.setValue("lastName", (Object)"User");
        user.setValue("lastNameKana", null);
        user.setValue("firstNameKana", null);
        user.setValue("admin", (Object)true);
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = (MetaAuthenticationPolicy.AuthenticationPolicyRuntime)this.authPolicyService.getRuntimeByName("DEFAULT");
        if (pol != null) {
            pol.getMetaData().getPasswordPolicy().setCreateAccountWithSpecificPassword(true);
        }
        user.setPassword(param.getAdminPassword());
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        em.insert((Entity)user);
        logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.createdAdminMsg", param.getAdminUserId()));
        return true;
    }
}

