/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.create;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.create.AbstractCreateRoleProcess;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;

public class CreateAppAdminRoleProcess
extends AbstractCreateRoleProcess {
    @Override
    public boolean execute(TenantCreateParameter param, LogHandler logHandler) {
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity role = this.insertGroupRole("AppAdmin", em);
        this.insertActionPermission(role, em);
        this.insertEntityPermission(role, em);
        this.insertWebApiPermission(role, em);
        logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.createdAppAdminRole", new Object[0]));
        return true;
    }

    private void insertActionPermission(Entity role, EntityManager em) {
        GenericEntity permission = this.createActionPermission("gem/*", role);
        permission.setValue("conditionExpression", (Object)"org.iplass.gem.auth.GemAuth.isPermitAction(action, parameter)");
        em.insert((Entity)permission);
    }

    private void insertEntityPermission(Entity role, EntityManager em) {
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        edm.definitionSummaryList("mtp.auth.", true).forEach(ed -> {
            GenericEntity authPermission = this.createEntityPermission(ed.getName(), role, true, true, true, true);
            em.insert((Entity)authPermission);
        });
        edm.definitionSummaryList("mtp.maintenance.", true).forEach(ed -> {
            GenericEntity maintenancePermission = this.createEntityPermission(ed.getName(), role, false, false, false, false);
            em.insert((Entity)maintenancePermission);
        });
        GenericEntity permission = this.createEntityPermission("mtp.Information", role, true, true, true, true);
        em.insert((Entity)permission);
    }

    private void insertWebApiPermission(Entity role, EntityManager em) {
        GenericEntity permission = this.createWebApiPermission("gem/*", role);
        permission.setValue("conditionExpression", (Object)"org.iplass.gem.auth.GemAuth.isPermitWebApi(webApi, parameter)");
        em.insert((Entity)permission);
    }
}

