/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.create;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.create.TenantCreateProcess;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.view.menu.MenuItem;
import org.iplass.mtp.view.menu.MenuItemManager;
import org.iplass.mtp.view.menu.MenuTree;
import org.iplass.mtp.view.menu.MenuTreeManager;

public class CreateMenuProcess
implements TenantCreateProcess {
    private static final String DEFAULT_MENU_TREE = "DEFAULT";
    private static final String PERMISSION_NODE_NAME = "permission_node";
    private static final String[] PERMISSION_NODE_CHILDREN = new String[]{"mtp/auth/Role", "mtp/auth/ActionPermission", "mtp/auth/WebApiPermission", "mtp/auth/EntityPermission", "mtp/auth/WorkflowPermission", "mtp/auth/CubePermission"};
    private static final String STANDARD_NODE_NAME = "standard_node";
    private static final String[] STANDARD_NODE_CHILDREN = new String[]{"mtp/auth/Group", "mtp/auth/Rank", "mtp/auth/User"};
    private static final String[] OTHER_ITEMS = new String[]{"mtp/Information"};

    @Override
    public boolean execute(TenantCreateParameter param, LogHandler logHandler) {
        MenuItem child;
        MenuItemManager mm = (MenuItemManager)ManagerLocator.getInstance().getManager(MenuItemManager.class);
        MenuTreeManager mtm = (MenuTreeManager)ManagerLocator.getInstance().getManager(MenuTreeManager.class);
        MenuTree tree = new MenuTree();
        tree.setName(DEFAULT_MENU_TREE);
        MenuItem permissionItem = (MenuItem)mm.get(PERMISSION_NODE_NAME);
        for (String childName : PERMISSION_NODE_CHILDREN) {
            MenuItem child2 = (MenuItem)mm.get(childName);
            if (child2 == null) continue;
            permissionItem.addChild(child2);
        }
        tree.addMenuItem(permissionItem);
        MenuItem standardItem = (MenuItem)mm.get(STANDARD_NODE_NAME);
        for (String childName : STANDARD_NODE_CHILDREN) {
            child = (MenuItem)mm.get(childName);
            if (child == null) continue;
            standardItem.addChild(child);
        }
        tree.addMenuItem(standardItem);
        for (String itemName : OTHER_ITEMS) {
            child = (MenuItem)mm.get(itemName);
            if (child == null) continue;
            tree.addMenuItem(child);
        }
        DefinitionModifyResult result = mtm.create((Definition)tree);
        if (!result.isSuccess()) {
            throw new ApplicationException(result.getMessage());
        }
        logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.createdMenuMsg", tree.getName()));
        return true;
    }
}

