/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.create;

import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.TenantCreateParameter;
import org.iplass.mtp.impl.tools.tenant.create.TenantCreateProcess;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.view.top.MetaTopView;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.parts.InformationParts;
import org.iplass.mtp.view.top.parts.TopViewParts;

public class CreateTopViewProcess
implements TenantCreateProcess {
    private static final String DEFAULT_TOP_VIEW = "DEFAULT";
    private KeyGenerator generator = new KeyGenerator();

    @Override
    public boolean execute(TenantCreateParameter param, LogHandler logHandler) {
        TopViewDefinition definition = new TopViewDefinition();
        definition.setName(DEFAULT_TOP_VIEW);
        definition.setDisplayName(DEFAULT_TOP_VIEW);
        definition.addParts((TopViewParts)new InformationParts());
        MetaTopView meta = new MetaTopView();
        meta.applyConfig(definition);
        meta.setId(this.generator.generateId());
        String path = DefinitionService.getInstance().getPathByMeta(MetaTopView.class, meta.getName());
        try {
            MetaDataContext.getContext().store(path, (RootMetaData)meta, null, false);
        }
        catch (Exception e) {
            String type = meta.getClass().getSimpleName();
            if (e.getCause() != null) {
                throw new RuntimeException("exception occured during " + type + " create:" + e.getCause().getMessage());
            }
            throw new RuntimeException("exception occured during " + type + " create:" + e.getMessage());
        }
        logHandler.info(ToolsResourceBundleUtil.resourceString(param.getLoggerLanguage(), "tenant.create.createdTopViewMsg", definition.getName()));
        return true;
    }
}

