/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.TenantDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbConstants;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;

public abstract class DefaultTenantRdbManager
implements TenantRdbManager {
    private static final String TENANT_EXISTS_SQL = "select 1 from dual where exists(select * from t_tenant where url = ?)";
    private static final String TENANT_SELECT_SQL = "select id, name, description, host_name, url,yuko_date_from, yuko_date_to, cre_user, cre_date, up_user, up_date from t_tenant ";
    private static final String ALL_TENANT_SQL = "select id, name, description, host_name, url,yuko_date_from, yuko_date_to, cre_user, cre_date, up_user, up_date from t_tenant order by id ";
    private static final String VALID_TENANT_SQL = "select id, name, description, host_name, url,yuko_date_from, yuko_date_to, cre_user, cre_date, up_user, up_date from t_tenant where yuko_date_from <= ? and yuko_date_to >= ? order by id ";
    private static final String GET_TENANT_SQL = "select id, name, description, host_name, url,yuko_date_from, yuko_date_to, cre_user, cre_date, up_user, up_date from t_tenant where url = ? order by id ";
    private static final String DELETE_TENANT_SQL = "delete from t_tenant where id = ?";
    private static final String DELETE_ACCOUNT_SQL = "delete from t_account where tenant_id = ? ";
    private RdbAdapter adapter;
    private TenantRdbManagerParameter tenantRdbManagerParameter;

    public DefaultTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter tenantRdbManagerParameter) {
        this.adapter = adapter;
        this.tenantRdbManagerParameter = tenantRdbManagerParameter;
    }

    protected abstract boolean isExistsTable(String var1);

    @Override
    public boolean existsURL(final String url) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                PreparedStatement statement = this.getPreparedStatement(DefaultTenantRdbManager.TENANT_EXISTS_SQL);
                String key = !url.startsWith("/") ? "/" + url : url;
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    Boolean bl = rs.next();
                    return bl;
                }
            }
        };
        return (Boolean)exec.execute(this.adapter, true);
    }

    @Override
    public TenantInfo getTenantInfo(final String url) {
        SqlExecuter<TenantInfo> exec = new SqlExecuter<TenantInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TenantInfo logic() throws SQLException {
                PreparedStatement statement = this.getPreparedStatement(DefaultTenantRdbManager.GET_TENANT_SQL);
                String key = !url.startsWith("/") ? "/" + url : url;
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        TenantInfo tenant;
                        TenantInfo tenantInfo = tenant = DefaultTenantRdbManager.this.convert(rs);
                        return tenantInfo;
                    }
                }
                return null;
            }
        };
        return (TenantInfo)exec.execute(this.adapter, true);
    }

    @Override
    public List<TenantInfo> getValidTenantInfoList() {
        return this.getTenantInfoList(true);
    }

    @Override
    public List<TenantInfo> getAllTenantInfoList() {
        return this.getTenantInfoList(false);
    }

    private List<TenantInfo> getTenantInfoList(final boolean onlyValid) {
        SqlExecuter<List<TenantInfo>> exec = new SqlExecuter<List<TenantInfo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<TenantInfo> logic() throws SQLException {
                PreparedStatement statement = null;
                if (onlyValid) {
                    Date now = InternalDateUtil.getNowForSqlDate();
                    statement = this.getPreparedStatement(DefaultTenantRdbManager.VALID_TENANT_SQL);
                    statement.setDate(1, now);
                    statement.setDate(2, now);
                } else {
                    statement = this.getPreparedStatement(DefaultTenantRdbManager.ALL_TENANT_SQL);
                }
                ArrayList<TenantInfo> result = new ArrayList<TenantInfo>();
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        TenantInfo tenant = DefaultTenantRdbManager.this.convert(rs);
                        result.add(tenant);
                    }
                }
                return result;
            }
        };
        return (List)exec.execute(this.adapter, true);
    }

    private TenantInfo convert(ResultSet rs) throws SQLException {
        TenantInfo tenant = new TenantInfo();
        tenant.setId(rs.getInt(1));
        tenant.setName(rs.getString(2));
        tenant.setDescription(rs.getString(3));
        tenant.setHostName(rs.getString(4));
        tenant.setUrl(rs.getString(5));
        tenant.setYukoDateFrom(rs.getDate(6, this.adapter.javaCalendar()));
        tenant.setYukoDateTo(rs.getDate(7, this.adapter.javaCalendar()));
        tenant.setCreateUser(rs.getString(8));
        tenant.setCreateDate(rs.getTimestamp(9, this.adapter.rdbCalendar()));
        tenant.setUpdateUser(rs.getString(10));
        tenant.setUpdateDate(rs.getTimestamp(11, this.adapter.rdbCalendar()));
        return tenant;
    }

    @Override
    public boolean deleteTenant(TenantDeleteParameter param, boolean deleteAccount, LogHandler logHandler) {
        this.deleteTenantTables(param, logHandler);
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            if (deleteAccount) {
                this.deleteAccountTable(param, logHandler);
            }
            this.deleteTenantTable(param, logHandler);
            return true;
        });
        if (isSuccess && this.isSupportPartition()) {
            PartitionDeleteParameter partitionParam = new PartitionDeleteParameter();
            partitionParam.setTenantId(param.getTenantId());
            partitionParam.setLoggerLanguage(param.getLoggerLanguage());
            isSuccess = this.dropPartition(partitionParam, logHandler);
        }
        return isSuccess;
    }

    private void deleteTenantTable(final TenantDeleteParameter param, LogHandler logHandler) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(DefaultTenantRdbManager.DELETE_TENANT_SQL);
                ps.setInt(1, param.getTenantId());
                return ps.executeUpdate();
            }
        };
        int row = (Integer)exec.execute(this.adapter, true);
        logHandler.info(this.getDeleteResourceMessage(param.getLoggerLanguage(), "deletedTableMsg", "t_tenant", row));
    }

    private void deleteAccountTable(final TenantDeleteParameter param, LogHandler logHandler) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(DefaultTenantRdbManager.DELETE_ACCOUNT_SQL);
                ps.setInt(1, param.getTenantId());
                return ps.executeUpdate();
            }
        };
        int row = (Integer)exec.execute(this.adapter, true);
        logHandler.info(this.getDeleteResourceMessage(param.getLoggerLanguage(), "deletedTableMsg", "t_account", row));
    }

    private void deleteTenantTables(TenantDeleteParameter param, LogHandler logHandler) {
        for (String tableName : this.getTableList()) {
            String deletionUnitColumns = this.getDeletionUnitColumns(tableName);
            if (this.isStorageSpaceTable(tableName)) {
                for (String postfix : this.getStorageSpacePostfix(false)) {
                    String storageSpaceTableName = tableName + postfix;
                    if (!this.isExistsTable(storageSpaceTableName, true)) continue;
                    int row = this.deleteTenantRecords(param, storageSpaceTableName, deletionUnitColumns, logHandler);
                    logHandler.info(this.getDeleteResourceMessage(param.getLoggerLanguage(), "deletedTableMsg", storageSpaceTableName, row));
                }
                continue;
            }
            if (!this.isExistsTable(tableName, false)) continue;
            int row = this.deleteTenantRecords(param, tableName, deletionUnitColumns, logHandler);
            logHandler.info(this.getDeleteResourceMessage(param.getLoggerLanguage(), "deletedTableMsg", tableName, row));
        }
    }

    private int deleteTenantRecords(TenantDeleteParameter param, String tableName, String deletionUnitColumns, LogHandler logHandler) {
        int actualDeletedRows = 0;
        int deleteRows = this.getTenantRdbManagerParameter().getDeleteRows();
        boolean isContinue = true;
        SqlExecuter<Integer> tenantRecordDeleteExecuter = this.getTenantRecordDeleteExecuter(param.getTenantId(), tableName, deletionUnitColumns, deleteRows);
        do {
            Integer actual = (Integer)Transaction.requiresNew(t -> (Integer)tenantRecordDeleteExecuter.execute(this.adapter, true));
            actualDeletedRows += actual.intValue();
            boolean bl = isContinue = deleteRows <= actual;
            if (!isContinue) continue;
            logHandler.info(this.getDeleteResourceMessage(param.getLoggerLanguage(), "deletingTableMsg", tableName, actualDeletedRows));
        } while (isContinue);
        return actualDeletedRows;
    }

    protected abstract SqlExecuter<Integer> getTenantRecordDeleteExecuter(int var1, String var2, String var3, int var4);

    protected String[] getTableList() {
        return TenantRdbConstants.TABLE_LIST;
    }

    protected boolean isStorageSpaceTable(String tableName) {
        return TenantRdbConstants.STORAGE_SPACE_TABLE.contains(tableName);
    }

    protected boolean isPartitionTargetTable(String tableName) {
        return !TenantRdbConstants.EXCLUDE_PARTITION_TABLE.contains(tableName);
    }

    protected boolean isSubPartitionTargetTable(String tableName) {
        return !TenantRdbConstants.EXCLUDE_SUB_PARTITION_TABLE.contains(tableName);
    }

    protected int getMaxSubPartitionCount() {
        return 8;
    }

    protected List<String> getStorageSpacePostfix(boolean isPartition) {
        GRdbDataStore store = (GRdbDataStore)((StoreService)ServiceRegistry.getRegistry().getService(StoreService.class)).getDataStore();
        ArrayList<String> postfixList = new ArrayList<String>();
        for (StorageSpaceMap e : store.getStorageSpaceMap().values()) {
            if (isPartition && e.isCustomPartition()) continue;
            List allPostFix = e.allTableNamePostfix();
            for (String pf : allPostFix) {
                if (pf != null) {
                    postfixList.add("__" + pf);
                    continue;
                }
                postfixList.add("");
            }
        }
        return postfixList;
    }

    protected boolean isExistsTable(String tableName, boolean isStorageSpace) {
        if (isStorageSpace) {
            return this.isExistsTable(tableName);
        }
        if (TenantRdbConstants.CHECK_EXIST_TABLE.contains(tableName)) {
            return this.isExistsTable(tableName);
        }
        return true;
    }

    protected TenantRdbManagerParameter getTenantRdbManagerParameter() {
        return this.tenantRdbManagerParameter;
    }

    private String getDeletionUnitColumns(String tableName) {
        return TenantRdbConstants.TABLE_LIST_DELETION_UNIT_COLS.get(tableName);
    }

    private String getDeleteResourceMessage(String lang, String suffix, Object ... args) {
        return ToolsResourceBundleUtil.resourceString(lang, "tenant.delete." + suffix, args);
    }
}

