/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.DefaultTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTenantRdbManager
extends DefaultTenantRdbManager {
    private static Logger logger = LoggerFactory.getLogger(MySQLTenantRdbManager.class);
    private static final String MYSQL_EXIST_TABLE_SQL = "select count(*) from information_schema.tables where lower(table_name) = lower(?)";
    private static final String MYSQL_EXIST_TABLE_SQL_WITH_SCHEMA = "select count(*) from information_schema.tables where table_schema = ? and lower(table_name) = lower(?)";
    private static final String MYSQL_MAX_PARTITION_SQL = "select partition_name from information_schema.partitions where lower(table_name) = lower(?) order by length(partition_name) desc , partition_name desc";
    private static final String MYSQL_MAX_PARTITION_SQL_WITH_SCHEMA = "select partition_name from information_schema.partitions where table_schema = ? and lower(table_name) = lower(?) order by length(partition_name) desc , partition_name desc";
    private static final String MYSQL_EXIST_PARTITION_SQL = "select count(*) from information_schema.partitions where lower(table_name) = lower(?) and lower(partition_name) = lower(?)";
    private static final String MYSQL_EXIST_PARTITION_SQL_WITH_SCHEMA = "select count(*) from information_schema.partitions where table_schema = ? and lower(table_name) = lower(?) and lower(partition_name) = lower(?)";
    private RdbAdapter adapter;

    public MySQLTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
        super(adapter, parameter);
        this.adapter = adapter;
    }

    @Override
    public boolean isSupportPartition() {
        return true;
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return (List)Transaction.required(t -> {
            ArrayList<PartitionInfo> ret = new ArrayList<PartitionInfo>();
            for (String tableName : this.getTableList()) {
                if (this.isStorageSpaceTable(tableName)) {
                    for (String postfix : this.getStorageSpacePostfix(true)) {
                        String storageSpaceTableName = tableName + postfix;
                        if (!this.isPartitionTargetTable(storageSpaceTableName) || !this.isExistsTable(storageSpaceTableName, true)) continue;
                        PartitionInfo info = this.getTablePartitionInfo(storageSpaceTableName);
                        ret.add(info);
                    }
                    continue;
                }
                if (!this.isPartitionTargetTable(tableName) || !this.isExistsTable(tableName, false)) continue;
                PartitionInfo info = this.getTablePartitionInfo(tableName);
                ret.add(info);
            }
            return ret;
        });
    }

    private PartitionInfo getTablePartitionInfo(final String tableName) {
        SqlExecuter<PartitionInfo> exec = new SqlExecuter<PartitionInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PartitionInfo logic() throws SQLException {
                PreparedStatement ps = null;
                String databaseName = MySQLTenantRdbManager.this.adapter.getConnection().getCatalog();
                if (StringUtil.isEmpty((String)databaseName)) {
                    ps = this.getPreparedStatement(MySQLTenantRdbManager.MYSQL_MAX_PARTITION_SQL);
                    ps.setString(1, tableName);
                } else {
                    ps = this.getPreparedStatement(MySQLTenantRdbManager.MYSQL_MAX_PARTITION_SQL_WITH_SCHEMA);
                    ps.setString(1, databaseName);
                    ps.setString(2, tableName);
                }
                ResultSet rs = ps.executeQuery();
                int maxTenantId = -1;
                TreeSet<String> partitionNames = new TreeSet<String>();
                try {
                    if (rs.next()) {
                        String max_partition_name = rs.getString(1);
                        partitionNames.add(max_partition_name);
                        try {
                            maxTenantId = Integer.parseInt(max_partition_name.substring((tableName + "_").length()));
                        }
                        catch (NumberFormatException e) {
                            logger.warn("cant parse the partition name:" + max_partition_name);
                        }
                    }
                    while (rs.next()) {
                        partitionNames.add(rs.getString(1));
                    }
                }
                finally {
                    rs.close();
                }
                PartitionInfo info = new PartitionInfo(tableName, partitionNames, maxTenantId);
                return info;
            }
        };
        return (PartitionInfo)exec.execute(this.adapter, true);
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            this.doCreatePartition(param, logHandler);
            return true;
        });
        return isSuccess;
    }

    private void doCreatePartition(PartitionCreateParameter param, LogHandler logHandler) {
        List<PartitionInfo> partitionList = this.getPartitionInfo();
        List<TenantInfo> validTenantList = this.getValidTenantInfoList();
        for (PartitionInfo partitionInfo : partitionList) {
            this.createTablePartition(param, partitionInfo, validTenantList, logHandler);
        }
    }

    private void createTablePartition(PartitionCreateParameter param, PartitionInfo partitionInfo, List<TenantInfo> storeTenantList, LogHandler logHandler) {
        if (partitionInfo.getMaxTenantId() >= param.getTenantId()) {
            logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "skipPartitionMsg", partitionInfo.getMaxTenantId(), partitionInfo.getTableName()));
            return;
        }
        int maxTenantId = 0;
        if (!storeTenantList.isEmpty()) {
            maxTenantId = storeTenantList.get(storeTenantList.size() - 1).getId();
        }
        int maxPartitionId = partitionInfo.getMaxTenantId() > 0 ? partitionInfo.getMaxTenantId() : 0;
        ArrayList<Integer> addTenantIdList = new ArrayList<Integer>();
        if (maxPartitionId < maxTenantId) {
            for (TenantInfo tenant : storeTenantList) {
                if (tenant.getId() <= maxPartitionId) continue;
                addTenantIdList.add(tenant.getId());
                logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "createExistTenantPartitionMsg", tenant.getId()));
            }
        }
        for (int tenantId = maxTenantId + 1; tenantId <= param.getTenantId(); ++tenantId) {
            if (partitionInfo.exists(tenantId)) continue;
            if (maxPartitionId >= tenantId) {
                logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "skipPartitionMsg", partitionInfo.getMaxTenantId(), partitionInfo.getTableName()));
                continue;
            }
            addTenantIdList.add(tenantId);
        }
        Iterator iterator = addTenantIdList.iterator();
        while (iterator.hasNext()) {
            int tenantId = (Integer)iterator.next();
            this.executeTableCreatePartition(param, partitionInfo.getTableName(), tenantId, logHandler);
        }
    }

    private void executeTableCreatePartition(final PartitionCreateParameter param, String tableName, int tenantId, final LogHandler logHandler) {
        final String partitionName = tableName + "_" + tenantId;
        final StringBuilder sql = new StringBuilder("alter table " + tableName + " add partition (partition " + partitionName + " values less than (" + (tenantId + 1) + ") ");
        sql.append(")");
        Transaction.requiresNew(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                public Void logic() throws SQLException {
                    PreparedStatement ps = this.getPreparedStatement(sql.toString());
                    ps.executeUpdate();
                    logHandler.info(MySQLTenantRdbManager.this.getPartitionResourceMessage(param.getLoggerLanguage(), "createdPartitionMsg", new Object[]{partitionName}));
                    return null;
                }
            };
            exec.execute(this.adapter, true);
            return null;
        });
    }

    @Override
    public boolean dropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            this.doDropPartition(param, logHandler);
            return true;
        });
        return isSuccess;
    }

    private void doDropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        for (String tableName : this.getTableList()) {
            if (!this.isPartitionTargetTable(tableName)) continue;
            if (this.isStorageSpaceTable(tableName)) {
                for (String postfix : this.getStorageSpacePostfix(true)) {
                    String storageSpaceTableName = tableName + postfix;
                    this.executeTableDropPartition(param, logHandler, storageSpaceTableName);
                }
                continue;
            }
            this.executeTableDropPartition(param, logHandler, tableName);
        }
    }

    private void executeTableDropPartition(final PartitionDeleteParameter param, final LogHandler logHandler, String tableName) {
        final String partitionName = tableName + "_" + param.getTenantId();
        if (this.existsTablePartition(param, logHandler, tableName)) {
            Transaction.requiresNew(t -> {
                final String sql = "alter table " + tableName + " drop partition " + partitionName;
                SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                    public Void logic() throws SQLException {
                        PreparedStatement ps = this.getPreparedStatement(sql);
                        ps.executeUpdate();
                        logHandler.info(MySQLTenantRdbManager.this.getPartitionResourceMessage(param.getLoggerLanguage(), "droppedPartitionMsg", new Object[]{partitionName}));
                        return null;
                    }
                };
                try {
                    exec.execute(this.adapter, true);
                }
                catch (Exception e) {
                    logHandler.warn("partition cant dropped ...:" + sql, e);
                }
            });
        } else {
            logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "skipDropPartitionMsg", partitionName));
        }
    }

    private boolean existsTablePartition(final PartitionDeleteParameter param, LogHandler logHandler, final String tableName) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                String partitionName = tableName + "_" + param.getTenantId();
                PreparedStatement ps = null;
                String databaseName = MySQLTenantRdbManager.this.adapter.getConnection().getCatalog();
                if (StringUtil.isEmpty((String)databaseName)) {
                    ps = this.getPreparedStatement(MySQLTenantRdbManager.MYSQL_EXIST_PARTITION_SQL);
                    ps.setString(1, tableName);
                    ps.setString(2, partitionName);
                } else {
                    ps = this.getPreparedStatement(MySQLTenantRdbManager.MYSQL_EXIST_PARTITION_SQL_WITH_SCHEMA);
                    ps.setString(1, databaseName);
                    ps.setString(2, tableName);
                    ps.setString(3, partitionName);
                }
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                if (count <= 0) {
                    return false;
                }
                return true;
            }
        };
        return (Boolean)exec.execute(this.adapter, true);
    }

    @Override
    protected boolean isExistsTable(String tableName) {
        SqlExecuter<Boolean> exec = null;
        String databaseName = null;
        try {
            databaseName = this.adapter.getConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        exec = StringUtil.isEmpty(databaseName) ? this.createCheckExistSqlExecuter(MYSQL_EXIST_TABLE_SQL, tableName, null) : this.createCheckExistSqlExecuter(MYSQL_EXIST_TABLE_SQL_WITH_SCHEMA, tableName, databaseName);
        return (Boolean)exec.execute(this.adapter, true);
    }

    private SqlExecuter<Boolean> createCheckExistSqlExecuter(final String sql, final String tableName, final String databaseName) {
        return new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(sql);
                if (StringUtil.isEmpty((String)databaseName)) {
                    ps.setString(1, tableName);
                } else {
                    ps.setString(1, databaseName);
                    ps.setString(2, tableName);
                }
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                if (count <= 0) {
                    return false;
                }
                return true;
            }
        };
    }

    private String getPartitionResourceMessage(String lang, String suffix, Object ... args) {
        return ToolsResourceBundleUtil.resourceString(lang, "tenant.partition." + suffix, args);
    }

    @Override
    protected SqlExecuter<Integer> getTenantRecordDeleteExecuter(final int tenantId, final String tableName, String deletionUnitColumns, final int deleteRows) {
        return new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                String sql = "delete from " + tableName + " where tenant_id = ? limit ?";
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setInt(1, tenantId);
                ps.setInt(2, deleteRows);
                return ps.executeUpdate();
            }
        };
    }
}

