/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.DefaultTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;

public class OracleTenantRdbManager
extends DefaultTenantRdbManager {
    private static final String ORACLE_EXIST_TABLE_SQL = "select count(*) from user_tables where lower(table_name) = lower(?)";
    private static final String ORACLE_EXIST_SYNONYM_SQL = "select count(*) from user_synonyms where lower(synonym_name) = lower(?)";
    private RdbAdapter adapter;

    public OracleTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
        super(adapter, parameter);
        this.adapter = adapter;
    }

    @Override
    public boolean isSupportPartition() {
        return false;
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return null;
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
        return false;
    }

    @Override
    public boolean dropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        return false;
    }

    @Override
    protected boolean isExistsTable(String tableName) {
        SqlExecuter<Boolean> exec = this.createCheckExistSqlExecuter(ORACLE_EXIST_TABLE_SQL, tableName);
        if (((Boolean)exec.execute(this.adapter, true)).booleanValue()) {
            return true;
        }
        exec = this.createCheckExistSqlExecuter(ORACLE_EXIST_SYNONYM_SQL, tableName);
        return (Boolean)exec.execute(this.adapter, true);
    }

    private SqlExecuter<Boolean> createCheckExistSqlExecuter(final String sql, final String tableName) {
        return new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setString(1, tableName);
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                if (count <= 0) {
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected SqlExecuter<Integer> getTenantRecordDeleteExecuter(final int tenantId, final String tableName, String deletionUnitColumns, final int deleteRows) {
        return new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                String sql = "delete from " + tableName + " where tenant_id = ? and rownum <= ?";
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setInt(1, tenantId);
                ps.setInt(2, deleteRows);
                return ps.executeUpdate();
            }
        };
    }
}

