/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.TenantInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.DefaultTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLTenantRdbManager
extends DefaultTenantRdbManager {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLTenantRdbManager.class);
    private static final String SQL_EXIST_TENANT = "select 1 where exists (select * from t_tenant where url = ?)";
    private static final String SQL_EXIST_TABLE = "select count(*) from information_schema.tables where table_schema = ? and lower(table_name) = lower(?)";
    private static final String SQL_LAST_TENANT_ID = "select last_value from seq_t_tenant_id where is_called = true";
    private static final String SQL_IS_PARTITIONED_TABLE = "select 1 where exists (select oid from pg_class where relname = ? and relkind = 'p')";
    private static final String SQL_SELECT_PARTITION_TABLE = "select partition_name from (select substring(table_name from ?) as partition_name from information_schema.tables where table_schema = ? and table_name like ?) as p group by partition_name order by length(partition_name) desc, partition_name desc";
    private static final String SQL_COUNT_SUB_PARTITION = "select count(*) from information_schema.tables where table_schema = ? and table_name like ?";
    private static final String SQL_CREATE_PARTITION_TABLE = "create table \"%s_%d\" (like \"%s\" including defaults including constraints)";
    private static final String SQL_CREATE_SUB_PARTITION_TABLE = "create table \"%s_%d_%d\" partition of \"%s_%d\" for values with (modulus %d, remainder %d)";
    private static final String SQL_WITH_SUB_PARTITION = " partition by hash (\"obj_def_id\")";
    private static final String SQL_DROP_PARTITION_TABLE = "drop table if exists \"%s_%d\" cascade";
    private static final String SQL_ADD_CHECK_CONSTRAINT = "alter table \"%s_%d\" add constraint \"%s_%d_check\" check (tenant_id >= %d and tenant_id < %d)";
    private static final String SQL_DROP_CHECK_CONSTRAINT = "alter table \"%s_%d\" drop constraint \"%s_%d_check\"";
    private static final String SQL_ATTACH_PARTITION_TABLE = "alter table \"%s\" attach partition \"%s_%d\" for values from (%d) to (%d)";
    private static final String SQL_DETACH_PARTITION_TABLE = "alter table \"%s\" detach partition \"%s_%d\"";
    private RdbAdapter adapter;

    public PostgreSQLTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
        super(adapter, parameter);
        this.adapter = adapter;
    }

    @Override
    public boolean existsURL(final String url) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            public Boolean logic() throws SQLException {
                PreparedStatement statement = this.getPreparedStatement(PostgreSQLTenantRdbManager.SQL_EXIST_TENANT);
                String key = !url.startsWith("/") ? "/" + url : url;
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    Boolean bl = rs.next();
                    return bl;
                }
            }
        };
        return (Boolean)exec.execute(this.adapter, true);
    }

    @Override
    public boolean isSupportPartition() {
        return true;
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return (List)Transaction.required(t -> {
            ArrayList partitionList = new ArrayList();
            Stream.of(this.getTableList()).filter(table -> this.isPartitionTargetTable((String)table)).forEach(tableName -> {
                if (this.isStorageSpaceTable((String)tableName)) {
                    this.getStorageSpacePostfix(true).stream().filter(postfix -> this.isExistsTable(this.toStorageSpaceTableName((String)tableName, (String)postfix), true)).forEach(postfix -> {
                        if (this.isPartitionedTable(this.toStorageSpaceTableName((String)tableName, (String)postfix))) {
                            partitionList.add(this.getTablePartitionInfo((String)tableName, (String)postfix));
                        }
                    });
                } else if (this.isExistsTable((String)tableName, false) && this.isPartitionedTable((String)tableName)) {
                    partitionList.add(this.getTablePartitionInfo((String)tableName, null));
                }
            });
            return partitionList;
        });
    }

    private String toStorageSpaceTableName(String tableName, String postfix) {
        return postfix != null ? tableName + postfix.toLowerCase() : tableName;
    }

    private PartitionInfo getTablePartitionInfo(final String table, final String postfix) {
        SqlExecuter<PartitionInfo> exec = new SqlExecuter<PartitionInfo>(){

            public PartitionInfo logic() throws SQLException {
                String tableName = PostgreSQLTenantRdbManager.this.toStorageSpaceTableName(table, postfix);
                PreparedStatement ps = this.getPreparedStatement(PostgreSQLTenantRdbManager.SQL_SELECT_PARTITION_TABLE);
                ps.setString(1, tableName + "\\_[0-9]+");
                ps.setString(2, PostgreSQLTenantRdbManager.this.adapter.getConnection().getSchema());
                ps.setString(3, tableName + "\\_%");
                int maxTenantId = -1;
                TreeSet<String> partitionNames = new TreeSet<String>();
                try (ResultSet rs = ps.executeQuery();){
                    boolean isHead = true;
                    while (rs.next()) {
                        String partitionName = rs.getString(1);
                        if (!StringUtil.isNotEmpty((String)partitionName)) continue;
                        if (isHead) {
                            try {
                                maxTenantId = Integer.parseInt(partitionName.substring((tableName + "_").length()));
                            }
                            catch (NumberFormatException e) {
                                logger.warn("cant parse the partition name:" + partitionName);
                            }
                            isHead = false;
                        }
                        partitionNames.add(partitionName);
                    }
                }
                return new PartitionInfo(tableName, postfix, partitionNames, maxTenantId);
            }
        };
        return (PartitionInfo)exec.execute(this.adapter, true);
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
        return (Boolean)Transaction.requiresNew(t -> {
            this.doCreatePartition(param, logHandler);
            return true;
        });
    }

    private void doCreatePartition(PartitionCreateParameter param, LogHandler logHandler) {
        List<TenantInfo> validTenantList = this.getValidTenantInfoList();
        this.getPartitionInfo().forEach(info -> this.createTablePartition(param, (PartitionInfo)info, validTenantList, logHandler));
    }

    private void createTablePartition(PartitionCreateParameter param, PartitionInfo partitionInfo, List<TenantInfo> storeTenantList, LogHandler logHandler) {
        if (partitionInfo.getMaxTenantId() >= param.getTenantId()) {
            logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "skipPartitionMsg", partitionInfo.getMaxTenantId(), partitionInfo.getTableName()));
            return;
        }
        int lastTenantId = this.getLastTenantId();
        int maxPartitionId = partitionInfo.getMaxTenantId() > 0 ? partitionInfo.getMaxTenantId() : 0;
        ArrayList<Integer> addTenantIdList = new ArrayList<Integer>();
        if (maxPartitionId < lastTenantId) {
            storeTenantList.stream().filter(tenant -> tenant.getId() > maxPartitionId).forEach(tenant -> {
                addTenantIdList.add(tenant.getId());
                logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "createExistTenantPartitionMsg", tenant.getId()));
            });
        }
        for (int tenantId2 = lastTenantId + (param.isOnlyPartitionCreate() ? 1 : 0); tenantId2 <= param.getTenantId(); ++tenantId2) {
            if (partitionInfo.exists(tenantId2)) continue;
            if (maxPartitionId >= tenantId2) {
                logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "skipPartitionMsg", partitionInfo.getMaxTenantId(), partitionInfo.getTableName()));
                continue;
            }
            addTenantIdList.add(tenantId2);
        }
        addTenantIdList.forEach(tenantId -> this.executeTableCreatePartition(param, partitionInfo, (int)tenantId, logHandler));
    }

    private void executeTableCreatePartition(final PartitionCreateParameter param, PartitionInfo partitionInfo, final int tenantId, final LogHandler logHandler) {
        final ArrayList<String> sqlList = new ArrayList<String>();
        final String tableName = partitionInfo.getTableName();
        int tmpSubPartitionSize = param.getSubPartitionSize();
        if (tenantId < param.getTenantId() && StringUtil.isNotBlank((String)partitionInfo.getPostfix())) {
            tmpSubPartitionSize = this.getSubPartitionSize(tableName.substring(0, tableName.length() - partitionInfo.getPostfix().length()), tenantId);
        }
        int subPartitionSize = tmpSubPartitionSize;
        if (this.isSubPartitionTargetTable(tableName) && subPartitionSize > 0) {
            sqlList.add(this.toSqlCreatePartitionTableWithSubPartition(tableName, tenantId));
            IntStream.rangeClosed(0, subPartitionSize - 1).forEach(subNo -> sqlList.add(this.toSqlCreateSubPartitionTable(tableName, tenantId, subPartitionSize, subNo)));
        } else {
            sqlList.add(this.toSqlCreatePartitionTable(tableName, tenantId));
        }
        sqlList.add(this.toSqlAddCheckConstraint(tableName, tenantId));
        sqlList.add(this.toSqlAttachPartitionTable(tableName, tenantId));
        sqlList.add(this.toSqlDropCheckConstraint(tableName, tenantId));
        Transaction.requiresNew(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                public Void logic() throws SQLException {
                    Statement stmt = this.getStatement();
                    for (String sql : sqlList) {
                        stmt.addBatch(sql);
                    }
                    stmt.executeBatch();
                    logHandler.info(PostgreSQLTenantRdbManager.this.getPartitionResourceMessage(param.getLoggerLanguage(), "createdPartitionMsg", new Object[]{tableName + "_" + tenantId}));
                    return null;
                }
            };
            exec.execute(this.adapter, true);
            return null;
        });
    }

    @Override
    public boolean dropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        boolean isSuccess = (Boolean)Transaction.requiresNew(t -> {
            this.doDropPartition(param, logHandler);
            return true;
        });
        return isSuccess;
    }

    private void doDropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        Stream.of(this.getTableList()).filter(table -> this.isPartitionTargetTable((String)table)).forEach(tableName -> {
            if (this.isStorageSpaceTable((String)tableName)) {
                this.getStorageSpacePostfix(true).stream().filter(postfix -> this.isPartitionedTable(this.toStorageSpaceTableName((String)tableName, (String)postfix))).forEach(postfix -> this.executeTableDropPartition(param, this.toStorageSpaceTableName((String)tableName, (String)postfix), logHandler));
            } else if (this.isPartitionedTable((String)tableName)) {
                this.executeTableDropPartition(param, (String)tableName, logHandler);
            }
        });
    }

    private void executeTableDropPartition(final PartitionDeleteParameter param, final String tableName, final LogHandler logHandler) {
        if (!this.isExistsPartitionTable(tableName, param.getTenantId())) {
            return;
        }
        final ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(this.toSqlDetachPartitionTable(tableName, param.getTenantId()));
        sqlList.add(this.toSqlDropPartitionTable(tableName, param.getTenantId()));
        Transaction.requiresNew(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                public Void logic() throws SQLException {
                    Statement stmt = this.getStatement();
                    for (String sql : sqlList) {
                        stmt.addBatch(sql);
                    }
                    stmt.executeBatch();
                    logHandler.info(PostgreSQLTenantRdbManager.this.getPartitionResourceMessage(param.getLoggerLanguage(), "droppedPartitionMsg", new Object[]{tableName + "_" + param.getTenantId()}));
                    return null;
                }
            };
            try {
                exec.execute(this.adapter, true);
            }
            catch (Exception e) {
                logHandler.warn("partition cant dropped ...:" + tableName + "_" + param.getTenantId(), e);
            }
            return null;
        });
    }

    @Override
    protected boolean isExistsTable(String tableName) {
        SqlExecuter<Boolean> exec = this.createCheckExistSqlExecuter(SQL_EXIST_TABLE, tableName);
        return (Boolean)exec.execute(this.adapter, true);
    }

    private boolean isExistsPartitionTable(String tableName, int tenantId) {
        return this.isExistsTable(tableName + "_" + tenantId);
    }

    private String toSqlCreatePartitionTable(String tableName, int tenantId) {
        return String.format(SQL_CREATE_PARTITION_TABLE, tableName, tenantId, tableName);
    }

    private String toSqlCreatePartitionTableWithSubPartition(String tableName, int tenantId) {
        return this.toSqlCreatePartitionTable(tableName, tenantId) + SQL_WITH_SUB_PARTITION;
    }

    private String toSqlCreateSubPartitionTable(String tableName, int tenantId, int subPartitionSize, int subNo) {
        return String.format(SQL_CREATE_SUB_PARTITION_TABLE, tableName, tenantId, subNo, tableName, tenantId, subPartitionSize, subNo);
    }

    private String toSqlAddCheckConstraint(String tableName, int tenantId) {
        return String.format(SQL_ADD_CHECK_CONSTRAINT, tableName, tenantId, tableName, tenantId, tenantId, tenantId + 1);
    }

    private String toSqlDropCheckConstraint(String tableName, int tenantId) {
        return String.format(SQL_DROP_CHECK_CONSTRAINT, tableName, tenantId, tableName, tenantId);
    }

    private String toSqlAttachPartitionTable(String tableName, int tenantId) {
        return String.format(SQL_ATTACH_PARTITION_TABLE, tableName, tableName, tenantId, tenantId, tenantId + 1);
    }

    private String toSqlDetachPartitionTable(String tableName, int tenantId) {
        return String.format(SQL_DETACH_PARTITION_TABLE, tableName, tableName, tenantId);
    }

    private String toSqlDropPartitionTable(String tableName, int tenantId) {
        return String.format(SQL_DROP_PARTITION_TABLE, tableName, tenantId);
    }

    private SqlExecuter<Boolean> createCheckExistSqlExecuter(final String sql, final String tableName) {
        return new SqlExecuter<Boolean>(){

            public Boolean logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setString(1, PostgreSQLTenantRdbManager.this.adapter.getConnection().getSchema());
                ps.setString(2, tableName);
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                return count > 0;
            }
        };
    }

    private int getLastTenantId() {
        return (Integer)new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                Statement stmt = this.getStatement();
                try (ResultSet rs = stmt.executeQuery(PostgreSQLTenantRdbManager.SQL_LAST_TENANT_ID);){
                    Integer n = rs.next() ? Integer.valueOf(rs.getInt(1)) : Integer.valueOf(0);
                    return n;
                }
            }
        }.execute(this.adapter, true);
    }

    private boolean isPartitionedTable(final String tableName) {
        return (Boolean)new SqlExecuter<Boolean>(){

            public Boolean logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(PostgreSQLTenantRdbManager.SQL_IS_PARTITIONED_TABLE);
                ps.setString(1, tableName);
                try (ResultSet rs = ps.executeQuery();){
                    Boolean bl = rs.next();
                    return bl;
                }
            }
        }.execute(this.adapter, true);
    }

    private int getSubPartitionSize(final String tableName, final int tenantId) {
        return (Integer)new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(PostgreSQLTenantRdbManager.SQL_COUNT_SUB_PARTITION);
                ps.setString(1, PostgreSQLTenantRdbManager.this.adapter.getConnection().getSchema());
                ps.setString(2, tableName + "\\_" + tenantId + "\\_%");
                try (ResultSet rs = ps.executeQuery();){
                    rs.next();
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
        }.execute(this.adapter, true);
    }

    private String getPartitionResourceMessage(String lang, String suffix, Object ... args) {
        return ToolsResourceBundleUtil.resourceString(lang, "tenant.partition." + suffix, args);
    }

    @Override
    protected SqlExecuter<Integer> getTenantRecordDeleteExecuter(final int tenantId, final String tableName, final String deletionUnitColumns, final int deleteRows) {
        if (StringUtil.isNotEmpty((String)deletionUnitColumns)) {
            return new SqlExecuter<Integer>(){

                public Integer logic() throws SQLException {
                    String sql = "delete from " + tableName + " where (" + deletionUnitColumns + ") in (select " + deletionUnitColumns + " from " + tableName + " where tenant_id = ? limit ?)";
                    PreparedStatement ps = this.getPreparedStatement(sql);
                    ps.setInt(1, tenantId);
                    ps.setInt(2, deleteRows);
                    return ps.executeUpdate();
                }
            };
        }
        return new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                String sql = "delete from " + tableName + " where tenant_id = ?";
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setInt(1, tenantId);
                return ps.executeUpdate();
            }
        };
    }
}

