/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.tools.ToolsResourceBundleUtil;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.DefaultTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;
import org.iplass.mtp.transaction.Transaction;

public class SqlServerTenantRdbManager
extends DefaultTenantRdbManager {
    private static final String FILEGROUP_NAME = "FG_MTDB";
    private static final String PARTITION_FUNCTION_NAME = "PF_MTDB";
    private static final String PARTITION_SCHEME_NAME = "PS_MTDB";
    private static final String FMT_FILE = "%s_%d";
    private static final String FMT_FILE_NAME = "%s_%d.ndf";
    private static final String FMT_FILEGROUP_NAME = "FG_MTDB_%d";
    private static final String SQL_TENANT_EXISTS = "select 1 where exists (select * from t_tenant where url = ?)";
    private static final String SQL_GET_DB_NAME = "SELECT DB_NAME()";
    private static final String SQL_GET_DB_FILE_PATH_TEMPLATE = "SELECT LEFT(PHYSICAL_NAME, LEN(PHYSICAL_NAME) - CHARINDEX('\\', REVERSE(PHYSICAL_NAME) + '\\'))FROM (SELECT PHYSICAL_NAME FROM SYS.DATABASE_FILES WHERE NAME = '%s') AS PHYSICAL_NAME";
    private static final String SQL_ADD_FILEGROUP = "ALTER DATABASE %s ADD FILEGROUP %s";
    private static final String SQL_ADD_FILEGROUP_FILE = "ALTER DATABASE %s ADD FILE (NAME = %s, FILENAME = '%s', SIZE = 5MB, FILEGROWTH = 1MB) TO FILEGROUP %s";
    private static final String SQL_MOD_PARTITION_FUNCTION = "ALTER PARTITION FUNCTION PF_MTDB() SPLIT RANGE (%d)";
    private static final String SQL_MOD_PARTITION_SCHEME = "ALTER PARTITION SCHEME PS_MTDB NEXT USED %s";
    private static final String SQL_EXIST_PARTITION_FUNCTION = "SELECT 'X' FROM SYS.PARTITION_FUNCTIONS WHERE NAME='PF_MTDB'";
    private static final String SQLSERVER_EXIST_TABLE_SQL = "select count(*) from sys.tables where lower(name) = lower(?)";
    private static final String SQLSERVER_EXIST_SYNONYM_SQL = "select count(*) from sys.synonyms where lower(name) = lower(?)";
    private RdbAdapter adapter;
    private String sqlGetDbFilePath;

    public SqlServerTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
        super(adapter, parameter);
        this.adapter = adapter;
        String pathSeparator = this.isDbServerOSWindows(adapter) ? "\\\\" : "/";
        this.sqlGetDbFilePath = SQL_GET_DB_FILE_PATH_TEMPLATE.replaceAll("\\\\", pathSeparator);
    }

    @Override
    public boolean existsURL(final String url) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                PreparedStatement statement = this.getPreparedStatement(SqlServerTenantRdbManager.SQL_TENANT_EXISTS);
                String key = !url.startsWith("/") ? "/" + url : url;
                statement.setString(1, key);
                try (ResultSet rs = statement.executeQuery();){
                    Boolean bl = rs.next();
                    return bl;
                }
            }
        };
        return (Boolean)exec.execute(this.adapter, true);
    }

    @Override
    public boolean isSupportPartition() {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            public Boolean logic() throws SQLException {
                return this.getPreparedStatement(SqlServerTenantRdbManager.SQL_EXIST_PARTITION_FUNCTION).executeQuery().next();
            }
        };
        return (Boolean)exec.execute(this.adapter, true);
    }

    @Override
    public List<PartitionInfo> getPartitionInfo() {
        return null;
    }

    @Override
    public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
        if (param.getTenantId() <= 1) {
            return true;
        }
        if (!this.isSupportPartition()) {
            return true;
        }
        return this.createPartitionInternal(param, logHandler);
    }

    private boolean createPartitionInternal(PartitionCreateParameter param, LogHandler logHandler) {
        try {
            return (Boolean)Transaction.required(transaction -> {
                transaction.commit();
                this.doCreatePartition(param, logHandler);
                logHandler.info(this.getPartitionResourceMessage(param.getLoggerLanguage(), "createdPartitionMsg", param.getTenantId()));
                return Boolean.TRUE;
            });
        }
        catch (Throwable e) {
            logHandler.error(this.getCommonResourceMessage(param.getLoggerLanguage(), "errorMsg", e.getMessage()));
            return false;
        }
    }

    private void doCreatePartition(PartitionCreateParameter param, LogHandler logHandler) {
        String dbName = this.getDBName();
        String fgn = this.addFileGroup(dbName, param.getTenantId());
        this.addFileToFileGroup(dbName, param.getTenantId(), fgn);
        this.modifyPartitionScheme(param.getTenantId(), fgn);
        this.modifyPartitionFunction(param.getTenantId());
    }

    private String getDBName() {
        SqlExecuter<String> exec = new SqlExecuter<String>(){

            public String logic() throws SQLException {
                ResultSet rs = this.getPreparedStatement(SqlServerTenantRdbManager.SQL_GET_DB_NAME).executeQuery();
                rs.next();
                return rs.getString(1);
            }
        };
        return (String)exec.execute(this.adapter, true);
    }

    private String getDBFilePath(final String dbName) {
        SqlExecuter<String> exec = new SqlExecuter<String>(){

            public String logic() throws SQLException {
                String sql = String.format(SqlServerTenantRdbManager.this.sqlGetDbFilePath, dbName);
                ResultSet rs = this.getPreparedStatement(sql).executeQuery();
                rs.next();
                return rs.getString(1);
            }
        };
        return (String)exec.execute(this.adapter, true);
    }

    private String addFileGroup(String dbName, int tenantId) {
        String fgn = String.format(FMT_FILEGROUP_NAME, tenantId);
        String sql = String.format(SQL_ADD_FILEGROUP, dbName, fgn);
        this.executeAlter(sql);
        return fgn;
    }

    private void addFileToFileGroup(String dbName, int tenantId, String fileGroupName) {
        String sql = String.format(SQL_ADD_FILEGROUP_FILE, dbName, String.format(FMT_FILE, dbName, tenantId), this.getDBFilePath(dbName) + File.separator + String.format(FMT_FILE_NAME, dbName, tenantId), fileGroupName);
        this.executeAlter(sql);
    }

    private void modifyPartitionScheme(int tenantId, String fileGroupName) {
        String sql = String.format(SQL_MOD_PARTITION_SCHEME, fileGroupName);
        this.executeAlter(sql);
    }

    private void modifyPartitionFunction(int tenantId) {
        String sql = String.format(SQL_MOD_PARTITION_FUNCTION, tenantId);
        this.executeAlter(sql);
    }

    private void executeAlter(final String sql) {
        Transaction.requiresNew(t -> {
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                public Void logic() throws SQLException {
                    this.getPreparedStatement(sql).execute();
                    return null;
                }
            };
            exec.execute(this.adapter, true);
            return null;
        });
    }

    @Override
    public boolean dropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
        return true;
    }

    @Override
    protected boolean isExistsTable(String tableName) {
        SqlExecuter<Boolean> exec = this.createCheckExistSqlExecuter(SQLSERVER_EXIST_TABLE_SQL, tableName);
        if (((Boolean)exec.execute(this.adapter, true)).booleanValue()) {
            return true;
        }
        exec = this.createCheckExistSqlExecuter(SQLSERVER_EXIST_SYNONYM_SQL, tableName);
        return (Boolean)exec.execute(this.adapter, true);
    }

    private SqlExecuter<Boolean> createCheckExistSqlExecuter(final String sql, final String tableName) {
        return new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setString(1, tableName);
                int count = 0;
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                if (count <= 0) {
                    return false;
                }
                return true;
            }
        };
    }

    private String getPartitionResourceMessage(String lang, String suffix, Object ... args) {
        return ToolsResourceBundleUtil.resourceString(lang, "tenant.partition." + suffix, args);
    }

    private String getCommonResourceMessage(String lang, String subKey, Object ... args) {
        return ToolsResourceBundleUtil.commonResourceString(lang, subKey, args);
    }

    @Override
    protected SqlExecuter<Integer> getTenantRecordDeleteExecuter(final int tenantId, final String tableName, String deletionUnitColumns, final int deleteRows) {
        return new SqlExecuter<Integer>(){

            public Integer logic() throws SQLException {
                String sql = "delete top(?) from " + tableName + " where tenant_id = ?";
                PreparedStatement ps = this.getPreparedStatement(sql);
                ps.setInt(1, deleteRows);
                ps.setInt(2, tenantId);
                return ps.executeUpdate();
            }
        };
    }

    protected boolean isDbServerOSWindows(RdbAdapter adapter) {
        SqlExecuter<String> executer = new SqlExecuter<String>(){

            public String logic() throws SQLException {
                String sql = "select @@VERSION";
                Statement ps = this.getStatement();
                try (ResultSet rs = ps.executeQuery(sql);){
                    String string = rs.next() ? rs.getString(1) : "";
                    return string;
                }
            }
        };
        String version = (String)executer.execute(adapter, true);
        return version.toUpperCase().indexOf("WINDOWS") > 0;
    }
}

