/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface TenantRdbConstants {
    public static final Map<String, String> TABLE_LIST_DELETION_UNIT_COLS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("counter", "tenant_id, cnt_name, inc_unit_key");
            this.put("crawl_log", "tenant_id, obj_def_id, obj_def_ver");
            this.put("delete_log", "tenant_id, obj_def_id, obj_id, obj_ver");
            this.put("lob_store", "tenant_id, lob_data_id");
            this.put("obj_blob", "tenant_id, lob_id");
            this.put("obj_blob_rb", "tenant_id, rb_id");
            this.put("obj_data", "");
            this.put("obj_data_rb", "");
            this.put("obj_store", "tenant_id, obj_def_id, obj_id, obj_ver, pg_no");
            this.put("obj_store_rb", "tenant_id, obj_def_id, rb_id");
            this.put("obj_ref", "tenant_id, obj_def_id, ref_def_id, obj_id, obj_ver");
            this.put("obj_ref_rb", "rb_id, tenant_id, obj_def_id, ref_def_id, obj_id, obj_ver");
            this.put("obj_index_date", "tenant_id, obj_def_id, col_name, obj_id, obj_ver");
            this.put("obj_index_dbl", "tenant_id, obj_def_id, col_name, obj_id, obj_ver");
            this.put("obj_index_num", "tenant_id, obj_def_id, col_name, obj_id, obj_ver");
            this.put("obj_index_str", "tenant_id, obj_def_id, col_name, obj_id, obj_ver");
            this.put("obj_index_ts", "tenant_id, obj_def_id, col_name, obj_id, obj_ver");
            this.put("obj_unique_date", "tenant_id, obj_def_id, col_name, obj_id");
            this.put("obj_unique_dbl", "tenant_id, obj_def_id, col_name, obj_id");
            this.put("obj_unique_num", "tenant_id, obj_def_id, col_name, obj_id");
            this.put("obj_unique_str", "tenant_id, obj_def_id, col_name, obj_id");
            this.put("obj_unique_ts", "tenant_id, obj_def_id, col_name, obj_id");
            this.put("obj_meta", "tenant_id, obj_def_id, obj_def_ver");
            this.put("schema_ctrl", "tenant_id, obj_def_id");
            this.put("task_queue", "q_id, tenant_id, task_id");
            this.put("task_queue_hi", "q_id, tenant_id, task_id");
        }
    });
    public static final String[] TABLE_LIST = TABLE_LIST_DELETION_UNIT_COLS.keySet().toArray(new String[TABLE_LIST_DELETION_UNIT_COLS.size()]);
    public static final Set<String> EXCLUDE_PARTITION_TABLE = Stream.of("crawl_log", "obj_meta", "task_queue").collect(Collectors.toSet());
    public static final int MAX_SUBPARTITION = 8;
    public static final int MIN_SUBPARTITION = 0;
    public static final Set<String> EXCLUDE_SUB_PARTITION_TABLE = Stream.of("obj_blob", "lob_store", "obj_blob_rb", "counter", "task_queue_hi").collect(Collectors.toSet());
    public static final Set<String> CHECK_EXIST_TABLE = Stream.of("crawl_log", "delete_log", "task_queue", "task_queue_hi", "obj_data", "obj_data_rb").collect(Collectors.toSet());
    public static final Set<String> STORAGE_SPACE_TABLE = Stream.of("obj_store", "obj_store_rb", "obj_ref", "obj_ref_rb", "obj_index_date", "obj_index_dbl", "obj_index_num", "obj_index_str", "obj_index_ts", "obj_unique_date", "obj_unique_dbl", "obj_unique_num", "obj_unique_str", "obj_unique_ts").collect(Collectors.toSet());
}

