/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tools.tenant.rdb;

import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.mysql.MysqlRdbAdaptor;
import org.iplass.mtp.impl.rdb.oracle.OracleRdbAdapter;
import org.iplass.mtp.impl.rdb.postgresql.PostgreSQLRdbAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.SqlServerRdbAdapter;
import org.iplass.mtp.impl.tools.tenant.PartitionCreateParameter;
import org.iplass.mtp.impl.tools.tenant.PartitionInfo;
import org.iplass.mtp.impl.tools.tenant.log.LogHandler;
import org.iplass.mtp.impl.tools.tenant.rdb.DefaultTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.MySQLTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.OracleTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.PartitionDeleteParameter;
import org.iplass.mtp.impl.tools.tenant.rdb.PostgreSQLTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.SqlServerTenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManager;
import org.iplass.mtp.impl.tools.tenant.rdb.TenantRdbManagerParameter;

public class TenantRdbManagerFactory {
    public TenantRdbManager createManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
        if (adapter instanceof OracleRdbAdapter) {
            return new OracleTenantRdbManager(adapter, parameter);
        }
        if (adapter instanceof MysqlRdbAdaptor) {
            return new MySQLTenantRdbManager(adapter, parameter);
        }
        if (adapter instanceof SqlServerRdbAdapter) {
            return new SqlServerTenantRdbManager(adapter, parameter);
        }
        if (adapter instanceof PostgreSQLRdbAdapter) {
            return new PostgreSQLTenantRdbManager(adapter, parameter);
        }
        return new EmptyTenantRdbManager(adapter, parameter);
    }

    private static class EmptyTenantRdbManager
    extends DefaultTenantRdbManager {
        public EmptyTenantRdbManager(RdbAdapter adapter, TenantRdbManagerParameter parameter) {
            super(adapter, parameter);
        }

        @Override
        public boolean isSupportPartition() {
            return false;
        }

        @Override
        public List<PartitionInfo> getPartitionInfo() {
            return null;
        }

        @Override
        public boolean createPartition(PartitionCreateParameter param, LogHandler logHandler) {
            return false;
        }

        @Override
        public boolean dropPartition(PartitionDeleteParameter param, LogHandler logHandler) {
            return false;
        }

        @Override
        protected boolean isExistsTable(String tableName) {
            return false;
        }

        @Override
        protected SqlExecuter<Integer> getTenantRecordDeleteExecuter(int tenantId, String tableName, String uniqueColumn, int deleteRows) {
            return new SqlExecuter<Integer>(){

                public Integer logic() throws SQLException {
                    return 0;
                }
            };
        }
    }
}

