/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.code;

import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCodeStore;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationRequest;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;

public class CacheAuthorizationCodeStore
implements AuthorizationCodeStore,
ServiceInitListener<OAuthAuthorizationService> {
    public static final String DEFAULT_CACHE_NAMESPACE = "mtp.oauth.codeStore";
    public static final String DEFAULT_SECURE_RANDOM_GENERATOR_NAME = "oauthAuthorizationCodeGenerator";
    private String secureRandomGeneratorName = "oauthAuthorizationCodeGenerator";
    private String cacheStoreName = "mtp.oauth.codeStore";
    private long timeToLive = 180000L;
    private CacheStore cache;
    private SecureRandomGenerator generator;

    public String getCacheStoreName() {
        return this.cacheStoreName;
    }

    public void setCacheStoreName(String cacheStoreName) {
        this.cacheStoreName = cacheStoreName;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getSecureRandomGeneratorName() {
        return this.secureRandomGeneratorName;
    }

    public void setSecureRandomGeneratorName(String secureRandomGeneratorName) {
        this.secureRandomGeneratorName = secureRandomGeneratorName;
    }

    public void inited(OAuthAuthorizationService service, Config config) {
        CacheService cs = (CacheService)ServiceRegistry.getRegistry().getService(CacheService.class);
        this.cache = cs.getCache(this.cacheStoreName);
        this.generator = ((SecureRandomService)ServiceRegistry.getRegistry().getService(SecureRandomService.class)).createGenerator(this.secureRandomGeneratorName);
    }

    public void destroyed() {
    }

    private String toKey(String code) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        StringBuilder sb = new StringBuilder();
        sb.append(tenantId).append("-").append(code);
        return sb.toString();
    }

    @Override
    public AuthorizationCode newAuthorizationCode(AuthorizationRequest authReq) {
        AuthorizationCode code;
        String codeValue;
        CacheEntry ce;
        do {
            codeValue = this.generator.secureRandomToken();
            code = new AuthorizationCode();
            code.setCodeValue(codeValue);
            code.setRequest(authReq);
            code.setExpires(System.currentTimeMillis() + this.timeToLive);
        } while (this.cache.putIfAbsent(ce = new CacheEntry((Object)this.toKey(codeValue), (Object)code, new Object[0])) != null);
        return code;
    }

    @Override
    public AuthorizationCode getAndRemoveAuthorizationCode(String codeValue) {
        AuthorizationCode code;
        CacheEntry ce = this.cache.remove((Object)this.toKey(codeValue));
        if (ce != null && (code = (AuthorizationCode)ce.getValue()).getExpires() > System.currentTimeMillis()) {
            return code;
        }
        return null;
    }
}

