/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.report;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.report.JxlsReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingEngine;
import org.iplass.mtp.impl.report.ReportingOutputModel;
import org.iplass.mtp.impl.report.ReportingType;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.template.report.MetaReportParamMap;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.report.definition.JxlsReportType;
import org.jxls.common.Context;

public class JxlsReportingEngine
implements ReportingEngine {
    private String[] supportFiles;
    private static final String SESSION_STR = "session";
    private static final String REQUEST_STR = "request";
    private static final String PREFIX_REQUEST = "request.";
    private static final String PREFIX_SESSION = "session.";

    @Override
    public ReportingOutputModel createOutputModel(byte[] binary, String type, String extension) throws Exception {
        return new JxlsReportingOutputModel(binary, type, extension);
    }

    @Override
    public void exportReport(WebRequestStack requestStack, ReportingOutputModel model) throws Exception {
        JxlsReportingOutputModel jxlsModel = (JxlsReportingOutputModel)model;
        RequestContext request = requestStack.getRequestContext();
        Context context = new Context();
        if (jxlsModel.getParamMap() != null) {
            this.putVar(request, context, jxlsModel.getParamMap());
        }
        String password = null;
        if (StringUtil.isNotEmpty((String)jxlsModel.getPasswordAttributeName())) {
            password = (String)this.getAttribute(request, jxlsModel.getPasswordAttributeName());
        }
        jxlsModel.write(context, (OutputStream)requestStack.getResponse().getOutputStream(), password);
    }

    private void putVar(RequestContext request, Context context, MetaReportParamMap[] paramMap) {
        Object val;
        for (int i = 0; i < paramMap.length && (val = this.getAttribute(request, paramMap[i].getMapFrom())) != null; ++i) {
            if (paramMap[i].isConvertEntityToMap()) {
                if (val instanceof GenericEntity) {
                    context.putVar(paramMap[i].getName(), (Object)((GenericEntity)val).toMap());
                    continue;
                }
                if (val instanceof List) {
                    ArrayList<Map> entityMaps = new ArrayList<Map>();
                    List list = (List)val;
                    for (Object obj : list) {
                        if (!(obj instanceof GenericEntity)) continue;
                        entityMaps.add(((GenericEntity)obj).toMap());
                    }
                    context.putVar(paramMap[i].getName(), entityMaps);
                    continue;
                }
                context.putVar(paramMap[i].getName(), val);
                continue;
            }
            context.putVar(paramMap[i].getName(), val);
        }
    }

    private Object getAttribute(RequestContext request, String attributeName) {
        if (attributeName.startsWith(PREFIX_REQUEST)) {
            String valueName = attributeName.substring(PREFIX_REQUEST.length());
            return request.getAttribute(valueName);
        }
        if (attributeName.startsWith(PREFIX_SESSION)) {
            String valueName = attributeName.substring(PREFIX_SESSION.length());
            return request.getSession().getAttribute(valueName);
        }
        return request.getAttribute(attributeName);
    }

    @Override
    public boolean isSupport(String type) {
        for (String supportFile : this.supportFiles) {
            if (!supportFile.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportFiles() {
        return this.supportFiles;
    }

    public void setSupportFiles(String[] supportFiles) {
        this.supportFiles = supportFiles;
    }

    @Override
    public ReportingType getReportingType() {
        ReportingType type = new ReportingType();
        type.setName(JxlsReportType.class.getName());
        type.setDisplayName("JXLS");
        return type;
    }
}

