/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.command.RequestContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.RequestPath;
import org.iplass.mtp.impl.web.WebRequestContext;

public final class WebRequestStack {
    public static final String CALL_STACK_NAME = "mtp.web.RequestStack";
    private RequestPath requestPath;
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PageContext pageContext;
    private WebRequestStack prevStack;
    private HashMap<String, Object> stackAttribute;
    private RequestContext webRequestContext;
    private boolean isLayoutStack;
    private boolean isIncludeStack;
    private boolean isIncludeTemplateStack;
    private boolean isRenderContentStack;

    public static WebRequestStack getCurrent() {
        return (WebRequestStack)ExecuteContext.getCurrentContext().getAttribute(CALL_STACK_NAME);
    }

    public WebRequestStack(RequestPath requestPath, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this(requestPath, null, servletContext, request, response, null);
    }

    public WebRequestStack(RequestContext webRequestContext, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext) {
        this(null, webRequestContext, servletContext, request, response, pageContext);
    }

    public WebRequestStack() throws IOException {
        this(null, null, null, null, null, null);
    }

    public WebRequestStack(RequestPath requestPath, RequestContext webRequestContext, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        this.prevStack = (WebRequestStack)ec.getAttribute(CALL_STACK_NAME);
        this.requestPath = this.prevStack != null && requestPath == null ? this.prevStack.requestPath : requestPath;
        this.webRequestContext = webRequestContext == null ? (this.prevStack != null ? this.prevStack.webRequestContext : new WebRequestContext(servletContext, request)) : webRequestContext;
        this.servletContext = this.prevStack != null && servletContext == null ? this.prevStack.servletContext : servletContext;
        this.request = this.prevStack != null && request == null ? this.prevStack.request : request;
        this.response = this.prevStack != null && response == null ? this.prevStack.response : response;
        this.pageContext = this.prevStack != null && pageContext == null ? this.prevStack.pageContext : pageContext;
        ec.setAttribute(CALL_STACK_NAME, (Object)this, true);
        RequestContextHolder.setCurrent((RequestContext)this.webRequestContext);
    }

    public boolean isIncludeTemplateStack() {
        return this.isIncludeTemplateStack;
    }

    public void setIncludeTemplateStack(boolean isIncludeTemplateStack) {
        this.isIncludeTemplateStack = isIncludeTemplateStack;
    }

    public boolean isIncludeStack() {
        return this.isIncludeStack;
    }

    public void setIncludeStack(boolean isIncludeStack) {
        this.isIncludeStack = isIncludeStack;
    }

    public boolean isRenderContentStack() {
        return this.isRenderContentStack;
    }

    public void setRenderContentStack(boolean isRenderContentStack) {
        this.isRenderContentStack = isRenderContentStack;
    }

    public boolean isLayoutStack() {
        return this.isLayoutStack;
    }

    public void setLayoutStack(boolean isLayoutStack) {
        this.isLayoutStack = isLayoutStack;
    }

    void shareStackAttributeContext(WebRequestStack owner) {
        this.stackAttribute = owner.stackAttribute;
    }

    public WebRequestStack getPrevStack() {
        return this.prevStack;
    }

    public Object getAttribute(String name) {
        if (this.stackAttribute == null) {
            return null;
        }
        return this.stackAttribute.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.stackAttribute == null) {
            this.stackAttribute = new HashMap();
        }
        this.stackAttribute.put(name, value);
    }

    public RequestPath getRequestPath() {
        return this.requestPath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public boolean isClientDirectRequest() {
        return this.prevStack == null;
    }

    public RequestContext getRequestContext() {
        return this.webRequestContext;
    }

    public void finallyProcess() {
        try {
            if (this.prevStack == null && this.webRequestContext != null && this.webRequestContext instanceof WebRequestContext) {
                ((WebRequestContext)this.webRequestContext).finallyProcess();
            }
        }
        finally {
            this.stackAttribute = null;
            ExecuteContext ec = ExecuteContext.getCurrentContext();
            ec.setAttribute(CALL_STACK_NAME, (Object)this.prevStack, true);
            if (this.prevStack != null) {
                RequestContextHolder.setCurrent((RequestContext)this.prevStack.webRequestContext);
            } else {
                RequestContextHolder.setCurrent(null);
            }
        }
    }
}

