/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.iplass.mtp.impl.web.fileupload.MagicByteRuleCondition;

public class MagicByteRule {
    private MagicByteRuleCondition mimeType;
    private MagicByteRuleCondition extension;
    private List<String> magicByte;
    private List<byte[]> magicByteList;

    public MagicByteRuleCondition getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MagicByteRuleCondition mimeType) {
        this.mimeType = mimeType;
        this.mimeType.compilePattern();
    }

    public MagicByteRuleCondition getExtension() {
        return this.extension;
    }

    public void setExtension(MagicByteRuleCondition extension) {
        this.extension = extension;
        this.extension.compilePattern();
    }

    public List<String> getMagicByte() {
        return this.magicByte;
    }

    public void setMagicByte(List<String> magicByte) throws DecoderException {
        this.magicByte = magicByte;
        if (magicByte != null) {
            this.magicByteList = new ArrayList<byte[]>();
            for (String magicByteStr : magicByte) {
                this.magicByteList.add(Hex.decodeHex((char[])magicByteStr.toCharArray()));
            }
        }
    }

    public boolean matchMimeType(String mimeType) {
        return this.mimeType == null || this.mimeType.match(mimeType);
    }

    public boolean matchExtension(String extension) {
        return this.extension == null || this.extension.match(extension);
    }

    public boolean matchMagicByte(byte[] inputMagicByte) {
        if (CollectionUtils.isEmpty(this.magicByteList)) {
            return true;
        }
        return this.magicByteList.stream().anyMatch(m -> this.matchMagicByte((byte[])m, inputMagicByte));
    }

    private boolean matchMagicByte(byte[] magicByte, byte[] inputMagicByte) {
        for (int index = 0; index < magicByte.length; ++index) {
            if (magicByte[index] == inputMagicByte[index]) continue;
            return false;
        }
        return true;
    }
}

