/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.interceptors;

import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.actionmapping.MetaTokenCheck;
import org.iplass.mtp.impl.web.actionmapping.WebInvocationImpl;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.web.actionmapping.TokenValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenInterceptor
implements CommandInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TokenInterceptor.class);

    private void doError(MetaTokenCheck tokenCheck) {
        throw new TokenValidationException(TokenInterceptor.resourceString("impl.web.interceptors.TokenInterceptor.invalidErr", new Object[0]));
    }

    public String intercept(CommandInvocation invocation) {
        if (invocation instanceof WebInvocationImpl) {
            WebInvocationImpl webInvocation = (WebInvocationImpl)invocation;
            MetaTokenCheck tokenCheck = webInvocation.getAction().getMetaData().getTokenCheck();
            if (tokenCheck != null) {
                SessionContext session;
                TokenStore tokenStore;
                logger.trace("execute validate token...");
                String token = invocation.getRequest().getParam("_t");
                if (token == null) {
                    this.doError(tokenCheck);
                }
                if ((tokenStore = TokenStore.getTokenStore(session = invocation.getRequest().getSession())) == null) {
                    this.doError(tokenCheck);
                }
                boolean isValid = false;
                try {
                    isValid = tokenCheck.isUseFixedToken() ? tokenStore.isValidFixed(token) : tokenStore.isValid(token, tokenCheck.isConsume());
                    if (!isValid) {
                        this.doError(tokenCheck);
                    }
                    return invocation.proceedCommand();
                }
                catch (RuntimeException e) {
                    if (isValid && !tokenCheck.isUseFixedToken() && tokenCheck.isExceptionRollback() && tokenCheck.isConsume()) {
                        tokenStore.pushBack(token);
                    }
                    throw e;
                }
            }
            return invocation.proceedCommand();
        }
        return invocation.proceedCommand();
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

